/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

public class LittleEndian {
    private LittleEndian() {
    }

    public static short getShort(byte[] data, int offset) {
        return (short)LittleEndian.getNumber(data, offset, 2);
    }

    public static int getUShort(byte[] data, int offset) {
        int num = (int)LittleEndian.getNumber(data, offset, 2);
        int retNum = num < 0 ? 65536 + num : num;
        return retNum;
    }

    public static int getInt(byte[] data, int offset) {
        return (int)LittleEndian.getNumber(data, offset, 4);
    }

    public static long getUInt(byte[] data, int offset) {
        int num = (int)LittleEndian.getNumber(data, offset, 4);
        long retNum = num < 0 ? 0x100000000L + (long)num : (long)num;
        return retNum;
    }

    public static long getLong(byte[] data, int offset) {
        return LittleEndian.getNumber(data, offset, 8);
    }

    public static void putShort(byte[] data, int offset, short value) {
        LittleEndian.putNumber(data, offset, value, 2);
    }

    public static void putShort(byte[] data, short value) {
        LittleEndian.putShort(data, 0, value);
    }

    public static void putInt(byte[] data, int offset, int value) {
        LittleEndian.putNumber(data, offset, value, 4);
    }

    private static long getNumber(byte[] data, int offset, int size) {
        long result = 0L;
        for (int j = offset + size - 1; j >= offset; --j) {
            result <<= 8;
            result |= (long)(0xFF & data[j]);
        }
        return result;
    }

    private static void putNumber(byte[] data, int offset, long value, int size) {
        int limit = size + offset;
        long v = value;
        for (int j = offset; j < limit; ++j) {
            data[j] = (byte)(v & 0xFFL);
            v >>= 8;
        }
    }
}

