/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.EntryNode;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.Property;

public class DirectoryNode
extends EntryNode
implements DirectoryEntry {
    private Map _entries;
    private POIFSFileSystem _filesystem;
    private POIFSDocumentPath _path;

    DirectoryNode(DirectoryProperty property, POIFSFileSystem filesystem, DirectoryNode parent) {
        super(property, parent);
        this._path = parent == null ? new POIFSDocumentPath() : new POIFSDocumentPath(parent._path, new String[]{property.getName()});
        this._filesystem = filesystem;
        this._entries = new HashMap();
        Iterator iter = property.getChildren();
        while (iter.hasNext()) {
            Property child = (Property)iter.next();
            EntryNode childNode = null;
            childNode = child.isDirectory() ? new DirectoryNode((DirectoryProperty)child, this._filesystem, this) : new DocumentNode((DocumentProperty)child, this);
            this._entries.put(childNode.getName(), childNode);
        }
    }

    DocumentEntry createDocument(POIFSDocument document) throws IOException {
        DocumentProperty property = document.getDocumentProperty();
        DocumentNode rval = new DocumentNode(property, this);
        ((DirectoryProperty)this.getProperty()).addChild(property);
        this._filesystem.addDocument(document);
        this._entries.put(property.getName(), rval);
        return rval;
    }

    public Iterator getEntries() {
        return this._entries.values().iterator();
    }

    public Entry getEntry(String name) throws FileNotFoundException {
        Entry rval = null;
        if (name != null) {
            rval = (Entry)this._entries.get(name);
        }
        if (rval == null) {
            throw new FileNotFoundException("no such entry: \"" + name + "\"");
        }
        return rval;
    }

    public DirectoryEntry createDirectory(String name) throws IOException {
        DirectoryProperty property = new DirectoryProperty(name);
        DirectoryNode rval = new DirectoryNode(property, this._filesystem, this);
        ((DirectoryProperty)this.getProperty()).addChild(property);
        this._filesystem.addDirectory(property);
        this._entries.put(name, rval);
        return rval;
    }

    public void setStorageClsid(ClassID clsidStorage) {
        this.getProperty().setStorageClsid(clsidStorage);
    }
}

