/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.Util;
import org.apache.poi.util.LittleEndian;

public class PropertySet {
    static final byte[] BYTE_ORDER_ASSERTION = new byte[]{-2, -1};
    protected int byteOrder;
    static final byte[] FORMAT_ASSERTION = new byte[]{0, 0};
    protected int format;
    protected int osVersion;
    protected ClassID classID;
    protected int sectionCount;
    protected List sections;

    public List getSections() {
        return this.sections;
    }

    protected PropertySet() {
    }

    public PropertySet(InputStream stream) throws NoPropertySetStreamException, MarkUnsupportedException, IOException {
        if (!PropertySet.isPropertySetStream(stream)) {
            throw new NoPropertySetStreamException();
        }
        int avail = stream.available();
        byte[] buffer = new byte[avail];
        stream.read(buffer, 0, buffer.length);
        this.init(buffer, 0, buffer.length);
    }

    public static boolean isPropertySetStream(InputStream stream) throws MarkUnsupportedException, IOException {
        int BUFFER_SIZE = 50;
        if (!stream.markSupported()) {
            throw new MarkUnsupportedException(stream.getClass().getName());
        }
        stream.mark(50);
        byte[] buffer = new byte[50];
        int bytes = stream.read(buffer, 0, Math.min(buffer.length, stream.available()));
        boolean isPropertySetStream = PropertySet.isPropertySetStream(buffer, 0, bytes);
        stream.reset();
        return isPropertySetStream;
    }

    public static boolean isPropertySetStream(byte[] src, int offset, int length) {
        int byteOrder = LittleEndian.getUShort(src, offset);
        offset += 2;
        byte[] temp = new byte[2];
        LittleEndian.putShort(temp, (short)byteOrder);
        if (!Util.equal(temp, BYTE_ORDER_ASSERTION)) {
            return false;
        }
        int format = LittleEndian.getUShort(src, offset);
        offset += 2;
        temp = new byte[2];
        LittleEndian.putShort(temp, (short)format);
        if (!Util.equal(temp, FORMAT_ASSERTION)) {
            return false;
        }
        long osVersion = LittleEndian.getUInt(src, offset);
        ClassID classID = new ClassID(src, offset += 4);
        long sectionCount = LittleEndian.getUInt(src, offset += 16);
        offset += 4;
        return sectionCount >= 1L;
    }

    private void init(byte[] src, int offset, int length) {
        this.byteOrder = LittleEndian.getUShort(src, offset);
        this.format = LittleEndian.getUShort(src, offset += 2);
        this.osVersion = (int)LittleEndian.getUInt(src, offset += 2);
        this.classID = new ClassID(src, offset += 4);
        this.sectionCount = LittleEndian.getInt(src, offset += 16);
        offset += 4;
        if (this.sectionCount <= 0) {
            throw new HPSFRuntimeException("Section count " + this.sectionCount + " must be greater than 0.");
        }
        this.sections = new ArrayList(2);
        for (int i = 0; i < this.sectionCount; ++i) {
            Section s = new Section(src, offset);
            offset += 20;
            this.sections.add(s);
        }
    }
}

