/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;

final class FixedMeta
extends MPPComponent {
    private int m_itemCount;
    private Object[] m_array;

    FixedMeta(InputStream is, int itemSize) throws IOException {
        int fileSize = is.available();
        if (this.readInt(is) != -86004294) {
            throw new IOException("Bad magic number");
        }
        this.readInt(is);
        this.m_itemCount = this.readInt(is);
        this.readInt(is);
        this.m_itemCount = (fileSize - 16) / itemSize;
        this.m_array = new Object[this.m_itemCount];
        int loop = 0;
        while (loop < this.m_itemCount) {
            this.m_array[loop] = this.readByteArray(is, itemSize);
            ++loop;
        }
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public byte[] getByteArrayValue(int index) {
        byte[] result = null;
        if (index >= 0 && index < this.m_array.length && this.m_array[index] != null) {
            result = (byte[])this.m_array[index];
        }
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN: FixedMeta");
        pw.println("   Item count: " + this.m_itemCount);
        int loop = 0;
        while (loop < this.m_itemCount) {
            pw.println("   Data at index: " + loop);
            pw.println("  " + MPPUtility.hexdump((byte[])this.m_array[loop], true));
            ++loop;
        }
        pw.println("END: FixedMeta");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

