/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;

public class MppSubprojectTest
extends MPXJTestCase {
    public void testMpp9Subproject() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9subproject.mpp");
        this.testSubprojects(mpp, true);
    }

    public void testMpp12Subproject() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12subproject.mpp");
        this.testSubprojects(mpp, true);
    }

    public void testMpd9Subproject() throws Exception {
        ProjectFile mpp = new MPDDatabaseReader().read(String.valueOf(this.m_basedir) + "/mpp9subproject.mpd");
        this.testSubprojects(mpp, false);
    }

    private void testSubprojects(ProjectFile mpp, boolean isMPP) throws Exception {
        Task taskNormal = mpp.getTaskByUniqueID(new Integer(1));
        Task taskSubprojectA = mpp.getTaskByUniqueID(new Integer(2));
        Task taskSubprojectB = mpp.getTaskByUniqueID(new Integer(3));
        MppSubprojectTest.assertEquals((String)"Normal Task", (String)taskNormal.getName());
        MppSubprojectTest.assertEquals((String)"SubprojectA-9", (String)taskSubprojectA.getName());
        MppSubprojectTest.assertEquals((String)"SubprojectB-9", (String)taskSubprojectB.getName());
        SubProject subprojectA = taskSubprojectA.getSubProject();
        MppSubprojectTest.assertTrue((subprojectA != null ? 1 : 0) != 0);
        String string = "\\SubprojectA-9.mpp";
        MppSubprojectTest.assertTrue(("\\SubprojectA-9.mpp".indexOf(subprojectA.getFileName()) != -1 ? 1 : 0) != 0);
        MppSubprojectTest.assertTrue((subprojectA.getFullPath().indexOf("\\SubprojectA-9.mpp") != -1 ? 1 : 0) != 0);
        MppSubprojectTest.assertEquals((Object)new Integer(2), (Object)subprojectA.getTaskUniqueID());
        MppSubprojectTest.assertEquals((Object)new Integer(0x1400000), (Object)subprojectA.getUniqueIDOffset());
        MppSubprojectTest.assertEquals((boolean)false, (boolean)taskSubprojectA.getSubprojectReadOnly());
        if (isMPP) {
            MppSubprojectTest.assertEquals((Object)new Integer(0x800000), (Object)taskSubprojectA.getSubprojectTasksUniqueIDOffset());
            MppSubprojectTest.assertEquals((Object)new Integer(0), (Object)taskSubprojectA.getSubprojectTaskUniqueID());
        }
    }
}

