/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;

public class MppCalendarTest
extends MPXJTestCase {
    public void testMpp9Calendar() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9calendar.mpp");
        this.testCalendars(mpp);
    }

    public void testMpp12Calendar() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12calendar.mpp");
        this.testCalendars(mpp);
    }

    public void testMpd9Calendar() throws Exception {
        ProjectFile mpp = new MPDDatabaseReader().read(String.valueOf(this.m_basedir) + "/mpp9calendar.mpd");
        this.testCalendars(mpp);
    }

    private void testCalendars(ProjectFile mpp) {
        SimpleDateFormat tf = new SimpleDateFormat("HH:mm");
        List baseCalendars = mpp.getBaseCalendars();
        MppCalendarTest.assertEquals((int)5, (int)baseCalendars.size());
        ProjectCalendar cal = mpp.getBaseCalendarByUniqueID(new Integer(1));
        MppCalendarTest.assertNotNull((Object)cal);
        MppCalendarTest.assertEquals((String)"Standard", (String)cal.getName());
        MppCalendarTest.assertNull((Object)cal.getBaseCalendar());
        MppCalendarTest.assertTrue((boolean)cal.isBaseCalendar());
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.MONDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.TUESDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.WEDNESDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.THURSDAY));
        MppCalendarTest.assertEquals((int)1, (int)cal.getWorkingDay(Day.FRIDAY));
        MppCalendarTest.assertEquals((int)0, (int)cal.getWorkingDay(Day.SATURDAY));
        MppCalendarTest.assertEquals((int)0, (int)cal.getWorkingDay(Day.SUNDAY));
        MppCalendarTest.assertEquals((int)0, (int)cal.getCalendarExceptions().size());
        ProjectCalendarHours hours = cal.getCalendarHours(Day.MONDAY);
        MppCalendarTest.assertEquals((int)2, (int)hours.getDateRangeCount());
        DateRange range = hours.getDateRange(0);
        MppCalendarTest.assertEquals((String)"08:00", (String)tf.format(range.getStartDate()));
        MppCalendarTest.assertEquals((String)"12:00", (String)tf.format(range.getEndDate()));
        range = cal.getCalendarHours(Day.MONDAY).getDateRange(1);
        MppCalendarTest.assertEquals((String)"13:00", (String)tf.format(range.getStartDate()));
        MppCalendarTest.assertEquals((String)"17:00", (String)tf.format(range.getEndDate()));
        List resourceCalendars = mpp.getResourceCalendars();
        MppCalendarTest.assertEquals((int)2, (int)resourceCalendars.size());
    }
}

