/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Variable;

public class VariableScope {
    private Map declaredVariables = new HashMap();
    private Map referencedLocalVariables = new HashMap();
    private Map referencedClassVariables = new HashMap();
    private boolean inStaticContext = false;
    private boolean resolvesDynamic = false;
    private ClassNode clazzScope;
    private VariableScope parent;

    public VariableScope() {
    }

    public VariableScope(VariableScope parent) {
        this.parent = parent;
    }

    public Map getDeclaredVariables() {
        return this.declaredVariables;
    }

    public Variable getDeclaredVariable(String name) {
        return (Variable)this.declaredVariables.get(name);
    }

    public Map getReferencedLocalVariables() {
        return this.referencedLocalVariables;
    }

    public Map getReferencedClassVariables() {
        return this.referencedClassVariables;
    }

    public boolean isReferencedClassVariable(String name) {
        return this.referencedClassVariables.containsKey(name);
    }

    public VariableScope getParent() {
        return this.parent;
    }

    public boolean isInStaticContext() {
        return this.inStaticContext;
    }

    public void setInStaticContext(boolean inStaticContext) {
        this.inStaticContext = inStaticContext;
    }

    public boolean isResolvingDynamic() {
        return this.resolvesDynamic;
    }

    public void setDynamicResolving(boolean resolvesDynamic) {
        this.resolvesDynamic = resolvesDynamic;
    }

    public void setClassScope(ClassNode node) {
        this.clazzScope = node;
    }

    public ClassNode getClassScope() {
        return this.clazzScope;
    }

    public boolean isClassScope() {
        return this.clazzScope != null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public VariableScope copy() {
        VariableScope copy = new VariableScope();
        copy.clazzScope = this.clazzScope;
        copy.declaredVariables.putAll(this.declaredVariables);
        copy.inStaticContext = this.inStaticContext;
        copy.parent = this.parent;
        copy.referencedClassVariables.putAll(this.referencedClassVariables);
        copy.referencedLocalVariables.putAll(this.referencedLocalVariables);
        copy.resolvesDynamic = this.resolvesDynamic;
        return copy;
    }
}

