/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import com.projity.menu.HyperLinkToolTip;
import com.projity.util.ClassLoaderUtils;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class MenuFactory
extends ResourceManager {
    private static final String TYPE_MENU = "MENU";
    private static final String TYPE_ITEM = "ITEM";
    private static final String TYPE_RADIO = "RADIO";
    private static final String TYPE_CHECK = "CHECK";
    private static final String SEPARATOR = "-";
    private static final String GLUE = ">";
    private static final String TYPE_SUFFIX = ".type";
    protected static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACCELERATOR_SUFFIX = ".accelerator";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String ENABLED_SUFFIX = ".enabled";
    private static final String ICON_SUFFIX = ".icon";
    private ActionMap actions;
    protected ClassLoader classLoader;
    private ButtonGroup buttonGroup;

    public MenuFactory(ResourceBundle resourceBundle, ActionMap actionMap) {
        super(resourceBundle);
        this.actions = actionMap;
        this.buttonGroup = null;
        this.classLoader = ClassLoaderUtils.getLocalClassLoader();
    }

    public JMenuBar createJMenuBar(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuBar jMenuBar = new JMenuBar();
        List list = this.getStringList(string);
        for (String string2 : list) {
            jMenuBar.add(this.createJMenuComponent(string2));
        }
        return jMenuBar;
    }

    public JPopupMenu createJPopupMenuBar(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JPopupMenu jPopupMenu = new JPopupMenu();
        List list = this.getStringList(string);
        for (String string2 : list) {
            jPopupMenu.add(this.createJMenuComponent(string2));
        }
        return jPopupMenu;
    }

    protected JComponent createJMenuComponent(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        if (string.equals(GLUE)) {
            this.buttonGroup = null;
            return (JComponent)Box.createHorizontalGlue();
        }
        if (string.equals(SEPARATOR)) {
            this.buttonGroup = null;
            return new JSeparator();
        }
        String string2 = this.getString(string + TYPE_SUFFIX);
        JMenuItem jMenuItem = null;
        if (string2.equals(TYPE_RADIO)) {
            if (this.buttonGroup == null) {
                this.buttonGroup = new ButtonGroup();
            }
        } else {
            this.buttonGroup = null;
        }
        if (string2.equals(TYPE_MENU)) {
            jMenuItem = this.createJMenu(string);
        } else if (string2.equals(TYPE_ITEM)) {
            jMenuItem = this.createJMenuItem(string);
        } else if (string2.equals(TYPE_RADIO)) {
            jMenuItem = this.createJRadioButtonMenuItem(string);
            this.buttonGroup.add(jMenuItem);
        } else if (string2.equals(TYPE_CHECK)) {
            jMenuItem = this.createJCheckBoxMenuItem(string);
        } else {
            throw new ResourceFormatException("Malformed resource", this.bundle.getClass().getName(), string + TYPE_SUFFIX);
        }
        return jMenuItem;
    }

    public JMenu createJMenu(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenu jMenu = new JMenu(this.getString(string + TEXT_SUFFIX)){

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (this.getToolTipText().startsWith("<html>")) {
                    return new Point(0, this.getHeight() - 2);
                }
                return super.getToolTipLocation(mouseEvent);
            }

            public JToolTip createToolTip() {
                if (this.getToolTipText().startsWith("<html>")) {
                    HyperLinkToolTip hyperLinkToolTip = new HyperLinkToolTip();
                    hyperLinkToolTip.setComponent(this);
                    return hyperLinkToolTip;
                }
                return super.createToolTip();
            }
        };
        this.initializeJMenuItem(jMenu, string);
        List list = this.getStringList(string);
        for (String string2 : list) {
            JComponent jComponent = this.createJMenuComponent(string2);
            boolean bl = true;
            try {
                bl = this.getBoolean(string2 + ".visible");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (!bl) continue;
            jMenu.add(jComponent);
        }
        return jMenu;
    }

    public JMenuItem createJMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuItem jMenuItem = new JMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jMenuItem, string);
        return jMenuItem;
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jRadioButtonMenuItem, string);
        try {
            jRadioButtonMenuItem.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jRadioButtonMenuItem;
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getString(string + TEXT_SUFFIX));
        this.initializeJMenuItem(jCheckBoxMenuItem, string);
        try {
            jCheckBoxMenuItem.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jCheckBoxMenuItem;
    }

    protected void initializeJMenuItem(JMenuItem jMenuItem, String string) throws ResourceFormatException, MissingListenerException {
        block15: {
            Serializable serializable;
            Object object;
            try {
                object = this.actions.getAction(this.getString(string + ACTION_SUFFIX));
                if (object == null) {
                    throw new MissingListenerException("", "Action", string + ACTION_SUFFIX);
                }
                jMenuItem.setAction((Action)object);
                jMenuItem.setText(this.getString(string + TEXT_SUFFIX));
                if (object instanceof JComponentModifier) {
                    ((JComponentModifier)object).addJComponent(jMenuItem);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                object = this.getString(string + ICON_SUFFIX);
                serializable = this.classLoader.getResource((String)object);
                if (serializable != null) {
                    jMenuItem.setIcon(new ImageIcon((URL)serializable));
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                object = this.getString(string + MNEMONIC_SUFFIX);
                if (((String)object).length() != 1) {
                    throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), string + MNEMONIC_SUFFIX);
                }
                jMenuItem.setMnemonic(((String)object).charAt(0));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                if (jMenuItem instanceof JMenu) break block15;
                object = this.getString(string + ACCELERATOR_SUFFIX);
                serializable = this.toKeyStroke((String)object);
                if (serializable != null) {
                    jMenuItem.setAccelerator((KeyStroke)serializable);
                    break block15;
                }
                throw new ResourceFormatException("Malformed accelerator", this.bundle.getClass().getName(), string + ACCELERATOR_SUFFIX);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            jMenuItem.setEnabled(this.getBoolean(string + ENABLED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected KeyStroke toKeyStroke(String string) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        block31: for (n2 = 0; n3 != 100 && n2 < string.length(); ++n2) {
            char c2 = Character.toUpperCase(string.charAt(n2));
            switch (n3) {
                case 0: {
                    n4 = c2;
                    switch (c2) {
                        case 'C': {
                            n3 = 1;
                            continue block31;
                        }
                        case 'A': {
                            n3 = 5;
                            continue block31;
                        }
                        case 'M': {
                            n3 = 8;
                            continue block31;
                        }
                        case 'S': {
                            n3 = 12;
                            continue block31;
                        }
                    }
                    n3 = 100;
                    continue block31;
                }
                case 1: {
                    n3 = c2 == 'T' ? 2 : 100;
                    continue block31;
                }
                case 2: {
                    n3 = c2 == 'R' ? 3 : 100;
                    continue block31;
                }
                case 3: {
                    n3 = c2 == 'L' ? 4 : 100;
                    continue block31;
                }
                case 4: {
                    int n6 = n3 = c2 == '+' ? 0 : 100;
                    if (n3 != 0) continue block31;
                    n5 |= 2;
                    continue block31;
                }
                case 5: {
                    n3 = c2 == 'L' ? 6 : 100;
                    continue block31;
                }
                case 6: {
                    n3 = c2 == 'T' ? 7 : 100;
                    continue block31;
                }
                case 7: {
                    int n7 = n3 = c2 == '+' ? 0 : 100;
                    if (n3 != 0) continue block31;
                    n5 |= 8;
                    continue block31;
                }
                case 8: {
                    n3 = c2 == 'E' ? 9 : 100;
                    continue block31;
                }
                case 9: {
                    n3 = c2 == 'T' ? 10 : 100;
                    continue block31;
                }
                case 10: {
                    n3 = c2 == 'A' ? 11 : 100;
                    continue block31;
                }
                case 11: {
                    int n8 = n3 = c2 == '+' ? 0 : 100;
                    if (n3 != 0) continue block31;
                    n5 |= 4;
                    continue block31;
                }
                case 12: {
                    n3 = c2 == 'H' ? 13 : 100;
                    continue block31;
                }
                case 13: {
                    n3 = c2 == 'I' ? 14 : 100;
                    continue block31;
                }
                case 14: {
                    n3 = c2 == 'F' ? 15 : 100;
                    continue block31;
                }
                case 15: {
                    n3 = c2 == 'T' ? 16 : 100;
                    continue block31;
                }
                case 16: {
                    int n9 = n3 = c2 == '+' ? 0 : 100;
                    if (n3 != 0) continue block31;
                    n5 |= 1;
                }
            }
        }
        if (n4 > 0 && n5 > 0) {
            String string2 = string.substring(n2 - 1);
            if (string2.equals("F1")) {
                n4 = 112;
            } else if (string2.equals("F2")) {
                n4 = 113;
            } else if (string2.equals("F3")) {
                n4 = 114;
            } else if (string2.equals("F4")) {
                n4 = 115;
            } else if (string2.equals("F5")) {
                n4 = 116;
            } else if (string2.equals("F6")) {
                n4 = 117;
            } else if (string2.equals("F7")) {
                n4 = 118;
            } else if (string2.equals("F8")) {
                n4 = 119;
            } else if (string2.equals("F9")) {
                n4 = 120;
            } else if (string2.equals("F10")) {
                n4 = 121;
            } else if (string2.equals("F11")) {
                n4 = 122;
            } else if (string2.equals("F12")) {
                n4 = 123;
            } else if (n2 < string.length()) {
                char c3 = Character.toUpperCase(string.charAt(n2));
                switch (n4) {
                    case 85: {
                        if (string.length() - n2 != 1 || c3 != 'P') break;
                        n4 = 38;
                        break;
                    }
                    case 76: {
                        if (string.length() - n2 != 3 || c3 != 'E' || Character.toUpperCase(string.charAt(n2 + 1)) != 'F' || Character.toUpperCase(string.charAt(n2 + 2)) != 'T') break;
                        n4 = 37;
                        break;
                    }
                    case 68: {
                        if (string.length() - n2 != 3 || c3 != 'O' || Character.toUpperCase(string.charAt(n2 + 1)) != 'W' || Character.toUpperCase(string.charAt(n2 + 2)) != 'N') break;
                        n4 = 40;
                        break;
                    }
                    case 82: {
                        if (string.length() - n2 != 4 || c3 != 'I' || Character.toUpperCase(string.charAt(n2 + 1)) != 'G' || Character.toUpperCase(string.charAt(n2 + 2)) != 'H' || Character.toUpperCase(string.charAt(n2 + 3)) != 'T') break;
                        n4 = 39;
                    }
                }
            }
            return KeyStroke.getKeyStroke(n4, n5);
        }
        return null;
    }
}

