/*
 * Decompiled with CFR 0.152.
 */
package com.projity.util;

import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.ClassLoaderUtils;
import com.projity.util.Environment;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;

public class VersionUtils {
    public static String getVersion() {
        ResourceBundle resourceBundle;
        String string = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.projity.version.version", Locale.ENGLISH, ClassLoaderUtils.getLocalClassLoader());
            if (resourceBundle != null) {
                string = resourceBundle.getString("projity.version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.projity.strings.version", Locale.ENGLISH, ClassLoaderUtils.getLocalClassLoader());
                if (resourceBundle != null) {
                    string = resourceBundle.getString("projity.version");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string != null) {
            return string;
        }
        return null;
    }

    public static String getJnlpVersion() {
        return System.getProperty("projity.version");
    }

    public static String toAppletVersion(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\.");
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2;
            int n3 = n2 = i2 >= stringArray.length ? 0 : Integer.parseInt(stringArray[i2]);
            if (i2 > 0) {
                stringBuffer.append('.');
            }
            String string2 = Integer.toHexString(n2);
            for (int i3 = 0; i3 < string2.length() - 4; ++i3) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static boolean isJnlpUpToDate() {
        String string = VersionUtils.getVersion();
        String string2 = VersionUtils.getJnlpVersion();
        if (string == null || string2 == null) {
            return true;
        }
        try {
            return string2.equals(VersionUtils.toAppletVersion(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean versionCheck(boolean bl) {
        Preferences preferences;
        String string;
        String string2 = VersionUtils.getVersion();
        if (string2 == null) {
            string2 = "0";
        }
        boolean bl2 = !(string = (preferences = Preferences.userNodeForPackage(VersionUtils.class)).get("PODVersion", "0")).equals(string2);
        String string3 = System.getProperty("java.version");
        System.out.println("POD Version: " + string2 + " local version " + string + " updated=" + bl2 + " java version=" + string3);
        preferences.put("JavaVersion", string3);
        if (bl2) {
            Environment.setUpdated(true);
            preferences.put("PODVersion", string2);
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
            if (bl && Environment.isApplet() && (string3.equals("1.6.0_09") || string3.equals("1.6.0_08") || string3.equals("1.6.0_07") || string3.equals("1.6.0_06") || string3.equals("1.6.0_05") || string3.equals("1.6.0_04"))) {
                Environment.setNeedToRestart(true);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Alert.error(Messages.getString("Error.restart"));
                    }
                });
            }
        } else {
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        return bl2;
    }
}

