/*
 * Decompiled with CFR 0.152.
 */
package com.projity.toolbar;

import com.projity.grouping.core.transform.ViewConfiguration;
import com.projity.help.HelpUtil;
import com.projity.menu.MenuActionConstants;
import com.projity.menu.MenuManager;
import com.projity.toolbar.TransformComboBox;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JToolBar;

public class FilterToolBarManager
implements MenuActionConstants {
    private MenuManager menuManager;
    JToolBar toolBar = null;
    protected TransformComboBox filtersComboBox;
    protected TransformComboBox sortersComboBox;
    protected TransformComboBox groupersComboBox;
    protected Component separator1;
    protected Component separator2;
    protected Component separator3;
    protected Component filler;

    public static FilterToolBarManager create(MenuManager menuManager) {
        return new FilterToolBarManager(menuManager);
    }

    private FilterToolBarManager(MenuManager menuManager) {
        this.menuManager = menuManager;
        this.filtersComboBox = new TransformComboBox(menuManager, "ChooseFilter", 1);
        this.sortersComboBox = new TransformComboBox(menuManager, "ChooseSort", 2);
        this.groupersComboBox = new TransformComboBox(menuManager, "ChooseGroup", 3);
        this.setComboSize(this.filtersComboBox);
        this.setComboSize(this.sortersComboBox);
        this.setComboSize(this.groupersComboBox);
        this.separator1 = Box.createRigidArea(new Dimension(16, 16));
        this.separator2 = Box.createRigidArea(new Dimension(16, 16));
        this.separator3 = Box.createRigidArea(new Dimension(20, 20));
        this.filler = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        HelpUtil.addDocHelp(this.filtersComboBox, "Filters");
        HelpUtil.addDocHelp(this.sortersComboBox, "Sorts");
        HelpUtil.addDocHelp(this.groupersComboBox, "Grouping");
    }

    private void setComboSize(TransformComboBox transformComboBox) {
        Dimension dimension = new Dimension(150, 28);
        transformComboBox.setMinimumSize(dimension);
        transformComboBox.setMaximumSize(dimension);
        transformComboBox.setPreferredSize(dimension);
    }

    public void addButtons(JToolBar jToolBar) {
        jToolBar.add(this.filler);
        jToolBar.add((Component)this.filtersComboBox, "Center");
        jToolBar.add(this.separator1);
        jToolBar.add((Component)this.sortersComboBox, "Center");
        jToolBar.add(this.separator2);
        jToolBar.add((Component)this.groupersComboBox, "Center");
        jToolBar.add(this.separator3);
        this.filtersComboBox.addActionListener(this.menuManager.getActionFromId(this.filtersComboBox.getActionCommand()));
        this.sortersComboBox.addActionListener(this.menuManager.getActionFromId(this.sortersComboBox.getActionCommand()));
        this.groupersComboBox.addActionListener(this.menuManager.getActionFromId(this.groupersComboBox.getActionCommand()));
    }

    public void removeButtons(JToolBar jToolBar) {
        if (jToolBar != null) {
            jToolBar.remove(this.filler);
            jToolBar.remove(this.filtersComboBox);
            jToolBar.remove(this.separator1);
            jToolBar.remove(this.sortersComboBox);
            jToolBar.remove(this.separator2);
            jToolBar.remove(this.groupersComboBox);
            jToolBar.remove(this.separator3);
        }
        if (this.filtersComboBox != null) {
            this.filtersComboBox.removeActionListener(this.menuManager.getActionFromId(this.filtersComboBox.getActionCommand()));
        }
        if (this.sortersComboBox != null) {
            this.sortersComboBox.removeActionListener(this.menuManager.getActionFromId(this.sortersComboBox.getActionCommand()));
        }
        if (this.groupersComboBox != null) {
            this.groupersComboBox.removeActionListener(this.menuManager.getActionFromId(this.groupersComboBox.getActionCommand()));
        }
    }

    public void setComboBoxesViewName(String string) {
        ViewConfiguration viewConfiguration = ViewConfiguration.getView(string);
        this.filtersComboBox.setView(viewConfiguration);
        this.sortersComboBox.setView(viewConfiguration);
        this.groupersComboBox.setView(viewConfiguration);
    }

    public void setEnabled(boolean bl) {
        this.filtersComboBox.setEnabled(bl);
        this.sortersComboBox.setEnabled(bl);
        this.groupersComboBox.setEnabled(bl);
    }

    public void transformBasedOnValue() {
        this.filtersComboBox.transformBasedOnValue();
        this.sortersComboBox.transformBasedOnValue();
        this.groupersComboBox.transformBasedOnValue();
    }

    public void clear() {
        this.filtersComboBox.setSelectedIndex(0);
        this.sortersComboBox.setSelectedIndex(0);
        this.groupersComboBox.setSelectedIndex(0);
    }
}

