/*
 * Decompiled with CFR 0.152.
 */
package com.projity.timescale;

import com.projity.pm.time.HasStartAndEnd;
import com.projity.timescale.CalendarUtil;
import com.projity.timescale.TimeInterval;
import com.projity.timescale.TimeScale;
import com.projity.util.DateTime;
import java.util.Calendar;

public class TimeIterator
implements HasStartAndEnd {
    protected long startTime;
    protected long endTime;
    protected Calendar calendar1;
    protected Calendar calendar2;
    protected TimeScale scale;
    private boolean hasNext = true;
    private long next2 = -1L;
    private boolean useLargeScale;

    public TimeIterator(long l2, long l3, TimeScale timeScale, long l4) {
        this(l2, l3, timeScale, l4, false);
    }

    public TimeIterator(long l2, long l3, TimeScale timeScale, long l4, boolean bl) {
        long l5;
        long l6;
        this.useLargeScale = bl;
        if (l2 <= l3) {
            l6 = l2;
            l5 = l3;
        } else {
            l5 = l2;
            l6 = l3;
        }
        long l7 = l4;
        this.startTime = l6;
        this.endTime = l6 == l5 ? l5 + 1L : l5;
        this.scale = timeScale;
        if (bl) {
            this.calendar2 = DateTime.calendarInstance();
            this.calendar2 = DateTime.calendarInstance();
            this.calendar2.setTimeInMillis(l6);
            if (l7 == -1L) {
                timeScale.floor2(this.calendar2);
            } else {
                timeScale.floor2(this.calendar2, l7);
            }
            this.startTime = this.calendar2.getTimeInMillis();
        } else {
            this.calendar1 = DateTime.calendarInstance();
            this.calendar1 = DateTime.calendarInstance();
            this.calendar1.setTimeInMillis(l6);
            if (l7 == -1L) {
                timeScale.floor1(this.calendar1);
            } else {
                timeScale.floor1(this.calendar1, l7);
            }
            this.calendar2 = DateTime.calendarInstance();
            this.calendar2.setTimeInMillis(l6);
            timeScale.floor2(this.calendar2, l7);
            this.startTime = this.calendar1.getTimeInMillis();
        }
    }

    public TimeIterator(double d2, double d3, TimeScale timeScale, long l2) {
        this(d2, d3, timeScale, l2, false);
    }

    public TimeIterator(double d2, double d3, TimeScale timeScale, long l2, boolean bl) {
        this(CalendarUtil.toLongTime(d2), CalendarUtil.toLongTime(d3), timeScale, l2, bl);
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public TimeInterval next() {
        if (!this.hasNext) {
            return null;
        }
        if (this.useLargeScale) {
            long l2 = this.calendar2.getTimeInMillis();
            this.scale.increment2(this.calendar2);
            long l3 = this.calendar2.getTimeInMillis();
            if (l3 >= this.endTime) {
                this.hasNext = false;
            }
            String string = this.scale.getText2(l2);
            return new TimeInterval(l2, l3, string, -1L, -1L, null);
        }
        long l4 = this.calendar1.getTimeInMillis();
        this.scale.increment1(this.calendar1);
        long l5 = this.calendar1.getTimeInMillis();
        if (l5 >= this.endTime) {
            this.hasNext = false;
        }
        String string = this.scale.getText1(l4);
        long l6 = -1L;
        long l7 = -1L;
        String string2 = null;
        if (this.next2 == -1L || l4 >= this.next2) {
            l6 = this.calendar2.getTimeInMillis();
            this.scale.increment2(this.calendar2);
            this.next2 = l7 = this.calendar2.getTimeInMillis();
            string2 = this.scale.getText2(l6);
        }
        return new TimeInterval(l4, l5, string, l6, l7, string2);
    }

    public long getEnd() {
        return this.endTime;
    }

    public long getStart() {
        return this.startTime;
    }
}

