/*
 * Decompiled with CFR 0.152.
 */
package com.projity.strings;

import com.projity.strings.DirectoryClassLoader;
import com.projity.util.ClassLoaderUtils;
import com.projity.util.Environment;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Messages {
    private static final String META_BUNDLE_NAME = "com.projity.configuration.meta";
    private static ResourceBundle metaBundle = null;
    static ArrayList<ResourceBundle> bundles = null;
    static DirectoryClassLoader directoryClassLoader = new DirectoryClassLoader();
    static Lock lock = new ReentrantLock();
    private static ResourceBundle[] bundleArray = null;

    public static void setMetaBundle(String string) {
        metaBundle = ResourceBundle.getBundle(string, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMetaString(String string) {
        if (metaBundle == null) {
            lock.lock();
            try {
                if (metaBundle == null) {
                    metaBundle = ResourceBundle.getBundle(META_BUNDLE_NAME, Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader());
                }
            }
            finally {
                lock.unlock();
            }
        }
        return metaBundle.getString(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromBundles(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<ResourceBundle> arrayList = null;
        if (bundles == null) {
            lock.lock();
            try {
                if (bundles == null) {
                    int n2;
                    String[] stringArray = Messages.getMetaString("ResourceBundles").split(";");
                    String[] stringArray2 = Messages.getMetaString("DirectoryResourceBundles").split(";");
                    if (directoryClassLoader.isValid()) {
                        arrayList = new ArrayList(stringArray.length + stringArray2.length);
                        for (n2 = 0; n2 < stringArray2.length; ++n2) {
                            try {
                                ResourceBundle resourceBundle = ResourceBundle.getBundle(stringArray2[n2], Locale.getDefault(), directoryClassLoader);
                                arrayList.add(resourceBundle);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    } else {
                        arrayList = new ArrayList<ResourceBundle>(stringArray.length);
                    }
                    for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
                        arrayList.add(ResourceBundle.getBundle(stringArray[n2], Locale.getDefault(), ClassLoaderUtils.getLocalClassLoader()));
                    }
                }
            }
            finally {
                bundles = arrayList;
                lock.unlock();
            }
        }
        for (ResourceBundle resourceBundle : bundles) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    public static String getString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Messages.getStringFromBundles(string);
        if (string2 == null) {
            string2 = '!' + string + '!';
        }
        return string2;
    }

    public static String getStringOrSelf(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Messages.getStringFromBundles(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static Properties getTipProperties() {
        return Messages.getProperties(bundles.get(1));
    }

    public static Properties getProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            properties.put(string, resourceBundle.getString(string));
        }
        return properties;
    }

    public static String getStringWithParam(String string, String string2) {
        return MessageFormat.format(Messages.getString(string), string2);
    }

    public static String getStringWithParam(String string, Object[] objectArray) {
        return MessageFormat.format(Messages.getString(string), objectArray);
    }

    public static String toAppletVersion(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\.");
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2;
            int n3 = n2 = i2 >= stringArray.length ? 0 : Integer.parseInt(stringArray[i2]);
            if (i2 > 0) {
                stringBuffer.append('.');
            }
            String string2 = Integer.toHexString(n2);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String getContextString(String string) {
        if (Environment.isOpenProj()) {
            String string2 = Messages.getStringFromBundles("Open_" + string);
            if (string2 == null) {
                System.out.println("getContextString not found Open_" + string);
            } else {
                return string2;
            }
        }
        return Messages.getStringFromBundles(string);
    }
}

