/*
 * Decompiled with CFR 0.152.
 */
package com.projity.reports.adapter;

import com.projity.configuration.Dictionary;
import com.projity.configuration.ReportDefinition;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.reports.adapter.ReportAdapter;
import com.projity.timescale.TimeIterator;
import com.projity.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.compilers.JRBshCompiler;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class ReportUtil {
    private static final String REPORT_ROOT = "com/projity/reports/definition/";

    private static InputStream openReport(String string) {
        String string2 = REPORT_ROOT + string;
        URL uRL = ClassLoaderUtils.getLocalClassLoader().getResource(string2);
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static JasperReport getReport(ReportDefinition reportDefinition, TimeIterator timeIterator, SpreadSheetFieldArray spreadSheetFieldArray) throws JRException {
        JasperReport jasperReport = (JasperReport)reportDefinition.getReportObject(spreadSheetFieldArray);
        if (jasperReport == null) {
            Object object;
            JasperDesign jasperDesign = null;
            if (null != reportDefinition.getFile()) {
                object = ReportUtil.openReport(reportDefinition.getFile());
                jasperDesign = JRXmlLoader.load((InputStream)object);
            } else {
                object = new ReportAdapter(reportDefinition);
                ((ReportAdapter)object).generateDesign(spreadSheetFieldArray);
                jasperDesign = ((ReportAdapter)object).getJasperDesign();
            }
            object = new JRBshCompiler();
            jasperReport = object.compileReport(jasperDesign);
            reportDefinition.setReportObject(jasperReport, spreadSheetFieldArray);
        }
        return jasperReport;
    }

    public static Object[] getReportDefinitions() {
        return Dictionary.getAll("Report");
    }

    public static ReportDefinition getFromName(String string) {
        Object[] objectArray = ReportUtil.getReportDefinitions();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ReportDefinition reportDefinition = (ReportDefinition)objectArray[i2];
            if (!reportDefinition.getName().equals(string)) continue;
            return reportDefinition;
        }
        return null;
    }
}

