/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.renderer;

import com.projity.field.Field;
import com.projity.field.FieldConverter;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.renderer.FontManager;
import com.projity.pm.graphic.spreadsheet.renderer.OfflineRenderer;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SimpleRenderer
extends DefaultTableCellRenderer
implements OfflineRenderer {
    static Font boldFont = null;
    protected boolean compact = false;

    public SimpleRenderer() {
    }

    public SimpleRenderer(boolean bl) {
        this.compact = true;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        JLabel jLabel;
        if (jTable == null) {
            this.setValue(null);
            jLabel = this;
        } else {
            jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
            CommonSpreadSheetModel commonSpreadSheetModel = (CommonSpreadSheetModel)jTable.getModel();
            FontManager.setComponentFont(commonSpreadSheetModel.getCellProperties(commonSpreadSheetModel.getNode(n2)), jLabel);
        }
        if (object != null) {
            if (this.compact) {
                jLabel.setText(FieldConverter.toString(object, object.getClass(), FieldConverter.COMPACT_CONVERTER_CONTEXT));
            } else {
                jLabel.setText(FieldConverter.toString(object));
            }
        }
        if (object instanceof String) {
            jLabel.setHorizontalAlignment(2);
        } else {
            jLabel.setHorizontalAlignment(4);
        }
        return jLabel;
    }

    public Component getComponent(Object object, GraphicNode graphicNode, Field field, SpreadSheetParams spreadSheetParams) {
        Component component = this.getTableCellRendererComponent(null, object, false, false, -1, -1);
        FontManager.setComponentFont(spreadSheetParams.getFieldArray().getCellStyle().getCellFormat(graphicNode), component);
        return component;
    }
}

