/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.network;

import com.projity.graphic.configuration.BarFormat;
import com.projity.graphic.configuration.BarStyles;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.graphic.configuration.TexturedShape;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.graph.GraphRenderer;
import com.projity.pm.graphic.graph.LinkRouting;
import com.projity.pm.graphic.model.cache.GraphicDependency;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.network.NetworkParams;
import com.projity.pm.graphic.network.link_routing.NetworkLinkRouting;
import com.projity.pm.graphic.network.rendering.FormComponent;
import com.projity.pm.graphic.network.rendering.NetworkCellEditor;
import com.projity.pm.graphic.network.rendering.NetworkCellRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import org.apache.commons.collections.Closure;

public abstract class NetworkRenderer
extends GraphRenderer {
    protected LinkRenderer linkRenderer;
    protected NetworkCellRenderer renderer;
    protected NetworkCellEditor editor;
    protected boolean vertical = true;
    protected CellRendererPane rendererPane;
    protected JComponent container;
    protected GraphicConfiguration config;
    protected double[] segment = new double[6];

    public NetworkRenderer() {
        this.init();
    }

    public NetworkRenderer(GraphParams graphParams) {
        super(graphParams);
        this.init();
    }

    public void init() {
        GraphParams graphParams = this.getGraphInfo();
        if (graphParams instanceof JComponent) {
            this.container = (JComponent)((Object)graphParams);
        }
        this.config = GraphicConfiguration.getInstance();
        this.linkRenderer = new LinkRenderer();
        this.renderer = new NetworkCellRenderer(graphParams);
        if (this.container != null) {
            this.editor = new NetworkCellEditor(graphParams, this.container);
            this.rendererPane = new CellRendererPane();
            this.container.add(this.rendererPane);
        }
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
        ((NetworkLinkRouting)this.getRouting()).setVertical(bl);
    }

    public void paintLink(Graphics2D graphics2D, GraphicDependency graphicDependency) {
        BarStyles barStyles = this.graphInfo.getBarStyles();
        this.linkRenderer.initialize(graphics2D, graphicDependency);
        barStyles.apply(graphicDependency, this.linkRenderer, true, false, false, false);
    }

    protected GeneralPath getShape(GraphicNode graphicNode) {
        return this.scale(this.getNonScaledShape(graphicNode));
    }

    protected abstract GeneralPath getNonScaledShape(GraphicNode var1);

    protected abstract void translateNonScaledShape(GraphicNode var1, double var2, double var4);

    protected void translateShape(GraphicNode graphicNode, double d2, double d3) {
        Point2D point2D = this.scaleVector_1(new Point2D.Double(d2, d3));
        this.translateNonScaledShape(graphicNode, point2D.getX(), point2D.getY());
    }

    protected abstract Point2D getNonScaledCenter(GraphicNode var1);

    protected Point2D getCenter(GraphicNode graphicNode) {
        return this.scale(this.getNonScaledCenter(graphicNode));
    }

    protected Rectangle getBounds(GraphicNode graphicNode) {
        GeneralPath generalPath = this.getShape(graphicNode);
        if (generalPath == null) {
            return null;
        }
        return generalPath.getBounds();
    }

    protected Rectangle getNonScaledBounds(GraphicNode graphicNode) {
        GeneralPath generalPath = this.getNonScaledShape(graphicNode);
        if (generalPath == null) {
            return null;
        }
        return generalPath.getBounds();
    }

    protected void updateLinkConnections(GraphicNode graphicNode, double[] dArray) {
        GeneralPath generalPath = this.getShape(graphicNode);
        if (generalPath == null) {
            return;
        }
        Point2D point2D = this.getCenter(graphicNode);
        dArray[0] = point2D.getX();
        dArray[1] = point2D.getX();
        dArray[2] = point2D.getY();
        dArray[3] = point2D.getY();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(this.segment);
            switch (n2) {
                case 0: {
                    d2 = this.segment[0];
                    d3 = this.segment[1];
                    d6 = d2;
                    d7 = d3;
                    break;
                }
                case 1: {
                    d6 = this.segment[0];
                    d7 = this.segment[1];
                }
                case 4: {
                    double d8;
                    if (n2 == 4) {
                        d6 = d2;
                        d7 = d3;
                    }
                    if (d7 != d5) {
                        double d9 = (point2D.getY() - d5) * (d6 - d4) / (d7 - d5) + d4;
                        double d10 = d8 = d6 == d4 ? 0.0 : (d9 - d4) / (d6 - d4);
                        if (d4 == d6 || d8 >= 0.0 && d8 <= 1.0) {
                            if (d9 < dArray[0]) {
                                dArray[0] = d9;
                            }
                            if (d9 > dArray[1]) {
                                dArray[1] = d9;
                            }
                        }
                    }
                    if (d6 == d4) break;
                    double d11 = (point2D.getX() - d4) * (d7 - d5) / (d6 - d4) + d5;
                    double d12 = d8 = d7 == d4 ? 0.0 : (d11 - d5) / (d7 - d5);
                    if (d5 != d7 && (!(d8 >= 0.0) || !(d8 <= 1.0))) break;
                    if (d11 < dArray[2]) {
                        dArray[2] = d11;
                    }
                    if (!(d11 > dArray[3])) break;
                    dArray[3] = d11;
                }
            }
            d4 = d6;
            d5 = d7;
            pathIterator.next();
        }
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, null);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle3 = rectangle2 = graphics2D.getClipBounds();
        if (rectangle2 == null) {
            rectangle2 = this.getGraphInfo().getDrawingBounds();
            if (rectangle == null) {
                rectangle2 = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
            } else {
                rectangle2 = rectangle;
                graphics2D.setClip(rectangle2);
            }
        }
        Object object = this.getDependenciesIterator();
        while (object.hasNext()) {
            GraphicDependency graphicDependency = (GraphicDependency)object.next();
            this.paintLink(graphics2D, graphicDependency);
        }
        ListIterator listIterator = this.graphInfo.getCache().getIterator();
        while (listIterator.hasNext()) {
            object = (GraphicNode)listIterator.next();
            Rectangle rectangle4 = this.getBounds((GraphicNode)object);
            if (rectangle4 == null || !rectangle2.intersects(rectangle4)) continue;
            this.paintNode(graphics2D, (GraphicNode)object);
        }
        if (rectangle != null) {
            graphics2D.setClip(rectangle3);
        }
    }

    public GeneralPath scale(GeneralPath generalPath) {
        return ((NetworkParams)this.graphInfo).scale(generalPath);
    }

    public Point2D scale(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        return ((NetworkParams)this.graphInfo).scale(point2D);
    }

    public Point2D scaleVector(Point2D point2D) {
        return ((NetworkParams)this.graphInfo).scaleVector(point2D);
    }

    public Point2D scaleVector_1(Point2D point2D) {
        return ((NetworkParams)this.graphInfo).scaleVector_1(point2D);
    }

    public Rectangle scale(Rectangle rectangle) {
        return ((NetworkParams)this.graphInfo).scale(rectangle);
    }

    public void paintNode(Graphics2D graphics2D, GraphicNode graphicNode) {
        Rectangle rectangle = this.getBounds(graphicNode);
        if (this.isEditing(graphicNode)) {
            this.editor.paintEditor(graphicNode);
        } else {
            FormComponent formComponent = this.renderer.getRendererComponent(graphicNode, ((NetworkParams)this.graphInfo).getZoom());
            if (this.container == null) {
                formComponent.setDoubleBuffered(false);
                formComponent.setOpaque(false);
                formComponent.setForeground(Color.BLACK);
                formComponent.setSize(rectangle.width, rectangle.height);
                graphics2D.translate(rectangle.x, rectangle.y);
                formComponent.doLayout();
                formComponent.print(graphics2D);
                graphics2D.translate(-rectangle.x, -rectangle.y);
            } else {
                this.rendererPane.paintComponent(graphics2D, formComponent, this.container, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            }
        }
    }

    public void resetForms() {
        this.renderer.resetForms();
        if (this.editor != null) {
            this.editor.resetForms();
        }
    }

    public boolean isEditing(GraphicNode graphicNode) {
        if (this.editor == null) {
            return false;
        }
        return this.editor.isEditing(graphicNode);
    }

    public NetworkCellEditor getEditor() {
        return this.editor;
    }

    public Iterator getDependenciesIterator() {
        return this.graphInfo.getCache().getEdgesIterator();
    }

    private class LinkRenderer
    implements Closure {
        protected BarFormat format;
        protected GraphicDependency dependency;
        protected Graphics2D g2;

        private LinkRenderer() {
        }

        void initialize(Graphics2D graphics2D, GraphicDependency graphicDependency) {
            this.g2 = graphics2D;
            this.dependency = graphicDependency;
        }

        public void execute(Object object) {
            AffineTransform affineTransform;
            double d2;
            this.format = (BarFormat)object;
            GraphicNode graphicNode = this.dependency.getPredecessor();
            GraphicNode graphicNode2 = this.dependency.getSuccessor();
            double[] dArray = new double[4];
            double[] dArray2 = new double[4];
            NetworkRenderer.this.updateLinkConnections(graphicNode, dArray);
            NetworkRenderer.this.updateLinkConnections(graphicNode2, dArray2);
            Point2D point2D = NetworkRenderer.this.getCenter(graphicNode);
            Point2D point2D2 = NetworkRenderer.this.getCenter(graphicNode2);
            if (point2D == null) {
                return;
            }
            GeneralPath generalPath = this.dependency.getPath();
            NetworkLinkRouting networkLinkRouting = (NetworkLinkRouting)NetworkRenderer.this.getRouting();
            if (NetworkRenderer.this.vertical) {
                networkLinkRouting.routePath(generalPath, point2D.getX(), dArray[3], point2D2.getX(), dArray2[2], (dArray[3] + dArray2[2]) / 2.0, this.dependency.getType());
            } else {
                networkLinkRouting.routePath(generalPath, dArray[1], point2D.getY(), dArray2[0], point2D2.getY(), (dArray[1] + dArray2[0]) / 2.0, this.dependency.getType());
            }
            Color color = this.g2.getColor();
            Stroke stroke = this.g2.getStroke();
            Dependency dependency = this.dependency.getDependency();
            if (dependency != null && dependency.isDisabled()) {
                this.g2.setStroke(GraphRenderer.DISABLED_LINK_STROKE);
            }
            if (dependency != null && dependency.isCrossProject()) {
                this.g2.setColor(GraphRenderer.EXTERNAL_LINK_COLOR);
            } else {
                this.g2.setColor(this.format.getMiddle().getColor());
            }
            this.g2.draw(generalPath);
            if (this.format.getStart() == null && this.format.getEnd() == null) {
                return;
            }
            if (this.format.getStart() != null) {
                d2 = networkLinkRouting.getFirstAngle();
                affineTransform = d2 == 0.0 ? null : AffineTransform.getRotateInstance(d2, networkLinkRouting.getFirstX(), networkLinkRouting.getFirstY());
                this.drawLinkArrows(dependency, affineTransform, this.format.getEnd());
            }
            if (this.format.getEnd() != null) {
                d2 = networkLinkRouting.getLastAngle();
                affineTransform = d2 == Math.PI || d2 == -Math.PI ? null : AffineTransform.getRotateInstance(Math.PI - d2, networkLinkRouting.getLastX(), networkLinkRouting.getLastY());
                this.drawLinkArrows(dependency, affineTransform, this.format.getEnd());
            }
            if (color != null) {
                this.g2.setColor(color);
            }
            if (stroke != null) {
                this.g2.setStroke(stroke);
            }
        }

        private void drawLinkArrows(Dependency dependency, AffineTransform affineTransform, TexturedShape texturedShape) {
            Color color = this.format.getEnd().getColor();
            if (dependency != null && dependency.isCrossProject()) {
                texturedShape.setPaint(GraphRenderer.EXTERNAL_LINK_COLOR);
            }
            this.g2.setColor(texturedShape.getColor());
            LinkRouting linkRouting = NetworkRenderer.this.getRouting();
            texturedShape.draw(this.g2, linkRouting.getLastX(), linkRouting.getLastY(), affineTransform, NetworkRenderer.this.useTextures());
            if (dependency != null && dependency.isCrossProject()) {
                texturedShape.setPaint(color);
            }
        }
    }
}

