/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.timesheet;

import com.projity.pm.assignment.timesheet.UpdatesFromTimesheet;
import com.projity.strings.Messages;
import java.util.Collection;
import java.util.Iterator;

public class TimesheetHelper {
    public static boolean applyTimesheet(Collection collection, Collection collection2, long l2) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!((UpdatesFromTimesheet)iterator.next()).applyTimesheet(collection2, l2)) continue;
            bl = true;
        }
        return bl;
    }

    public static long getLastTimesheetUpdate(Collection collection) {
        long l2 = 0L;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            l2 = Math.max(l2, ((UpdatesFromTimesheet)iterator.next()).getLastTimesheetUpdate());
        }
        return l2;
    }

    public static boolean isPendingTimesheetUpdate(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!((UpdatesFromTimesheet)iterator.next()).isPendingTimesheetUpdate()) continue;
            return true;
        }
        return false;
    }

    public static int getTimesheetStatus(Collection collection) {
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = ((UpdatesFromTimesheet)iterator.next()).getTimesheetStatus();
            if (n3 == 0) continue;
            if (n2 == 0) {
                n2 = n3;
                continue;
            }
            return -1;
        }
        return n2;
    }

    public static String getTimesheetStatusName(int n2) {
        return Messages.getString(TimesheetHelper.getTimesheetStatusStyle(n2));
    }

    public static String getTimesheetStatusStyle(int n2) {
        switch (n2) {
            case 1: {
                return "timesheetEntered";
            }
            case 3: {
                return "timesheetIntegrated";
            }
            case 0: {
                return "timesheetNoData";
            }
            case 4: {
                return "timesheetRejected";
            }
            case 2: {
                return "timesheetValidated";
            }
            case -1: {
                return "timesheetMixed";
            }
        }
        return "timesheetNoData";
    }

    public static String getStatusName(int n2) {
        switch (n2) {
            case 1: {
                return Messages.getString("TimesheetHelper.Entered");
            }
            case 3: {
                return Messages.getString("TimesheetHelper.Integrated");
            }
            case 0: {
                return Messages.getString("TimesheetHelper.New");
            }
            case 4: {
                return Messages.getString("TimesheetHelper.Rejected");
            }
            case 2: {
                return Messages.getString("TimesheetHelper.Validated");
            }
            case -1: {
                return Messages.getString("TimesheetHelper.Mixed");
            }
            case 5: {
                return Messages.getString("TimesheetHelper.Saved");
            }
        }
        return Messages.getString("TimesheetHelper.New");
    }

    public static boolean isReadOnly(int n2) {
        return n2 == 1 || n2 == 3 || n2 == 2;
    }
}

