/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.functor;

import com.projity.algorithm.CalculationVisitor;
import com.projity.algorithm.DoubleValue;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.contour.ContourBucketIntervalGenerator;
import com.projity.pm.calendar.WorkCalendar;

public abstract class AssignmentFieldFunctor
implements CalculationVisitor,
DoubleValue {
    protected Assignment assignment;
    protected WorkCalendar workCalendar = null;
    protected ContourBucketIntervalGenerator contourBucketIntervalGenerator;
    protected boolean cumulative = false;
    private double multiplier = 1.0;
    protected double value = 0.0;

    public final void setMultiplier(double d2) {
        this.multiplier = d2;
    }

    AssignmentFieldFunctor() {
    }

    AssignmentFieldFunctor(Assignment assignment, WorkCalendar workCalendar, ContourBucketIntervalGenerator contourBucketIntervalGenerator) {
        this.assignment = assignment;
        this.workCalendar = workCalendar;
        this.contourBucketIntervalGenerator = contourBucketIntervalGenerator;
    }

    public double getValue() {
        return this.value * this.multiplier;
    }

    public void initialize() {
        if (!this.cumulative) {
            this.reset();
        }
    }

    public void reset() {
        this.value = 0.0;
    }

    public boolean isCumulative() {
        return this.cumulative;
    }

    public void setCumulative(boolean bl) {
        this.cumulative = bl;
    }

    public AssignmentFieldFunctor cum() {
        this.setCumulative(true);
        return this;
    }

    public String toString() {
        return "" + this.value;
    }

    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public final ContourBucketIntervalGenerator getContourBucketIntervalGenerator() {
        return this.contourBucketIntervalGenerator;
    }
}

