/*
 * Decompiled with CFR 0.152.
 */
package com.projity.graphic.configuration.shape;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class PredefinedPaint
extends TexturePaint {
    private Color foreground;
    private Color background;
    private int width;
    private int height;
    private int[] points;
    private float alphaValue = 1.0f;
    public static final PredefinedPaint TRANSPARENT = new PredefinedPaint(4, 4, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final PredefinedPaint SOLID = new PredefinedPaint(4, 4, new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
    public static final PredefinedPaint DEFAULT = new PredefinedPaint(4, 4, new int[]{1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1});
    public static final PredefinedPaint SPACED_DOTS = new PredefinedPaint(4, 4, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final PredefinedPaint DIAGONAL = new PredefinedPaint(4, 4, new int[]{0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    public static final PredefinedPaint DOT_LINE = new PredefinedPaint(4, 4, new int[]{1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0});
    public static final PredefinedPaint DASH_LINE = new PredefinedPaint(1, 4, new int[]{1, 1, 0, 0});
    public static final PredefinedPaint DOT_LINE2 = new PredefinedPaint(1, 2, new int[]{1, 0});
    public static final PredefinedPaint VERY_SPACED_DOTS = new PredefinedPaint(8, 8, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    private static Object[][] data = new Object[][]{{"TRANSPARENT", TRANSPARENT}, {"SOLID", SOLID}, {"DEFAULT", DEFAULT}, {"SPACED_DOTS", SPACED_DOTS}, {"VERY_SPACED_DOTS", VERY_SPACED_DOTS}, {"DASH_LINE", DASH_LINE}, {"DIAGONAL", DIAGONAL}, {"DOT_LINE2", DOT_LINE2}, {"DOT_LINE", DOT_LINE}};
    private static HashMap shapePaintMap = null;

    public PredefinedPaint(int n2, int n3, int[] nArray) {
        this(n2, n3, nArray, Color.black, Color.white);
    }

    public PredefinedPaint(PredefinedPaint predefinedPaint, Color color, Color color2) {
        this(predefinedPaint.width, predefinedPaint.height, predefinedPaint.points, color, color2);
    }

    private PredefinedPaint(int n2, int n3, int[] nArray, Color color, Color color2) {
        super(PredefinedPaint.createTexture(n2, n3, nArray, color, color2), new Rectangle(0, 0, n2, n3));
        this.width = n2;
        this.height = n3;
        this.foreground = color;
        this.background = color2;
        this.points = nArray;
        float f2 = 0.0f;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            f2 += (float)nArray[i2];
        }
        this.alphaValue = (float)Math.pow(f2 / (float)nArray.length, 1.5);
    }

    private static BufferedImage createTexture(int n2, int n3, int[] nArray, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                bufferedImage.setRGB(i2, i3, nArray[i2 + i3 * n2] > 0 ? color.getRGB() : color2.getRGB());
            }
        }
        return bufferedImage;
    }

    public static HashMap getShapePaints() {
        if (shapePaintMap == null) {
            shapePaintMap = new HashMap();
            for (int i2 = 0; i2 < data.length; ++i2) {
                Object[] objectArray = data[i2];
                shapePaintMap.put(objectArray[0], objectArray[1]);
            }
        }
        return shapePaintMap;
    }

    public static PredefinedPaint find(String string) {
        return (PredefinedPaint)PredefinedPaint.getShapePaints().get(string);
    }

    public void applyPaint(Graphics2D graphics2D, boolean bl) {
        if (bl) {
            graphics2D.setPaint(this);
        } else {
            graphics2D.setColor(new Color(this.bar(this.foreground.getRed(), this.background.getRed(), this.alphaValue), this.bar(this.foreground.getGreen(), this.background.getGreen(), this.alphaValue), this.bar(this.foreground.getBlue(), this.background.getBlue(), this.alphaValue)));
        }
    }

    private int bar(float f2, float f3, float f4) {
        return Math.round(f2 * f4 + (1.0f - f4) * f3);
    }
}

