package sharin.sql.generator;

import sharin.sql.Sql;

public interface SqlGenerator {

    public Sql countAll();

    public Sql countBySample(Object sample);

    public Sql countBySamples(Object... samples);

    public Sql selectAll(String propExpr, String orderExpr);

    public Sql selectBySample(String propExpr, String orderExpr, Object sample);

    public Sql selectBySamples(String propExpr, String orderExpr,
            Object... samples);

    public Sql selectById(String propExpr, Object id);

    public Sql selectByIds(String propExpr, String orderExpr, Object... ids);

    public Sql insert(String propExpr, Object entity);

    public Sql updateAll(String propExpr, Object entity);

    public Sql updateBySample(String propExpr, Object entity, Object sample);

    public Sql updateBySamples(String propExpr, Object entity,
            Object... samples);

    public Sql updateById(String propExpr, Object entity, Object id);

    public Sql updateByIds(String propExpr, Object entity, Object... ids);

    public Sql deleteAll();

    public Sql deleteBySample(Object sample);

    public Sql deleteBySamples(Object... samples);

    public Sql deleteById(Object id);

    public Sql deleteByIds(Object... ids);
}
