package sharin.doc.builder.xhtml1;

public class InputElem extends GenericCommonElem<InputElem> {

    public InputElem(Object... nodes) {
        super("input", nodes);
    }

    public InputElem accept(Object value) {
        return attr("accept", value);
    }

    public InputElem accesskey(Object value) {
        return attr("accesskey", value);
    }

    public InputElem align(Object value) {
        return attr("align", value);
    }

    public InputElem alignBottom() {
        return align("bottom");
    }

    public InputElem alignLeft() {
        return align("left");
    }

    public InputElem alignMiddle() {
        return align("middle");
    }

    public InputElem alignRight() {
        return align("right");
    }

    public InputElem alignTop() {
        return align("top");
    }

    public InputElem alt(Object value) {
        return attr("alt", value);
    }

    public InputElem checked(boolean checked) {
        return checked ? checked("checked") : this;
    }

    public InputElem checked(Object value) {
        return attr("checked", value);
    }

    public InputElem disabled(boolean disabled) {
        return disabled ? disabled("disabled") : this;
    }

    public InputElem disabled(Object value) {
        return attr("disabled", value);
    }

    public InputElem maxlength(Object value) {
        return attr("maxlength", value);
    }

    public InputElem name(Object value) {
        return attr("name", value);
    }

    public InputElem onblur(Object value) {
        return attr("onblur", value);
    }

    public InputElem onchange(Object value) {
        return attr("onchange", value);
    }

    public InputElem onfocus(Object value) {
        return attr("onfocus", value);
    }

    public InputElem onselect(Object value) {
        return attr("onselect", value);
    }

    public InputElem readonly(boolean readonly) {
        return readonly ? readonly("readonly") : this;
    }

    public InputElem readonly(Object value) {
        return attr("readonly", value);
    }

    public InputElem size(Object value) {
        return attr("size", value);
    }

    public InputElem src(Object value) {
        return attr("src", value);
    }

    public InputElem tabindex(Object value) {
        return attr("tabindex", value);
    }

    public InputElem type(Object value) {
        return attr("type", value);
    }

    public InputElem typeButton() {
        return type("button");
    }

    public InputElem typeCheckbox() {
        return type("checkbox");
    }

    public InputElem typeFile() {
        return type("file");
    }

    public InputElem typeHidden() {
        return type("hidden");
    }

    public InputElem typeImage() {
        return type("image");
    }

    public InputElem typePassword() {
        return type("password");
    }

    public InputElem typeRadio() {
        return type("radio");
    }

    public InputElem typeReset() {
        return type("reset");
    }

    public InputElem typeSubmit() {
        return type("submit");
    }

    public InputElem typeText() {
        return type("text");
    }

    public InputElem usemap(Object value) {
        return attr("usemap", value);
    }

    public InputElem value(Object value) {
        return attr("value", value);
    }
}
