/*
 * Decompiled with CFR 0.152.
 */
package sharin.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import sharin.util.ReflectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtils {
    private static final Map<Class<?>, Object> defaultValueMap = new HashMap();

    public static Class<?> getSimplePropertyType(Class<?> clazz, String simpleName) {
        Class<?> result = null;
        Field field = PropertyUtils.findField(clazz, simpleName);
        if (field != null) {
            result = field.getType();
        } else {
            Method getter = PropertyUtils.findGetter(clazz, simpleName);
            if (getter != null) {
                result = getter.getReturnType();
            }
        }
        return result;
    }

    public static boolean hasSimpleProperty(Object object, String simpleName) {
        if (object instanceof Map) {
            return ((Map)object).containsKey(simpleName);
        }
        Field field = PropertyUtils.findField(object.getClass(), simpleName);
        if (field != null) {
            return true;
        }
        return PropertyUtils.findGetter(object.getClass(), simpleName) != null;
    }

    public static <T> T getSimplePropertyValue(Object object, String simpleName) {
        if (object instanceof Map) {
            return (T)((Map)object).get(simpleName);
        }
        Field field = PropertyUtils.findField(object.getClass(), simpleName);
        if (field != null) {
            return ReflectUtils.get(field, object);
        }
        Method getter = PropertyUtils.findGetter(object.getClass(), simpleName);
        if (getter != null) {
            return ReflectUtils.invoke(getter, object, new Object[0]);
        }
        return null;
    }

    public static void setSimplePropertyValue(Object object, String simpleName, Object value) {
        Method setter;
        Field field;
        if (object instanceof Map) {
            ((Map)object).put(simpleName, value);
        }
        if ((field = PropertyUtils.findField(object.getClass(), simpleName)) != null) {
            if (value == null) {
                value = defaultValueMap.get(field.getType());
            }
            ReflectUtils.set(field, object, value);
        }
        if ((setter = PropertyUtils.findSetter(object.getClass(), simpleName, value)) != null) {
            if (value == null) {
                value = defaultValueMap.get(setter.getParameterTypes()[0]);
            }
            ReflectUtils.invoke(setter, object, value);
        }
    }

    public static Class<?> getNestedPropertyType(Class<?> clazz, String nestedName) {
        Class<?> result = null;
        int p = nestedName.indexOf(46);
        if (p == -1) {
            result = PropertyUtils.getSimplePropertyType(clazz, nestedName);
        } else {
            Class<?> child = PropertyUtils.getSimplePropertyType(clazz, nestedName.substring(0, p));
            if (child != null) {
                result = PropertyUtils.getNestedPropertyType(child, nestedName.substring(p + 1));
            }
        }
        return result;
    }

    public static boolean hasNestedProperty(Object object, String nestedName) {
        int p = nestedName.indexOf(46);
        if (p == -1) {
            return PropertyUtils.hasSimpleProperty(object, nestedName);
        }
        if (object instanceof Map && ((Map)object).containsKey(nestedName)) {
            return true;
        }
        Object child = PropertyUtils.getSimplePropertyValue(object, nestedName.substring(0, p));
        if (child != null) {
            return PropertyUtils.hasNestedProperty(child, nestedName.substring(p + 1));
        }
        return false;
    }

    public static <T> T getNestedPropertyValue(Object object, String nestedName) {
        T child;
        int p = nestedName.indexOf(46);
        if (p == -1) {
            return PropertyUtils.getSimplePropertyValue(object, nestedName);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Object value = map.get(nestedName);
            if (value != null) {
                return (T)value;
            }
            if (map.containsKey(nestedName)) {
                return null;
            }
        }
        if ((child = PropertyUtils.getSimplePropertyValue(object, nestedName.substring(0, p))) != null) {
            return PropertyUtils.getNestedPropertyValue(child, nestedName.substring(p + 1));
        }
        return null;
    }

    public static void setNestedPropertyValue(Object object, String nestedName, Object value) {
        Class<?> childType;
        int p = nestedName.indexOf(46);
        if (p == -1) {
            PropertyUtils.setSimplePropertyValue(object, nestedName, value);
            return;
        }
        String childName = nestedName.substring(0, p);
        if (object instanceof Map) {
            Map map = (Map)object;
            Object child = map.get(childName);
            if (child == null) {
                if (map.containsKey(nestedName)) {
                    map.put(nestedName, value);
                    return;
                }
                child = new HashMap();
                map.put(childName, child);
            }
            if (child != null) {
                PropertyUtils.setNestedPropertyValue(child, nestedName.substring(p + 1), value);
            }
            return;
        }
        Object child = PropertyUtils.getSimplePropertyValue(object, childName);
        if (child == null && (childType = PropertyUtils.getSimplePropertyType(object.getClass(), childName)) != null) {
            if (!Modifier.isAbstract(childType.getModifiers())) {
                child = ReflectUtils.newInstance(childType);
            } else if (childType.equals(Map.class)) {
                child = new HashMap();
            }
        }
        if (child != null) {
            PropertyUtils.setSimplePropertyValue(object, childName, child);
            PropertyUtils.setNestedPropertyValue(child, nestedName.substring(p + 1), value);
        }
    }

    private static Field findField(Class<?> clazz, String name) {
        Field result = null;
        try {
            Field field = clazz.getField(name);
            if (field != null && PropertyUtils.isInstancePublic(field.getModifiers())) {
                result = field;
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return result;
    }

    private static Method findGetter(Class<?> clazz, String name) {
        String getterName = PropertyUtils.getAccessorName("get", name);
        return PropertyUtils.getAccessor(clazz, getterName, new Class[0]);
    }

    private static Method findSetter(Class<?> clazz, String name, Object value) {
        Method setter = null;
        String setterName = PropertyUtils.getAccessorName("set", name);
        if (value != null) {
            setter = PropertyUtils.getAccessor(clazz, setterName, value.getClass());
        }
        if (setter == null) {
            for (Method method : clazz.getMethods()) {
                if (!PropertyUtils.isInstancePublic(method.getModifiers()) || method.getParameterTypes().length != 1 || !method.getName().equals(setterName)) continue;
                setter = method;
                break;
            }
        }
        return setter;
    }

    private static String getAccessorName(String prefix, String name) {
        return prefix + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private static Method getAccessor(Class<?> clazz, String name, Class<?> ... paramTypes) {
        try {
            Method method = clazz.getMethod(name, paramTypes);
            if (method != null && PropertyUtils.isInstancePublic(method.getModifiers())) {
                return method;
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isInstancePublic(int modifiers) {
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        return Modifier.isPublic(modifiers);
    }

    static {
        defaultValueMap.put(Boolean.TYPE, Boolean.FALSE);
        defaultValueMap.put(Byte.TYPE, new Byte(0));
        defaultValueMap.put(Character.TYPE, new Character('\u0000'));
        defaultValueMap.put(Double.TYPE, new Double(0.0));
        defaultValueMap.put(Float.TYPE, new Float(0.0f));
        defaultValueMap.put(Integer.TYPE, new Integer(0));
        defaultValueMap.put(Long.TYPE, new Long(0L));
        defaultValueMap.put(Short.TYPE, new Short(0));
    }
}

