/*
 * Decompiled with CFR 0.152.
 */
package sharin.sql.generator;

import sharin.sql.generator.EntityInfo;

public class JoinInfo {
    private final String sourceColumnName;
    private final EntityInfo targetEntityInfo;
    private final String targetTableAlias;
    private final String targetColumnName;
    private final String[] targetColumnAliases;

    public JoinInfo(String sourceColumnName, EntityInfo targetEntityInfo, String targetTableAlias) {
        this(sourceColumnName, targetEntityInfo, targetTableAlias, targetEntityInfo.getIdColumnName());
    }

    public JoinInfo(String sourceColumnName, EntityInfo targetEntityInfo, String targetTableAlias, String targetColumnName) {
        this.sourceColumnName = sourceColumnName;
        this.targetEntityInfo = targetEntityInfo;
        this.targetTableAlias = targetTableAlias;
        this.targetColumnName = targetColumnName;
        String[] propertyNames = targetEntityInfo.getPropertyNames();
        String[] targetColumnAliases = new String[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            targetColumnAliases[i] = targetTableAlias + '.' + propertyNames[i];
        }
        this.targetColumnAliases = targetColumnAliases;
    }

    public void appendJoin(StringBuilder builder, String sourceTableAlias) {
        builder.append("LEFT JOIN ");
        String targetTableName = this.targetEntityInfo.getTableName();
        builder.append(targetTableName);
        if (!this.targetTableAlias.equals(targetTableName)) {
            builder.append(' ');
            builder.append(this.targetTableAlias);
        }
        builder.append(" ON ");
        builder.append(sourceTableAlias);
        builder.append('.');
        builder.append(this.sourceColumnName);
        builder.append(" = ");
        builder.append(this.targetTableAlias);
        builder.append('.');
        builder.append(this.targetColumnName);
    }

    public void appendField(StringBuilder builder, String propertyName) {
        builder.append(this.targetTableAlias);
        builder.append('.');
        builder.append(this.targetEntityInfo.getColumnName(propertyName));
        builder.append(" AS \"");
        builder.append(this.targetTableAlias);
        builder.append('.');
        builder.append(propertyName);
        builder.append('\"');
    }

    public String[] getTargetColumnAliases() {
        return this.targetColumnAliases;
    }

    public String getTargetColumnName(String propertyName) {
        return this.targetTableAlias + '.' + this.targetEntityInfo.getColumnName(propertyName);
    }

    public boolean hasTargetColumnName(String propertyName) {
        return this.targetEntityInfo.hasColumnName(propertyName);
    }

    public String getTargetTableAlias() {
        return this.targetTableAlias;
    }
}

