/*
 * Decompiled with CFR 0.152.
 */
package sharin.csv.parser;

import sharin.csv.parser.CsvHandler;

class BasicCsvAutomaton {
    private final CsvHandler handler;
    private final char separator;
    private State state;

    public BasicCsvAutomaton(CsvHandler handler, char separator) {
        this.handler = handler;
        this.separator = separator;
        this.state = State.INITIAL;
    }

    public void put(int ch) {
        switch (this.state) {
            case INITIAL: {
                this.putOnInitial(ch);
                break;
            }
            case NEW_RECORD: {
                this.putOnNewRecord(ch);
                break;
            }
            case NEW_RECORD_CR: {
                this.putOnNewRecordCR(ch);
                break;
            }
            case VALUE: {
                this.putOnValue(ch);
                break;
            }
            case VALUE_CR: {
                this.putOnValueCR(ch);
                break;
            }
            case SEPARATED: {
                this.putOnSeparated(ch);
                break;
            }
            case SEPARATED_CR: {
                this.putOnSeparatedCR(ch);
                break;
            }
            case QUOTED: {
                this.putOnQuoted(ch);
                break;
            }
            case ESCAPED: {
                this.putOnEscaped(ch);
                break;
            }
            case ESCAPED_CR: {
                this.putOnEscapedCR(ch);
                break;
            }
        }
    }

    private void putOnInitial(int ch) {
        this.handler.startDocument();
        this.putOnNewRecord(ch);
    }

    private void putOnNewRecord(int ch) {
        if (ch == this.separator) {
            this.handler.startRecord();
            this.handler.startValue();
            this.handler.endValue();
            this.state = State.SEPARATED;
        } else if (ch == 34) {
            this.handler.startRecord();
            this.handler.startValue();
            this.state = State.QUOTED;
        } else if (ch == 13) {
            this.handler.startRecord();
            this.handler.endRecord();
            this.state = State.NEW_RECORD_CR;
        } else if (ch == 10) {
            this.handler.startRecord();
            this.handler.endRecord();
            this.state = State.NEW_RECORD;
        } else if (ch == -1) {
            this.handler.endDocument();
            this.state = State.FINAL;
        } else {
            this.handler.startRecord();
            this.handler.startValue();
            this.handler.character((char)ch);
            this.state = State.VALUE;
        }
    }

    private void putOnNewRecordCR(int ch) {
        if (ch == 10) {
            this.state = State.NEW_RECORD;
        } else {
            this.putOnNewRecord(ch);
        }
    }

    private void putOnValue(int ch) {
        if (ch == this.separator) {
            this.handler.endValue();
            this.state = State.SEPARATED;
        } else if (ch == 34) {
            this.handler.character((char)ch);
            this.state = State.VALUE;
        } else if (ch == 13) {
            this.handler.endValue();
            this.handler.endRecord();
            this.state = State.VALUE_CR;
        } else if (ch == 10) {
            this.handler.endValue();
            this.handler.endRecord();
            this.state = State.NEW_RECORD;
        } else if (ch == -1) {
            this.handler.endValue();
            this.handler.endRecord();
            this.handler.endDocument();
            this.state = State.FINAL;
        } else {
            this.handler.character((char)ch);
            this.state = State.VALUE;
        }
    }

    private void putOnValueCR(int ch) {
        if (ch == 10) {
            this.state = State.NEW_RECORD;
        } else {
            this.putOnNewRecord(ch);
        }
    }

    private void putOnSeparated(int ch) {
        if (ch == this.separator) {
            this.handler.startValue();
            this.handler.endValue();
            this.state = State.SEPARATED;
        } else if (ch == 34) {
            this.handler.startValue();
            this.state = State.QUOTED;
        } else if (ch == 13) {
            this.handler.startValue();
            this.handler.endValue();
            this.handler.endRecord();
            this.state = State.SEPARATED_CR;
        } else if (ch == 10) {
            this.handler.startValue();
            this.handler.endValue();
            this.handler.endRecord();
            this.state = State.NEW_RECORD;
        } else if (ch == -1) {
            this.handler.startValue();
            this.handler.endValue();
            this.handler.endRecord();
            this.handler.endDocument();
            this.state = State.FINAL;
        } else {
            this.handler.startValue();
            this.handler.character((char)ch);
            this.state = State.VALUE;
        }
    }

    private void putOnSeparatedCR(int ch) {
        if (ch == 10) {
            this.state = State.NEW_RECORD;
        } else {
            this.putOnNewRecord(ch);
        }
    }

    private void putOnQuoted(int ch) {
        if (ch == this.separator) {
            this.handler.character((char)ch);
            this.state = State.QUOTED;
        } else if (ch == 34) {
            this.state = State.ESCAPED;
        } else if (ch == 13) {
            this.handler.character((char)ch);
            this.state = State.QUOTED;
        } else if (ch == 10) {
            this.handler.character((char)ch);
            this.state = State.QUOTED;
        } else if (ch == -1) {
            this.handler.endValue();
            this.handler.endRecord();
            this.handler.endDocument();
            this.state = State.FINAL;
        } else {
            this.handler.character((char)ch);
            this.state = State.QUOTED;
        }
    }

    private void putOnEscaped(int ch) {
        if (ch == this.separator) {
            this.handler.endValue();
            this.state = State.SEPARATED;
        } else if (ch == 34) {
            this.handler.character((char)ch);
            this.state = State.QUOTED;
        } else if (ch == 13) {
            this.handler.endValue();
            this.handler.endRecord();
            this.state = State.ESCAPED_CR;
        } else if (ch == 10) {
            this.handler.endValue();
            this.handler.endRecord();
            this.state = State.NEW_RECORD;
        } else if (ch == -1) {
            this.handler.endValue();
            this.handler.endRecord();
            this.handler.endDocument();
            this.state = State.FINAL;
        } else {
            this.handler.character((char)ch);
            this.state = State.VALUE;
        }
    }

    private void putOnEscapedCR(int ch) {
        if (ch == 10) {
            this.state = State.NEW_RECORD;
        } else {
            this.putOnNewRecord(ch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        NEW_RECORD,
        NEW_RECORD_CR,
        SEPARATED,
        SEPARATED_CR,
        VALUE,
        VALUE_CR,
        QUOTED,
        ESCAPED,
        ESCAPED_CR,
        FINAL;

    }
}

