/*
 * Created on 16-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;

import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;
import org.herac.tuxguitar.song.models.Tupleto;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TGOutputStream {
    private static final String TG_VERSION = "TG_DEVEL-0.01";
    private DataOutputStream dataOutputStream;   
    
    public TGOutputStream(FileOutputStream file) throws FileNotFoundException {
        this.dataOutputStream = new DataOutputStream(file);
    }

    public TGOutputStream(String fileName) throws FileNotFoundException {
        this(new FileOutputStream(new File(fileName)));
    }
    
    public void write(Song song){        
        try {
            this.writeVersion();
            this.writeSong(song);
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        } catch (IOException e) {            
            e.printStackTrace();
        }
    }

    private void writeVersion(){
        writeString(TG_VERSION);
    }
    
    
    private void writeSong(Song song){
        //escribo el nombre
        writeString(song.getName());
        
        //escribo el interprete
        writeString(song.getInterpret());
        
        //escribo el album
        writeString(song.getAlbum());

        //escribo el autor
        writeString(song.getAuthor());
                
        
        //escribo la cantidad de pistas 
        writeInt(song.getTracks().size());
        
        //escribo las pistas
        Iterator it  = song.getTracks().iterator();
        while(it.hasNext()){
            SongTrack track = (SongTrack)it.next();
            writeTrack(track);
        }
        
    }
    
    private void writeTrack(SongTrack track){
    	//escribo el nombre
    	writeString(track.getName());
    	
        //escribo el canal
        writeInt(track.getChannel());
        
        //escribo el instrumento
        writeInt(track.getInstrument());                        

        //escribo la cantidad de compases 
        writeInt(track.getMeasures().size());        
        
        //escribo los compases
        Iterator measureIt  = track.getMeasures().iterator();
        while(measureIt.hasNext()){
            Measure measure = (Measure)measureIt.next();
            writeMeasure(measure);
        }                       
        
        //escribo la cantidad de cuerdas 
        writeInt(track.getStrings().size());        
        
        //escribo las cuerdas
        Iterator stringIt  = track.getStrings().iterator();
        while(stringIt.hasNext()){
            InstrumentString string = (InstrumentString)stringIt.next();
            writeInstrumentString(string);
        }       
        
        //escribo el color
        writeTrackColor(track.getColor());
    }
    
    
    
    
    private void writeMeasure(Measure measure){             
        //escribo el start
        writeLong(measure.getStart());
                           
        
        //escribo la cantidad de notas 
        writeInt(measure.getNotes().size());        
        
        //escribo las cuerdas
        Iterator noteIt  = measure.getNotes().iterator();
        while(noteIt.hasNext()){
            Note note = (Note)noteIt.next();
            writeNote(note);
        }                    
        
        //escribo la cantidad de silencios 
        writeInt(measure.getSilences().size());        
        
        //escribo las cuerdas
        Iterator silenceIt  = measure.getSilences().iterator();
        while(silenceIt.hasNext()){
            Silence silence = (Silence)silenceIt.next();
            writeSilence(silence);
        }                             
        
        //escribo el timeSignature        
        writeTimeSignature(measure.getTimeSignature());
        
        //escribo el tempo
        writeTempo(measure.getTempo());                         
        
        //escribo el comienzo de la repeticion
        writeBoolean(measure.isRepeatStart());        
        
        //escribo el numero de repeticiones
        writeInt(measure.getNumberOfRepetitions());                                
    }    
    
    private void writeNote(Note note){        
        //escribo el valor
        writeInt(note.getValue());
        
        //escribo el start
        writeLong(note.getStart());   
        
        //escribo la duracion
        writeDuration(note.getDuration());
        
        //escribo el velocity
        writeInt(note.getVelocity());
        
        //escribo la cuerda
        writeInt(note.getString());
        
        //escribo la ligadura
        writeBoolean(note.isTiedNote());     
        
        //escribo los efectos
        writeNoteEffect(note.getEffect());
    }

    
    private void writeSilence(Silence silence){               
        //escribo el start
        writeLong(silence.getStart());   
        
        //escribo la duracion
        writeDuration(silence.getDuration());        
    }    
    
    
    private void writeInstrumentString(InstrumentString string){
        //escribo el numero
        writeInt(string.getNumber());
        
        //escribo el valor
        writeInt(string.getValue());                                
    }
    
    
    private void writeTempo(Tempo tempo){
        //escribo el valor
        writeInt(tempo.getValue());
    }    
    
    
    private void writeTimeSignature(TimeSignature timeSignature){
        //escribo el numerador
        writeInt(timeSignature.getNumerator());
        
        //escribo el denominador
        writeDuration(timeSignature.getDenominator());
    }
    
    private void writeDuration(Duration duration){
        //escribo el valor
        writeInt(duration.getValue());
        
        //escribo el puntillo
        writeBoolean(duration.isDotted());
        
        //escribo el doble puntillo
        writeBoolean(duration.isDoubleDotted());        
        
        //escribo el tupleto
        writeTupleto(duration.getTupleto());
    }    
    
    private void writeTupleto(Tupleto tupleto){                
        //escribo los enters
        writeInt(tupleto.getEnters());
        
        //escribo los tiempos
        writeInt(tupleto.getTimes());       
    }       
    
    
    private void writeNoteEffect(NoteEffect effect){        
        //escribo el vibrato
        writeBoolean(effect.isVibrato());
        
        //escribo el bend
        writeBoolean(effect.isBend());
        if(effect.isBend()){
            writeBendEffect(effect.getBend());
        }
        
        //escribo el slide
        writeBoolean(effect.isSlide());
        
        //escribo el hammer
        writeBoolean(effect.isHammer());      
    }    
    
    private void writeBendEffect(BendEffect bend){        
        //escribo la cantidad de puntos
        writeInt(bend.getPoints().size());
        
        Iterator it = bend.getPoints().iterator();
        while(it.hasNext()){
            BendEffect.BendPoint point = (BendEffect.BendPoint)it.next();
            
            //escribo la posicion
            writeInt(point.getPosition());
            
            //escribo el valor
            writeInt(point.getValue());            
        }        
    }
    
    private void writeTrackColor(TrackColor color){                
        //escribo el RGB
        writeInt(color.getR());
        writeInt(color.getG());
        writeInt(color.getB());
    }   
    
    
    private void writeString(String v){
        try {
            this.dataOutputStream.write(v.length());
            this.dataOutputStream.writeChars(v);
        } catch (IOException e) {            
            e.printStackTrace();
        }                
    }

    public void writeInt(int v){
        try {
            this.dataOutputStream.writeInt(v);            
        } catch (IOException e) {            
            e.printStackTrace();
        }                
    }    
    
    public void writeLong(long v){
        try {
            this.dataOutputStream.writeLong(v);            
        } catch (IOException e) {            
            e.printStackTrace();
        }                
    }       
 
    private void writeBoolean(boolean v){
        try {
            this.dataOutputStream.writeBoolean(v);            
        } catch (IOException e) {            
            e.printStackTrace();
        }                
    }          
    
}
