/*
 * Created on 09-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io.gp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.tab.TablatureUtil;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class GP3OutputStream {
    private static final String GP3_VERSION = "FICHIER GUITAR PRO v3.00";

    private OutputStream outputStream;

    public GP3OutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeSong(Song song) throws IOException {
        try {
            SongTrack firstTrack = null;
            Measure firstMeasure = null;
            int numberOfTracks = song.getTracks().size();
            if (numberOfTracks > 0) {
                firstTrack = (SongTrack) song.getTracks().get(0);
            }

            int numberOfMeasures = 0;
            if (firstTrack != null) {
                numberOfMeasures = firstTrack.getMeasures().size();
            }
            if (numberOfMeasures > 0) {
                firstMeasure = (Measure) firstTrack.getMeasures().get(0);
            }

            //version
            writeStringByte(GP3_VERSION, 30);
            //title
            writeStringIntegerPlusOne(song.getName());
            //subtitle
            writeStringIntegerPlusOne("");
            //interpret
            writeStringIntegerPlusOne(song.getInterpret());
            //album
            writeStringIntegerPlusOne(song.getAlbum());
            //songAuthor
            writeStringIntegerPlusOne(song.getAuthor());
            //copyright
            writeStringIntegerPlusOne("");
            //pieceAuthor
            writeStringIntegerPlusOne("");
            //instructions
            writeStringIntegerPlusOne("");

            //notes
            writeInt(0);
            //tripletFeel
            writeBoolean(false);
            //tempo
            Tempo tempo = new Tempo(120);
            if (firstMeasure != null) {
                tempo = (Tempo) firstMeasure.getTempo().clone();
            }
            writeInt(tempo.getValue());
            //key
            writeInt(0);

            Channel[] channels = makeChannels(song);
            for (int i = 0; i < channels.length; i++) {
                //instrument
                writeInt(channels[i].getInstrument());
                //volume
                writeByte((byte) channels[i].getVolume());
                //balance
                writeByte((byte) channels[i].getBalance());
                //chorus
                writeByte((byte) channels[i].getChorus());
                //reverb
                writeByte((byte) channels[i].getReverb());
                //phaser
                writeByte((byte) channels[i].getPhaser());
                //tremolo
                writeByte((byte) channels[i].getTremolo());

                byte[] b = { 0, 0 };
                this.outputStream.write(b);
            }

            //numberOfMeasures
            writeInt(numberOfMeasures);
            //numberOfTracks
            writeInt(numberOfTracks);

            if (firstTrack != null) {
                createMeasures(firstTrack.getMeasures());
            }

            createTracks(song.getTracks());

            for (int i = 0; i < numberOfMeasures; i++) {
                for (int j = 0; j < numberOfTracks; j++) {
                    SongTrack track = (SongTrack) song.getTracks().get(j);
                    Measure measure = (Measure) track.getMeasures().get(i);

                    addMeasureComponents(track.getStrings().size(), measure, tempo);                    
                }
            }

            this.outputStream.flush();
            this.outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createMeasures(List measures) throws IOException {
        TimeSignature timeSignature = new TimeSignature(0, new Duration(0));
        if (measures.size() > 0) {
            for (int i = 0; i < measures.size(); i++) {
                Measure measure = (Measure) measures.get(i);
                createMeasure(measure, timeSignature);

                timeSignature.setNumerator(measure.getTimeSignature().getNumerator());
                timeSignature.getDenominator().setValue(measure.getTimeSignature().getDenominator().getValue());
            }
        }
    }

    private void createMeasure(Measure measure, TimeSignature currTimeSignature) throws IOException {
        //-----------------------
        int header = 0;
        //numerator
        if (measure.getTimeSignature().getNumerator() != currTimeSignature.getNumerator()) {
            header |= 0x01;
        }
        //denominator
        if (measure.getTimeSignature().getDenominator().getValue() != currTimeSignature.getDenominator().getValue()) {
            header |= 0x02;
        }
        //repeatStart
        if (measure.isRepeatStart()) {
            header |= 0x04;
        }

        //numberOfRepetitions
        if (measure.getNumberOfRepetitions() > 0) {
            header |= 0x08;
        }

        writeUnsignedByte(header);
        //---------------------------------------------
        if ((header & 0x01) != 0) {
            //numerator
            writeByte((byte) measure.getTimeSignature().getNumerator());
        }

        if ((header & 0x02) != 0) {
            //denominator
            writeByte((byte) measure.getTimeSignature().getDenominator().getValue());
        }

        if ((header & 0x08) != 0) {
            //numberOfRepetitions
            writeByte((byte) measure.getNumberOfRepetitions());
        }

    }

    private void createTracks(List tracks) throws IOException {
        for (int i = 0; i < tracks.size(); i++) {
            SongTrack track = (SongTrack) tracks.get(i);
            createTrack(track);
        }
    }

    private void createTrack(SongTrack track) throws IOException {
        //---------------------------------------------
        int header = 0;

        //numberOfRepetitions
        if (track.isPercusionTrack()) {
            header |= 0x01;
        }

        writeUnsignedByte(header);
        //---------------------------------------------

        //name
        writeStringByte(track.getName(), 40);

        //numberOfStrings
        writeInt(track.getStrings().size());

        for (int i = 0; i < 7; i++) {
            int value = 0;
            if (track.getStrings().size() > i) {
                InstrumentString string = (InstrumentString) track.getStrings().get(i);
                value = string.getValue();
            }
            writeInt(value);
        }

        //port
        writeInt(1);

        //channel
        writeInt(track.getChannel() + 1);

        //effects
        writeInt(0);

        //numberOfFrets
        writeInt(24);

        //capo
        writeInt(0);

        //color
        writeColor(track.getColor());

    }

    private void addMeasureComponents(int strings, Measure measure, Tempo tempo) throws IOException, GPFormatException {
        List beats = getBeats(measure);
        //numberOfBeats
        writeInt(beats.size());

        for (int i = 0; i < beats.size(); i++) {
            MeasureBeat beat = (MeasureBeat) beats.get(i);
            addNotes(beat, strings, measure, tempo);
        }

    }

    private void addNotes(MeasureBeat beat, int strings, Measure measure, Tempo songTempo) throws IOException, GPFormatException {
        Duration duration = beat.getDuration();
        //---------------------------------------------
        int header = 0;

        if (duration.isDotted()) {
            header |= 0x01;
        }
        if (!duration.getTupleto().isEqual(Duration.NO_TUPLETO)) {
            header |= 0x20;
        }
        if (measure.getTempo().getValue() != songTempo.getValue()) {
            header |= 0x10;
        }
        NoteEffect effect = null;
        if (beat.isSilence()) {
            header |= 0x40;
        } else if (beat.getNotes().size() > 0) {
            Note note = (Note) beat.getNotes().get(0);
            effect = note.getEffect();
            if (effect.isVibrato()) {
                header |= 0x08;
            }
        }

        writeUnsignedByte(header);
        //---------------------------------------------

        if ((header & 0x40) != 0) {
            writeUnsignedByte(0x02);
        }

        //duration value
        writeByte(parseDuration(duration));

        if ((header & 0x20) != 0) {
            //tupleto
            writeInt(duration.getTupleto().getEnters());
        }

        if ((header & 0x08) != 0) {
            writeBeatEffects(effect);
        }

        if ((header & 0x10) != 0) {
            writeMixChange(measure.getTempo());
        }

        int stringHeader = 0;
        if (!beat.isSilence()) {

            for (int i = 0; i < beat.getNotes().size(); i++) {
                Note playedNote = (Note) beat.getNotes().get(i);
                int string = (7 - playedNote.getString());
                stringHeader |= (1 << string);
            }
        }

        writeUnsignedByte(stringHeader);

        for (int i = 0; i < beat.getNotes().size(); i++) {
            Note playedNote = (Note) beat.getNotes().get(i);
            writeNote(playedNote);
        }

    }

    private void writeNote(Note note) throws IOException {
        int header = 0x20;
        if (note.getEffect().hasEffects()) {
            header |= 0x08;
        }
        writeUnsignedByte(header);

        if ((header & 0x20) != 0) {
            int typeHeader = 0x01;
            if (note.isTiedNote()) {
                typeHeader = 0x02;
            }
            writeUnsignedByte(typeHeader);
        }

        if ((header & 0x20) != 0) {
            writeByte((byte) note.getValue());
        }

        if ((header & 0x08) != 0) {
            writeNoteEffects(note.getEffect());
        }

    }

    private byte parseDuration(Duration duration) {
        byte value = 0;
        switch (duration.getValue()) {
        case Duration.WHOLE:
            value = -2;
            break;
        case Duration.HALF:
            value = -1;
            break;
        case Duration.QUARTER:
            value = 0;
            break;
        case Duration.EIGHTH:
            value = 1;
            break;
        case Duration.SIXTEENTH:
            value = 2;
            break;
        case Duration.THIRTY_SECOND:
            value = 3;
            break;
        case Duration.SIXTY_FOURTH:
            value = 4;
            break;
        }
        return value;
    }

    private void writeBeatEffects(NoteEffect noteEffect) throws IOException {
        int header = 0;
        if (noteEffect.isVibrato()) {
            header += 0x01;
        }
        writeUnsignedByte(header);

    }

    private void writeNoteEffects(NoteEffect effect) throws IOException {
        int header = 0;
        if (effect.isBend()) {
            header |= 0x01;
        }
        if (effect.isHammer()) {
            header |= 0x02;
        }
        if (effect.isSlide()) {
            header |= 0x04;
        }
        writeUnsignedByte(header);

        if ((header & 0x01) != 0) {
            writeBend(effect.getBend());
        }
    }

    private void writeBend(BendEffect bend) throws IOException {
        //type
        writeByte((byte) 0);
        //value
        writeInt(0);

        int numPoints = bend.getPoints().size();
        writeInt(numPoints);

        for (int i = 0; i < numPoints; i++) {
            BendEffect.BendPoint point = (BendEffect.BendPoint) bend.getPoints().get(i);

            int bendPosition = (int) (point.getPosition() * 60 / BendEffect.MAX_POSITION_LENGTH);
            int bendValue = (point.getValue() * 100 / 8);

            //bendPosition
            writeInt(bendPosition);
            //bendValue
            writeInt(bendValue);
            //bendVibrato
            writeByte((byte) 0);
        }

    }

    private void writeMixChange(Tempo tempo) throws IOException {
        for (int i = 0; i < 7; i++) {
            writeByte((byte) -1);
            
        }
        writeInt(tempo.getValue());
        
        writeByte((byte) 0);        
    }

    private List getBeats(Measure measure) {
        boolean hasSilences = (!measure.getSilences().isEmpty());
        orderNotes(measure);
        List beats = new ArrayList();
        MeasureBeat beat = null;
        Iterator it = null;
        //-----notas---------------------------------------
        it = measure.getNotes().iterator();
        while (it.hasNext()) {
            Note note = (Note) it.next();
            if (beat == null) {
                beat = new MeasureBeat(note.getDuration(), note.getStart());
            }

            //verifico si tengo que autocompletar silencios
            if (!hasSilences) {
                if (beats.isEmpty() && beat.getStart() != measure.getStart()) {
                    long silenceLength = (beat.getStart() - measure.getStart());
                    if (silenceLength > 10) {
                        createSilenceBeats(beats, (beat.getStart() + beat.getDuration().getTime()), silenceLength);
                    }
                }
            }

            //verifico si termino el beat
            if (note.getStart() != beat.getStart()) {
                beats.add(beat);

                //verifico si tengo que autocompletar silencios
                if (!hasSilences) {
                    long silenceLength = (note.getStart() - (beat.getStart() + beat.getDuration().getTime()));
                    if (silenceLength > 10) {
                        createSilenceBeats(beats, (beat.getStart() + beat.getDuration().getTime()), silenceLength);
                    }
                }
                //creo el siguiente beat
                beat = new MeasureBeat(note.getDuration(), note.getStart());
            }
            beat.addNote(note);
        }
        if (beat != null) {
            beats.add(beat);
        }

        //agrego los silencios
        if (hasSilences) {
            it = measure.getSilences().iterator();
            while (it.hasNext()) {
                Silence silence = (Silence) it.next();
                beats.add(new MeasureBeat(silence.getDuration(), silence.getStart()));
            }
        }

        //ordeno los beats
        for (int i = 0; i < beats.size(); i++) {
            MeasureBeat minBeat = null;
            for (int beatIdx = i; beatIdx < beats.size(); beatIdx++) {
                MeasureBeat currBeat = (MeasureBeat) beats.get(beatIdx);
                if (minBeat == null || currBeat.getStart() < minBeat.getStart()) {
                    minBeat = currBeat;
                }
            }
            beats.remove(minBeat);
            beats.add(i, minBeat);
        }

        return beats;
    }

    private void createSilenceBeats(List beats, long start, long length) {
        List durations = TablatureUtil.createDurations(length);
        Iterator it = durations.iterator();
        while (it.hasNext()) {
            Duration duration = (Duration) it.next();
            beats.add(new MeasureBeat(duration, start));
            start += duration.getTime();
        }
    }

    private void orderNotes(Measure measure) {
        for (int i = 0; i < measure.getNotes().size(); i++) {
            Note minNote = null;
            for (int noteIdx = i; noteIdx < measure.getNotes().size(); noteIdx++) {
                Note note = (Note) measure.getNotes().get(noteIdx);
                if (minNote == null || (note.getStart() < minNote.getStart())
                        || (note.getStart() == minNote.getStart() && (note.getString() < minNote.getString()))) {
                    minNote = note;
                }
            }
            measure.getNotes().remove(minNote);
            measure.getNotes().add(i, minNote);
        }
    }

    private Channel[] makeChannels(Song song) {
        Channel[] channels = new Channel[64];
        for (int i = 0; i < channels.length; i++) {
            channels[i] = new Channel(i, (byte) 24, (byte) 13, (byte) 8, (byte) 0, (byte) 0, (byte) 0, (byte) 0);
        }

        Iterator it = song.getTracks().iterator();
        while (it.hasNext()) {
            SongTrack track = (SongTrack) it.next();
            channels[track.getChannel()].setInstrument(track.getInstrument());
        }

        return channels;
    }

    private void writeColor(TrackColor color) throws IOException {
        //red
        writeUnsignedByte(color.getR());
        //green
        writeUnsignedByte(color.getG());
        //blue
        writeUnsignedByte(color.getB());

        this.outputStream.write(0);
    }

    //-----------------------------------------------------------------------------------
    private void writeBoolean(boolean v) throws IOException {
        this.outputStream.write(v ? 1 : 0);
    }

    private void writeByte(byte v) throws IOException {
        this.outputStream.write(v);
    }

    private void writeUnsignedByte(int v) throws IOException {
        this.outputStream.write(v);
    }

    private void writeStringByte(String v, int expectedLength) throws IOException {
        byte[] bytes = v.getBytes();

        this.writeUnsignedByte(bytes.length);

        if (expectedLength != 0) {
            byte[] tempBytes = new byte[expectedLength];
            for (int i = 0; i < bytes.length; i++) {
                tempBytes[i] = bytes[i];
            }
            bytes = tempBytes;
        }
        this.outputStream.write(bytes);
    }

    private void writeStringIntegerPlusOne(String v) throws IOException {
        byte[] b = v.getBytes();

        this.writeInt(b.length + 1);
        this.outputStream.write(b.length);
        this.outputStream.write(b);
    }

    private void writeStringInteger(String v) throws IOException {
        byte[] bytes = v.getBytes();
        this.writeInt(bytes.length);
        this.outputStream.write(bytes);
    }

    private void writeInt(int v) throws IOException {
        byte[] bytes = new byte[4];
        bytes[0] = (byte) (v & 0x00FF);
        bytes[1] = (byte) ((v >> 8) & 0x000000FF);
        bytes[2] = (byte) ((v >> 16) & 0x000000FF);
        bytes[3] = (byte) ((v >> 24) & 0x000000FF);

        this.outputStream.write(bytes);
    }

    //-----------------------------------------------------------------------------------

    private class MeasureBeat {
        private Duration duration;
        private List notes;
        private boolean silence;
        private long start;

        public MeasureBeat(Duration duration, long start) {
            this.duration = duration;
            this.start = start;
            this.notes = new ArrayList();
            this.silence = true;
        }

        public long getStart() {
            return start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public Duration getDuration() {
            return duration;
        }

        public void addNote(Note note) {
            this.getNotes().add(note);
            this.silence = false;
        }

        public List getNotes() {
            return notes;
        }

        private boolean isSilence() {
            return silence;
        }

    }

    private class Channel {
        private int channel;
        private int instrument;
        private byte volume;
        private byte balance;
        private byte chorus;
        private byte reverb;
        private byte phaser;
        private byte tremolo;

        public Channel(int channel, int instrument, byte volume, byte balance, byte chorus, byte reverb, byte phaser, byte tremolo) {
            this.channel = channel;
            this.instrument = instrument;
            this.volume = volume;
            this.balance = balance;
            this.chorus = chorus;
            this.reverb = reverb;
            this.phaser = phaser;
            this.tremolo = tremolo;
        }

        public byte getBalance() {
            return balance;
        }

        public void setBalance(byte balance) {
            this.balance = balance;
        }

        public int getChannel() {
            return channel;
        }

        public void setChannel(int channel) {
            this.channel = channel;
        }

        public byte getChorus() {
            return chorus;
        }

        public void setChorus(byte chorus) {
            this.chorus = chorus;
        }

        public int getInstrument() {
            return instrument;
        }

        public void setInstrument(int instrument) {
            this.instrument = instrument;
        }

        public byte getPhaser() {
            return phaser;
        }

        public void setPhaser(byte phaser) {
            this.phaser = phaser;
        }

        public byte getReverb() {
            return reverb;
        }

        public void setReverb(byte reverb) {
            this.reverb = reverb;
        }

        public byte getTremolo() {
            return tremolo;
        }

        public void setTremolo(byte tremolo) {
            this.tremolo = tremolo;
        }

        public byte getVolume() {
            return volume;
        }

        public void setVolume(byte volume) {
            this.volume = volume;
        }
    }
}