/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;



/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class Tablature extends Composite {
    private SongManager songManager;
    private SongCoords songCoords;
    private Caret caret;
    private int width;
    private int height;
    private ViewLayout viewLayout;

    public Tablature(final Composite parent, int style) {
        super(parent, style);        

        this.setBackground(new Color(getDisplay(), 255, 255, 255));
        this.addPaintListener(new TablaturePaintListener(this));
        
        
        final Point origin = new Point(0, 0);
        final ScrollBar hBar = getHorizontalBar();
        hBar.addListener(SWT.Selection, new Listener() {
          public void handleEvent(Event e) {
            int hSelection = hBar.getSelection();
            int destX = -hSelection - origin.x;
            Rectangle rect = getClientArea();
            getShell().scroll(destX, 0, 0, 0, rect.width, rect.height, false);
            origin.x = -hSelection;           
            redraw();
          }
        });
        final ScrollBar vBar = getVerticalBar();
        vBar.addListener(SWT.Selection, new Listener() {
          public void handleEvent(Event e) {
            int vSelection = vBar.getSelection();
            int destY = -vSelection - origin.y;
            Rectangle rect = getBounds();
            getShell().scroll(0, destY, 0, 0, rect.width, rect.height, false);
            origin.y = -vSelection;            
            redraw();
          }
        });        

    }    
    
 
    
    public void init(){
        this.viewLayout = new PageViewLayout(this,this.songManager,false);
        this.songCoords = new SongCoords(this,this.songManager/*,this.viewLayout*/);        
        this.caret = new Caret(this,this.songManager,this.songCoords);
    }
    
    public void updateTablature(){
        getViewLayout().updateSong();
        
        /*
        this.songCoords.createTracks();
        this.songCoords.updateTracks();
        */   
        
    }

    public void initCaret(){
        SongTrackCoords firstTrack = (SongTrackCoords)this.songCoords.getTrackCoords().get(0);        
        this.caret.update((Measure)firstTrack.getTrack().getMeasures().get(0));        
    }

    public void paintTablature(GC gc){            
        //Si estoy reproduciendo muevo el scroll al compas que se esta ejecutando
        if(songManager.getPlayer().isRunning()){
            //MeasureCoords measure = this.songCoords.getFirstTrack().getMeasure(songManager.getPlayer().getTickPosition());
            MeasureCoords measure = getCaret().getSongTrackCoords().getMeasure(songManager.getPlayer().getTickPosition());
            getViewLayout().followMeasure(measure,false);            
            
        }
        
        
        int hScroll = getHorizontalBar().getSelection();
        int vScroll = getVerticalBar().getSelection();                	
        
        this.getViewLayout().paintSong(gc,getClientArea(),-hScroll,-vScroll);        
          
        this.width = this.viewLayout.getWidth();
        this.height = this.viewLayout.getHeight();
        
        if(songManager.getPlayer().isRunning()){
            gc.drawString("Running position: " + songManager.getPlayer().getTickPosition(),10,10);
        }
        
        this.updateScroll();
        
        //Si no estoy reproduciendo muevo el scroll al compas que tiene el caret
        if(getCaret().hasChanges() && !songManager.getPlayer().isRunning()){   
            getCaret().setChanges(false);
            getViewLayout().followMeasure(getCaret().getMeasureCoords(),true); 
        } 
        
                              
    }

    public void updateScroll(){
		Rectangle rect = getBounds();
		Rectangle client = getClientArea();        
        ScrollBar hBar = getHorizontalBar();
        ScrollBar vBar = getVerticalBar();
		hBar.setMaximum(width + 22);
		vBar.setMaximum(height);
		hBar.setThumb(Math.min(rect.width, client.width));
		vBar.setThumb(Math.min(rect.height, client.height));
    }
    
    public void moveScrollHorizontalTo(MeasureCoords measure,int leftSencibility,int rightSencibility,boolean redraw){
        if(measure != null){
            int selectcionX = getHorizontalBar().getSelection();
            int selectionWidth = getClientArea().width;
            
            int measureX = measure.getPosX();
            int measureWidth = measure.getWidth();
            
            if(measureX <= selectcionX){
                getHorizontalBar().setSelection(measureX - leftSencibility);
                if(redraw){
                    redraw();
                }
            }else if((measureX + measureWidth) >= (selectcionX + selectionWidth)){
                getHorizontalBar().setSelection((measureX - selectionWidth) + rightSencibility );
                if(redraw){
                    redraw();
                }
            }
        }           
    }
    
    public void moveScrollVerticalTo(MeasureCoords measure,int topSencibility,int bottomSencibility,boolean redraw){
        if(measure != null){
            int selectcionY = getVerticalBar().getSelection();
            int selectionHeight = getClientArea().height;
            
            int measureY = measure.getPosY();
            int measureHeight = measure.getHeight();
            
            if(measureY + selectcionY <= selectcionY){
                getVerticalBar().setSelection(selectcionY + (measureY)  - (topSencibility ));
                if(redraw){
                    redraw();
                }
            }else if((measureY + measureHeight + selectcionY) >= (selectcionY + selectionHeight)){                         
                getVerticalBar().setSelection(selectcionY + (selectionHeight - (selectionHeight - (measureY - measureHeight))) - (bottomSencibility ));
                if(redraw){
                    redraw();
                }
            }
        }           
    }    
    
    public void redraw(){
    	super.redraw();
    }
    
    public void resetScroll(){
        getHorizontalBar().setSelection(0);
        getVerticalBar().setSelection(0);
    }

    public Caret getCaret(){
        return this.caret;
    }
   
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    
    public SongCoords getSongCoords(){
        return this.songCoords;
    }
    
    public void changeCursor(int style){
        setCursor(new Cursor(getDisplay(),style));
    }    
    
    public ViewLayout getViewLayout(){
        return this.viewLayout;
    }
    
    public void setViewLayout(ViewLayout viewLayout){
        this.viewLayout = viewLayout;
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
    }    
}