/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongTrackCoords {    
    /**
     * Espacio por defecto para la posicion X
     */
    public static final int DEFAULT_HORIZONTAL_SPAN = 20;    
    /**
     * Espacio por defecto entre cuerda y cuerda
     */
    public static final int DEFAULT_STRING_SPAN = 12;
    
    private Tablature tablature;
    private SongManager songManager;
    private SongTrack track;
    private List measuresCoords;
    
    private int posX;
    private int posY;
    private int width;
    private int height;
    
    public SongTrackCoords(Tablature tablature,SongManager songManager,SongTrack track/*,ViewLayout layout*/) {
        this.tablature = tablature;
        this.track = track;
        this.songManager = songManager;
        this.measuresCoords = new ArrayList();
        this.posX = DEFAULT_HORIZONTAL_SPAN;
    }

    public void createMeasures() {
        this.measuresCoords.clear();
        for (int measureIdx = 0; measureIdx < track.getMeasures().size(); measureIdx++) {
            Measure measure = (Measure) track.getMeasures().get(measureIdx);
            MeasureCoords measureCoords = new MeasureCoords(measureIdx,this.songManager,this.tablature, measure, this);            
            measureCoords.create();                                    
            this.measuresCoords.add(measureCoords);
            
            if(tablature.getViewLayout().getQuarterSpans().size() > measureIdx){                                
                tablature.getViewLayout().getQuarterSpan(measureIdx).setQuarterSpan(measureCoords.getQuarterSpan());
            }else{
                tablature.getViewLayout().addQuarterSpan(new QuarterSpanHelper(measureCoords.getQuarterSpan()));
            }
        }
    }
    
    public void updateMeasures() {
        this.width = 0;
        int maxHeight = 0;
        for (int measureIdx = 0; measureIdx < getMeasuresCoords().size(); measureIdx++) {
            MeasureCoords measureCoords =  (MeasureCoords) getMeasuresCoords().get(measureIdx);                             
            measureCoords.setQuarterSpan(tablature.getViewLayout().getQuarterSpan(measureIdx).getQuarterSpan());                                    
            
            //asigno la posicion dentro del compas
            measureCoords.setPosX(this.width);
            measureCoords.setPosY(0);    
            
            measureCoords.update();
            
            this.width += measureCoords.getWidth();
            if(measureCoords.getHeight() > maxHeight){
                maxHeight = measureCoords.getHeight();
            }            
        }
        this.height = maxHeight;
    }
    
    public void fireChanges(int measureId,QuarterSpanHelper quarterSpan,boolean isNew){  
        MeasureCoords measureCoords = null;
        if(isNew){
            Measure measure = (Measure) track.getMeasures().get(measureId);
            measureCoords = new MeasureCoords(measureId,this.songManager,this.tablature, measure, this);
            getMeasuresCoords().add(measureCoords);
        }else{
            measureCoords =  (MeasureCoords) getMeasuresCoords().get(measureId);
        }
        measureCoords.create();            
        quarterSpan.setQuarterSpan(measureCoords.getQuarterSpan());

        
    }
    
    public void fireUpdate(int measureId,QuarterSpanHelper quarterSpan){        
        MeasureCoords measureCoords =  (MeasureCoords) getMeasuresCoords().get(measureId); 
        
        measureCoords.setQuarterSpan(tablature.getViewLayout().getQuarterSpan(quarterSpan,measureCoords));
        int oldWidth = measureCoords.getWidth();
        this.width -= oldWidth;
        
        measureCoords.update();     
        this.width += measureCoords.getWidth();
    }    
    
    private void checkPosX(int fromX){
        this.posX = DEFAULT_HORIZONTAL_SPAN;
        if(fromX <= -this.posX){
            this.posX = 0;
        }
    }
    
    public void paintTrack(GC gc,int fromX, int fromY,Rectangle clientArea){
        checkPosX(fromX);
        this.tablature.getViewLayout().paintMeasures(this,measuresCoords ,gc,fromX,fromY,clientArea);
        this.tablature.getViewLayout().paintStrings(this,gc,fromY,clientArea);
    }
            
    /**
     * Pinta los compases
     */    
    private void paintMeasures(GC gc,int fromX, int fromY,Rectangle clientArea) {        
        this.posY = fromY;
        int posX = this.posX;
        for (int measureIdx = 0; measureIdx < measuresCoords.size(); measureIdx++) {            
            MeasureCoords measureCoords = (MeasureCoords) measuresCoords.get(measureIdx);            
                      
            //asigno la posicion dentro del compas
            measureCoords.setPosX(posX);
            measureCoords.setPosY(0);            
            
            //Solo pinto lo que entre en pantalla
            if((posX + fromX) > clientArea.x - 1500 && (posX + fromX) < clientArea.x + clientArea.width + 100){                  
                measureCoords.paintMeasure(gc,posX + fromX, posY,clientArea);
            }
            posX += measureCoords.getWidth();                        
        }

    }

    
    /**
     * Pinta las cuerdas
     */
    private void paintStrings(GC gc,int fromY,Rectangle clientArea) {
        int posX = this.posX + clientArea.x;
        Iterator it = getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();
            int stringSpan = string.getNumber() * DEFAULT_STRING_SPAN;
            gc.drawLine(posX, fromY + stringSpan, posX + clientArea.width, fromY + stringSpan);
        }       
    }    
    
    public List getMeasuresCoords(){
        return this.measuresCoords;
    }
    
    public SongTrack getTrack(){
        return this.track;
    }
    
    
    public MeasureCoords getFirstMeasure(){
        MeasureCoords firstMeasure = null;    
        for(int measureIdx = 0;measureIdx < measuresCoords.size();measureIdx++){
            MeasureCoords currMeasure = (MeasureCoords)measuresCoords.get(measureIdx);
            if(firstMeasure == null || (currMeasure.getMeasure().getStart() < firstMeasure.getMeasure().getStart())){
                firstMeasure = currMeasure;
            }
        }        
        return firstMeasure;
    }     

    public MeasureCoords getLastMeasure(){
        int lastIndex = this.measuresCoords.size() - 1; 
        return (MeasureCoords)measuresCoords.get(lastIndex);
    }      
    
    public MeasureCoords getPrevMeasure(MeasureCoords measureCoords){
        int prevIndex = measureCoords.getMeasureId() - 1; 
        if(prevIndex >= 0){
            return (MeasureCoords)measuresCoords.get(prevIndex);
        }
        return null;
    }      
    
    public MeasureCoords getNextMeasure(MeasureCoords measureCoords){
        int nextIndex = measureCoords.getMeasureId() + 1; 
        if(nextIndex < measuresCoords.size()){
            return (MeasureCoords)measuresCoords.get(nextIndex);
        }
        return null;
    }       
  
    public MeasureCoords getMeasure(long start){
        MeasureCoords measureCoords = null;
        for (int measureIdx = 0; measureIdx < this.measuresCoords.size(); measureIdx++) {
            MeasureCoords measure = (MeasureCoords) this.measuresCoords.get(measureIdx);  
            long measureStart = measure.getMeasure().getStart();
            long measureLength = measure.getMeasure().getLength();
            if(start >= measureStart && start < measureStart + measureLength){
                return measure;
            }
        }     
        return null;
    }          
    
    public MeasureCoords getMeasure(Measure measure){
        MeasureCoords measureCoords = null;
        for (int measureIdx = 0; measureIdx < this.measuresCoords.size(); measureIdx++) {
            MeasureCoords currMeasure = (MeasureCoords) this.measuresCoords.get(measureIdx);            
            if(currMeasure.getMeasure().equals(measure)){
                measureCoords = currMeasure;
                break;
            }
        }     
        return measureCoords;
    }      
    
    
    /**
     * Retorna Todos los desde Start hasta el final del compas
     */
    public List getMeasuresBeforeEnd(long fromStart) {
        List measures = new ArrayList();        
        Iterator it = measuresCoords.iterator();
        while(it.hasNext()){           
            MeasureCoords currMeasure = (MeasureCoords)it.next();
            if (currMeasure.getMeasure().getStart() >= fromStart) {
                measures.add(currMeasure);
            }
        }
        return measures;
    }         
    
    /**
     * Retorna Todos los desde Start hasta el final del compas
     */
    public List getMeasuresBetween(long p1,long p2) {
        List measures = new ArrayList();        
        Iterator it = measuresCoords.iterator();
        while(it.hasNext()){           
            MeasureCoords currMeasure = (MeasureCoords)it.next();
            long start = currMeasure.getMeasure().getStart();
            if (start >= p1 && start <= p2) {
                measures.add(currMeasure);
            }
        }
        return measures;
    }      

    
    public MeasureCoords getMeasureAt(int x,int y,int hScroll,int vScroll){
        MeasureCoords measureCoords = null;
        long posX = this.posX + hScroll;
        
        Iterator it = measuresCoords.iterator();
        while(it.hasNext()){           
            MeasureCoords currMeasure = (MeasureCoords)it.next();

            boolean isAtX = (x >= posX + currMeasure.getPosX() && x <= posX + currMeasure.getPosX() + currMeasure.getWidth() + currMeasure.getSpan());
            boolean isAtY = (y + DEFAULT_STRING_SPAN >= currMeasure.getPosY()  && y - DEFAULT_STRING_SPAN <= currMeasure.getPosY()  + currMeasure.getHeight());        
            if(isAtX && isAtY){
                measureCoords = currMeasure;
                break;
            }     

        }
        return measureCoords;
    }    
    
    
    public void addNewMeasureBeforeEnd(){        
        addNewMeasureAfter(getLastMeasure().getMeasure());
    }    
    

    

    /**
     * Agrega un Compas
     */
    public void addNewMeasureAfter(Measure measure){
        TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();   
        Tempo tempo = (Tempo)measure.getTempo().clone(); 
        long start = measure.getStart() + measure.getLength();
        boolean repeatStart = false;
        int nombreOfRepetitions = 0;        
        addMeasure(new Measure(start, new ArrayList(), new ArrayList(), timeSignature,tempo,repeatStart,nombreOfRepetitions));
    }
        
    
    public List copyMeasures(long p1,long p2){
        List measures = new ArrayList();
        
        Iterator it = getMeasuresBetween(p1,p2).iterator();
        while(it.hasNext()){
            MeasureCoords measureCoords = (MeasureCoords)it.next();
            measures.add(measureCoords.getMeasure().clone());
        }
        return measures;
    }
    
    /**
     * Agrega un Compas
     */
    public void insertMeasures(List measures,int fromIndex){
        long start = -1;
        long end = 0;
        Iterator it = null;
        
        if(!measures.isEmpty()){
            start = ((Measure)measures.get(0)).getStart(); 
            end = ((Measure)measures.get(measures.size() - 1)).getStart() + ((Measure)measures.get(measures.size() - 1)).getLength();
            
            it = getMeasuresBeforeEnd(start).iterator();
            while(it.hasNext()){
                MeasureCoords measure = (MeasureCoords)it.next();
                moveMeasure(measure,end - start);            
            }

            it = measures.iterator();
            while(it.hasNext()){
                Measure measure = (Measure)it.next();
                addMeasure(fromIndex,measure);
                fromIndex ++;
            }        
        }
        
    }    
        
    
    /**
     * Agrega un Compas
     */
    public void addMeasure(Measure measure){
        this.track.getMeasures().add(measure);
    }    
    
    /**
     * Agrega un Compas
     */
    public void addMeasure(int index,Measure measure){
        this.track.getMeasures().add(index,measure);
    }        
    
    public void removeMeasure(long start){    
        removeMeasure(getMeasure(start));
    }
    
    public void removeMeasure(MeasureCoords measure){        
        long start = measure.getMeasure().getStart();
        long length = measure.getMeasure().getLength();
        
        List nextMeasures = getMeasuresBeforeEnd(start + 1);
        Iterator it = nextMeasures.iterator();
        while(it.hasNext()){
            MeasureCoords currMeasure = (MeasureCoords)it.next();
            moveMeasure(currMeasure,-length);            
        }
        
        this.track.getMeasures().remove(measure.getMeasure());  
    }
    
    /**
     * Mueve el compas
     */
    public void moveMeasure(MeasureCoords measure,long theMove){
        measure.moveAllComponents(theMove);
        measure.getMeasure().setStart(measure.getMeasure().getStart() + theMove);
    }
    
    
    
    public void changeTimeSignature(long start,TimeSignature timeSignature,boolean toEnd){
        changeTimeSignature(getMeasure(start),timeSignature,toEnd);
    }
    
    /**
     * Cambia el Ritmo
     */
    public void changeTimeSignature(MeasureCoords measure,TimeSignature timeSignature,boolean toEnd){        
        //asigno el nuevo ritmo
        measure.getMeasure().setTimeSignature((TimeSignature)timeSignature.clone());         

        long nextStart = measure.getMeasure().getStart() + measure.getMeasure().getLength();
        List measures = getMeasuresBeforeEnd(measure.getMeasure().getStart() + 1);
        Iterator it = measures.iterator();
        while(it.hasNext()){
            MeasureCoords nextMeasure = (MeasureCoords)it.next();
            
            long theMove = nextStart - nextMeasure.getMeasure().getStart();            
            moveMeasure(nextMeasure,theMove);
            
            if(toEnd){           
                nextMeasure.getMeasure().setTimeSignature((TimeSignature)timeSignature.clone());  
            }
            
            nextStart = nextMeasure.getMeasure().getStart() + nextMeasure.getMeasure().getLength();
        }
                  
    }

    public void changeTempo(long start,Tempo tempo,boolean toEnd){
        changeTempo(getMeasure(start),tempo,toEnd);
    }    
    
    public void changeTempo(MeasureCoords measure,Tempo tempo,boolean toEnd){        
        //asigno el nuevo tempo
        measure.getMeasure().setTempo((Tempo)tempo.clone());        

        if(toEnd){
            List measures = getMeasuresBeforeEnd(measure.getMeasure().getStart() + 1);
            Iterator it = measures.iterator();
            while(it.hasNext()){
                MeasureCoords nextMeasure = (MeasureCoords)it.next();
                nextMeasure.getMeasure().setTempo((Tempo)tempo.clone()); 
            }            
        }
        
    }    
    
    public void changeOpenRepeat(long start){
        Measure measure = getMeasure(start).getMeasure();
        measure.setRepeatStart(!measure.isRepeatStart());
    }    

    public void changeCloseRepeat(long start,int numberOfRepetitions){
        Measure measure = getMeasure(start).getMeasure();
        measure.setNumberOfRepetitions(numberOfRepetitions);
    }
    
    public void changeInfo(String name,TrackColor color){         
        getTrack().setName(name);
        getTrack().setColor(color);
    }
    
    
    public void changeInstrumentStrings(List strings){
        if(strings.size() < getTrack().getStrings().size()){
            removeNotesAfterString(strings.size());            
        }                
        getTrack().setStrings(strings);
    }
    
    public void removeNotesAfterString(int string){
        Iterator it = getMeasuresCoords().iterator();
        while(it.hasNext()){
            MeasureCoords nextMeasure = (MeasureCoords)it.next();
            nextMeasure.removeNotesAfterString(string);
        }          
    }
    
    public void changeInstrument(int instrument,boolean percusion){
            if(percusion){
                getTrack().setChannel(this.songManager.getFreeChannel(instrument,percusion));
                getTrack().setInstrument(instrument);
                getTrack().setStrings(SongManager.createPercusionStrings());
            }else{
                if(getTrack().isPercusionTrack()){
                    getTrack().setStrings(SongManager.createDefaultInstrumentStrings());
                }
                
                getTrack().setChannel(this.songManager.getFreeChannel(instrument,percusion));
                getTrack().setInstrument(instrument);            
            }        
        
    }
    
    public int getHeight() {
        return height;
    }
    public void setHeight(int height) {
        this.height = height;
    }
    public int getPosX() {
        return posX;
    }
    public void setPosX(int posX) {
        this.posX = posX;
    }
    public int getPosY() {
        return posY;
    }
    public void setPosY(int posY) {
        this.posY = posY;
    }
    public int getWidth() {
        return width;
    }
    public void setWidth(int width) {
        this.width = width;
    }
}