/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongCoords {
    private Tablature tablature;
    private SongManager songManager;
    private List tracksCoords;
    
    public SongCoords(Tablature tablature,SongManager songManager) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.init();
    }	

    public void init(){
        this.tracksCoords = new ArrayList();
    }    

    public void updateRepetitions(){
        this.songManager.calculateMeasureStartWidthRepetitions();
    }


    public SongTrackCoords getTrackAt(int y,int vScroll){
        return this.tablature.getViewLayout().getTrackAt(this.tracksCoords,y,vScroll);
    }
    
    public SongTrackCoords getNextTrack(SongTrackCoords trackCoords){
        SongTrackCoords track = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.equals(trackCoords)){
                int nextIndex = trackIdx + 1;
                if(nextIndex < this.tracksCoords.size()){
                    track = (SongTrackCoords)this.tracksCoords.get(nextIndex);                    
                }
                break;
            }
        }     
        return track;
    }
    
    public SongTrackCoords getPrevTrack(SongTrackCoords trackCoords){
        SongTrackCoords track = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.equals(trackCoords)){
                int prevIndex = trackIdx - 1;
                if(prevIndex >= 0){
                    track = (SongTrackCoords)this.tracksCoords.get(prevIndex);                    
                }
                break;
            }
        }     
        return track;
    }    
    
    public SongTrackCoords getTrack(SongTrack songTrack){
        SongTrackCoords trackCoords = null;
        for (int trackIdx = 0; trackIdx < this.tracksCoords.size(); trackIdx++) {
            SongTrackCoords currTrack = (SongTrackCoords) this.tracksCoords.get(trackIdx);            
            if(currTrack.getTrack().equals(songTrack)){
                trackCoords = currTrack;
                break;
            }
        }     
        return trackCoords;
    }        
    
    
    public SongTrackCoords getFirstTrack(){
        SongTrackCoords track = null;
        if(!this.tracksCoords.isEmpty()){
            track = (SongTrackCoords)this.tracksCoords.get(0);
        }
        return track;
    }       

    public SongTrackCoords getLastTrack(){
        SongTrackCoords track = null;
        if(!this.tracksCoords.isEmpty()){
            track = (SongTrackCoords)this.tracksCoords.get(this.tracksCoords.size() - 1);
        }
        return track;
    }               
     
    private SongTrack makeNewTrack(SongTrack songTrack){        
        //measures
        List measures = new ArrayList();        
        Iterator measureIt = songTrack.getMeasures().iterator();
        while(measureIt.hasNext()){
            Measure measure = (Measure)measureIt.next();
            
            long start = measure.getStart();
            boolean repeatStart = measure.isRepeatStart();
            int nombreOfRepetitions = measure.getNumberOfRepetitions();
            TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            
            measures.add(new Measure(start,new ArrayList(),new ArrayList(),timeSignature,tempo,repeatStart,nombreOfRepetitions));
        }
        //Strings
        String name = "Track " + (getTrackCoords().size() + 1);
        List strings = SongManager.createDefaultInstrumentStrings();
        int channel = getSongManager().getFreeChannel(0,false);
        return new SongTrack(name,channel,0,measures,strings,TrackColor.RED);
    }
    
    public void createTrack(){
        SongTrack track = null;
        if(this.songManager.getSong().getTracks().isEmpty()){
            track = SongManager.makeNewTrack("Track 1");
        }else{
            track = makeNewTrack(getFirstTrack().getTrack());
        }
        addTrack(track);
    }
    
    public void addTrack(SongTrack track){
        this.songManager.getSong().getTracks().add(track);
    }

    public void removeTrack(SongTrackCoords track){
        removeTrack(track.getTrack());
    }

    public void removeTrack(SongTrack track){
        this.songManager.getSong().getTracks().remove(track);
    }
    
    
    public void changeTimeSignature(long start,TimeSignature timeSignature,boolean toEnd){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeTimeSignature(start,timeSignature,toEnd);
        }
    }
    
    public void changeTempo(long start,Tempo tempo,boolean toEnd){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeTempo(start,tempo,toEnd);
        }
    }    

    
    public void changeOpenRepeat(long start){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeOpenRepeat(start);
        }
        updateRepetitions();
    }        
    
    public void changeCloseRepeat(long start,int numberOfRepetitions){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.changeCloseRepeat(start,numberOfRepetitions);
        }
        updateRepetitions();
    }         

    public void addNewMeasureBeforeEnd(){        
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.addNewMeasureBeforeEnd();
        }                
    }

    public void removeMeasure(long start){
        Iterator it = this.tracksCoords.iterator();
        while(it.hasNext()){
            SongTrackCoords trackCoords = (SongTrackCoords)it.next();
            trackCoords.removeMeasure(start);
        }        
    }
        
    
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    public List getTrackCoords(){
        return this.tracksCoords;
    }

}