/*
 * Created on 01-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Silence;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SilenceCoords implements MeasureComponent {
    /**
     * Widget de la tablatura
     */
    private Tablature tablature;
    /**
     * Coordenadas del compas
     */
    private MeasureCoords meassureCoords;
    /**
     * Silencio de Referencia
     */    
    private Silence silence;
    /**
     * Imagen del Silencio
     */
    private Image image;
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /**
     * Posicion Y dentro del compas
     */
    private int posY;
    /**
     * Coordenadas de los dibujos de las figuras
     */
    private DurationCoords durationCoords;

    
    private int span;
    
    
    private int pointX;
    
    private int pointY;    
    
    public SilenceCoords(Tablature tablature, MeasureCoords meassureCoords,Silence silence, int posX, int posY) {
        this.tablature = tablature;
        this.meassureCoords = meassureCoords;
        this.silence = silence;
        this.posX = posX;
        this.posY = posY;
    }

    public void update() {
        if (getDuration() != null) {
            String fileName = "silence" + getDuration().getValue() + ".gif";
            String path = TuxGuitar.getResourcePath(this, fileName);
            if (path != null) {
                this.image = new Image(this.tablature.getDisplay(), path);
            }
        }
    }

    public void paint(GC gc, int fromX, int fromY) {
        if (this.silence != null && this.image != null) {
            int center =  ((this.meassureCoords.getHeight()) / 2);
            
            int x = this.posX + fromX - 10 + getSpan();
            int y = fromY + (center - 10);
            
            gc.drawImage(this.image, x, y);
            this.pointX = x + 10;
            
            if(this.silence.getDuration().isDotted() || this.silence.getDuration().isDoubleDotted()){
                gc.drawOval(x + 23,y + 15,1,1);
                if(this.silence.getDuration().isDoubleDotted()){
                    gc.drawOval(x + 26,y + 15,1,1);
                }
            }              
            if(!this.silence.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)){
                gc.drawString(Integer.toString(this.silence.getDuration().getTupleto().getEnters()),x + 15,y + 81);                
            }            
        } else {
            int x = this.posX + fromX + 3 + getSpan();
            int y = this.posY + fromY + 15;
            gc.drawString("S", x, y);
        }
      
    }

    
    /**
     * Asigna la duracion del silencio
     */    
    public void setDuration(Duration duration){
        this.silence.setDuration(duration);
    }       
    
    public Duration getDuration() {
        return this.silence.getDuration();
    }

    /**
     * Asigna el start de el silencio
     */
    public void setStart(long start){
        this.silence.setStart(start);
    }    
    
    public long getStart() {
        return this.silence.getStart();
    }

    public Silence getSilence(){
        return this.silence;
    }
    
    public int getPosX(){
        return this.posX;
    }
    
    public int getPosY(){
        return this.posY;
    }    
    
    
    public int getSpan(){
        return this.span;
    }
    
    public void setSpan(int span){
        this.span = span;
    }
    
    
    public int getPointX(){
        return this.pointX;
    }
    public int getPointY(){
        return this.pointY;
    }    
}