/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PageViewLayout extends ViewLayout{
    private int displayWidth;
    private int divisionCount;
    
    public PageViewLayout(Tablature tablature,SongManager songManager,boolean multitrack){
        super(tablature,songManager,multitrack);
        this.displayWidth = getTablature().getDisplay().getBounds().width - 35;
    }
    
    
    public void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY){ 
        if(isMultitrack()){
            paintTracks(getTablature().getCaret().getSongCoords().getTrackCoords(),gc,clientArea,fromX,fromY);
        }else{
            List tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
            paintTracks(tracksCoords,gc,clientArea,fromX,fromY);
        }
    }
    
    public void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY) {               
        int posY = fromY + DEFAULT_FIRST_TRACK_SPAN;
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords) tracksCoords.get(trackIdx);
            
            trackCoords.paintTrack(gc,fromX, posY,clientArea);            
            posY += DEFAULT_TRACK_SPAN;
        }                  
    }

    
    
    public void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,Rectangle clientArea) {  
        trackCoords.setPosY(fromY);        
        int posX = trackCoords.getPosX();
        int posY = trackCoords.getPosY();
        int width = 0;
        int height = 0;
        this.divisionCount = 1;
        
        int tempWidth = SongTrackCoords.DEFAULT_HORIZONTAL_SPAN;
        List tempMeasures = new ArrayList();
        for (int measureIdx = 0; measureIdx < measuresCoords.size(); measureIdx++) {            
            MeasureCoords measureCoords = (MeasureCoords) measuresCoords.get(measureIdx);                                            
            measureCoords.calculateWidth();    
            
            //verifico si tengo que bajar de linea
            if((tempWidth + measureCoords.getWidth()) >=  getMaxWidth() && !tempMeasures.isEmpty()){
                
                
                int measureSpan = 0;
                int diff = ( getMaxWidth() - tempWidth);
                if(diff > tempMeasures.size() && tempMeasures.size() > 0){
                    measureSpan = diff / tempMeasures.size();
                }
                
                Iterator it = tempMeasures.iterator();
                while(it.hasNext()){
                    MeasureCoords currMeasureCoords = (MeasureCoords)it.next();
                        
                    //asigno la posicion dentro del compas
                    currMeasureCoords.setPosX(posX);
                    currMeasureCoords.setPosY(posY);              
                    
                    //Solo pinto lo que entre en pantalla
                    boolean isAtX = ((posX + fromX) > clientArea.x - 1500 && (posX + fromX) < clientArea.x + clientArea.width + 100);
                    boolean isAtY = (posY > clientArea.y - DEFAULT_TRACK_SPAN && posY < clientArea.y + clientArea.height + DEFAULT_TRACK_SPAN);
                    
                    if(isAtX && isAtY){                              
                        currMeasureCoords.setSpan(measureSpan);                
                        currMeasureCoords.paintMeasure(gc,posX + fromX, posY,clientArea);
                    }
                    
                    posX += currMeasureCoords.getWidth() + currMeasureCoords.getSpan();
                    
                    if(posX > width){
                        width = posX;
                    }                    
                                    
                }                
                
                posX = trackCoords.getPosX();
                posY += (getLinearSpan());
                height += getLinearSpan();                                          
                tempWidth = SongTrackCoords.DEFAULT_HORIZONTAL_SPAN;
                tempMeasures.clear();
                this.divisionCount ++;
            }
            tempWidth +=  measureCoords.getWidth();       
            tempMeasures.add(measureCoords);

            
        }
        
        Iterator it = tempMeasures.iterator();
        while(it.hasNext()){
            MeasureCoords currMeasureCoords = (MeasureCoords)it.next();
                
            //asigno la posicion dentro del compas
            currMeasureCoords.setPosX(posX);
            currMeasureCoords.setPosY(posY);              
            
            //Solo pinto lo que entre en pantalla
            boolean isAtX = ((posX + fromX) > clientArea.x - 1500 && (posX + fromX) < clientArea.x + clientArea.width + 100);
            boolean isAtY = (posY > clientArea.y - DEFAULT_TRACK_SPAN && posY < clientArea.y + clientArea.height + DEFAULT_TRACK_SPAN);
            
            if(isAtX && isAtY){                              
                currMeasureCoords.setSpan(0);                
                currMeasureCoords.paintMeasure(gc,posX + fromX, posY,clientArea);
            }
            
            posX += currMeasureCoords.getWidth() + currMeasureCoords.getSpan();
            
            if(posX > width){
                width = posX;
            }                    
        
        }        
        height += getLinearSpan();   
        
        setWidth(width);
        setHeight(height + DEFAULT_TRACK_SPAN + 100);
    }    
    
    
    
    
    
    
    
    
    
    
    
    
    /**
     * Pinta las cuerdas
     */
    public void paintStrings(SongTrackCoords trackCoords,GC gc,int fromY,Rectangle clientArea) {                
        int posX = SongTrackCoords.DEFAULT_HORIZONTAL_SPAN - getTablature().getHorizontalBar().getSelection();
        posX = (posX < 0)?0:posX;
        
        //verifico si tengo que bajar de linea
        int linearSpan = getLinearSpan();
        int trackSpan = trackCoords.getTrack().getStrings().size() * SongTrackCoords.DEFAULT_STRING_SPAN;
        
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();
            int stringSpan = string.getNumber() * SongTrackCoords.DEFAULT_STRING_SPAN;
            for(int i = 0;i<this.divisionCount;i++){
                int y = fromY + stringSpan + (i * linearSpan);
                boolean isAtY = ((y - trackSpan) > clientArea.y - DEFAULT_TRACK_SPAN && (y + trackSpan) < clientArea.y + clientArea.height + DEFAULT_TRACK_SPAN);
                if(isAtY){
                    gc.drawLine(posX,y, getMaxWidth(),y);
                }
            }
        }       
    }    
    
    
    public SongTrackCoords getTrackAt(List tracksCoords,int y,int vScroll){
        if(!isMultitrack()){
            tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
        }           
        SongTrackCoords trackCoords = null;    
        int linearSpan = getLinearSpan();
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords track = (SongTrackCoords) tracksCoords.get(trackIdx);            
                          
            int trackHeight = track.getHeight();
            for(int i = 0;i<this.divisionCount;i++){
                int posY = track.getPosY() + (i * linearSpan);                
                if(y >= (posY - (DEFAULT_TRACK_SPAN / 2)) && y <= (posY + trackHeight + (DEFAULT_TRACK_SPAN / 2))){
                    trackCoords = track;
                }
                posY += linearSpan;
            }
                                    
        }     
        return trackCoords;
    }       
    
    
    
    
    public void followMeasure(MeasureCoords measure,boolean redraw){
        getTablature().moveScrollVerticalTo(measure,ViewLayout.DEFAULT_FIRST_TRACK_SPAN,ViewLayout.DEFAULT_FIRST_TRACK_SPAN,redraw);
    }
    
    
    
    
    private int getLinearSpan(){
        int linearSpan = 200;
        if(isMultiTrack()){
            linearSpan = linearSpan * getTrackCount();
        }
        return linearSpan;
    }
    
    
   
    public int getMaxWidth(){
        return displayWidth;
    }
    
    

    
    
}
