/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class LinearViewLayout extends ViewLayout{

    public LinearViewLayout(Tablature tablature,SongManager songManager,boolean multitrack){
        super(tablature,songManager,multitrack);
    }
    
    
    public void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY){        
        if(isMultitrack()){
            paintTracks(getTablature().getCaret().getSongCoords().getTrackCoords(),gc,clientArea,fromX,fromY);
        }else{
            List tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
            paintTracks(tracksCoords,gc,clientArea,fromX,fromY);
        }
    }
    
    public void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY) {               
        int posY = fromY + DEFAULT_FIRST_TRACK_SPAN;
        int height = 0;   
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords) tracksCoords.get(trackIdx);
            
            trackCoords.paintTrack(gc,fromX, posY,clientArea);            
            posY += DEFAULT_TRACK_SPAN;
            
            height += DEFAULT_TRACK_SPAN;   
        }                  
        setHeight(height + 100);
    }
    

    
    public void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,Rectangle clientArea) {        
        trackCoords.setPosY(fromY);
        int posX = trackCoords.getPosX();
        int posY = trackCoords.getPosY();
        int width = 0;
             
        for (int measureIdx = 0; measureIdx < measuresCoords.size(); measureIdx++) {            
            MeasureCoords measureCoords = (MeasureCoords) measuresCoords.get(measureIdx);            
                      
            //asigno la posicion dentro del compas
            measureCoords.setPosX(posX);
            measureCoords.setPosY(posY);            
            
            //Solo pinto lo que entre en pantalla
            if((posX + fromX) > clientArea.x - 1500 && (posX + fromX) < clientArea.x + clientArea.width + 100){                  
                measureCoords.setSpan(0);  
                measureCoords.paintMeasure(gc,posX + fromX, posY,clientArea);
            }
            posX += measureCoords.getWidth();       
            
            width = posX;
        }

        setWidth(width);
        
    }

    
    /**
     * Pinta las cuerdas
     */
    public void paintStrings(SongTrackCoords trackCoords,GC gc,int fromY,Rectangle clientArea) {
        int posX = SongTrackCoords.DEFAULT_HORIZONTAL_SPAN - getTablature().getHorizontalBar().getSelection();
        posX = (posX < 0)?0:posX;
        
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();
            int stringSpan = string.getNumber() * SongTrackCoords.DEFAULT_STRING_SPAN;
            gc.drawLine(posX, fromY + stringSpan, posX + clientArea.width, fromY + stringSpan);
        }       
    }    
    
    
    public void followMeasure(MeasureCoords measure,boolean redraw){
        getTablature().moveScrollHorizontalTo(measure,50,getTablature().getClientArea().width - 100,redraw);
    }
    
    
    public SongTrackCoords getTrackAt(List tracksCoords,int y,int vScroll){
        if(!isMultitrack()){
            tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
        }        
        SongTrackCoords trackCoords = null;
        int posY = DEFAULT_FIRST_TRACK_SPAN + vScroll;        
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords track = (SongTrackCoords) tracksCoords.get(trackIdx);            
            int trackWidth = track.getWidth();
            int trackHeight = track.getHeight();
            if(y >= posY && y <= posY + trackHeight){
                trackCoords = track;
            }            
            posY += DEFAULT_TRACK_SPAN;
        }     
        return trackCoords;
    }    
    
}
