/*
 * Created on 09-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.language;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Properties;

import org.herac.tuxguitar.gui.TuxGuitar;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class LanguageManager {
    private Properties properties;
    private String language;
    private String[] languages;
    
    public LanguageManager() {
        this.properties = new Properties();            
        this.loadLanguages();
    }
    
    public void setLanguage(String lang) {
        this.language = getLanguaje(lang);
        try {                    
            InputStream inputStream = new FileInputStream(getPathName() + File.separator + this.language + ".properties");                        
            this.properties.clear();
            this.properties.load(inputStream);            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    
    public String getProperty(String key) {
        return this.properties.getProperty(key,key);        
    }    
        
    public String getLanguage() {
        return language;
    }
    
    
    public String[] getLanguages() {
        return languages;
    }
    
    
    private void loadLanguages(){        
        final FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return (name.indexOf(".properties") > 0);
            }
        };
        
        String[] fileNames = new File(getPathName()).list(filter);        
        this.languages = new String[fileNames.length];
        for(int i = 0;i < fileNames.length;i++){
            int extensionIndex = fileNames[i].indexOf(".properties");
            if(extensionIndex >= 0){
                this.languages[i] = fileNames[i].substring(0,extensionIndex);
            }
        }
    }    
    
    private String getLanguaje(String lang){
        for(int i = 0;i < this.languages.length;i++){            
            if(this.languages[i].equals(lang)){
                return lang;
            }
        }        
        if(this.languages.length > 0){
            return this.languages[0];
        }
        
        return null;
    }
    
    private String getPathName(){
        return TuxGuitar.instance().getBasePath() + "lang";
    }
    

}