/*
 * Created on 28-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.fretboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.caret.GoLeftAction;
import org.herac.tuxguitar.gui.actions.caret.GoRightAction;
import org.herac.tuxguitar.gui.actions.duration.DecrementDurationAction;
import org.herac.tuxguitar.gui.actions.duration.IncrementDurationAction;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class FretBoard extends Composite {
	public static final int MAX_FRETS = 24;

	private TablatureEditor editor;

	private Composite toolComposite;
	
	private Composite fretBoardComposite;

	private DurationImage[] images;

	private Image firstFretImage;
	
	private Image fretImage;	
	
	private Label durationLabel;

	private Combo handSelector;
	
	private List components;

	private int[] frets;

	private int[] strings;

	private int fretSpan;

	private int stringSpan;

	public FretBoard(Composite parent, TablatureEditor editor) {
		super(parent, SWT.NONE);
		this.setLayout(new FormLayout());
		this.editor = editor;
		this.initToolBar();
		this.initEditor();

		this.components = new ArrayList();
		this.layout(getDisplay().getBounds().width,150,1);
		//this.calculateFretSpan(getDisplay().getBounds().width);
		//this.calculateStringSpan(150);
		//this.initFrets(10, 1);
		//this.initStrings(10, getStringCount());
		
	}

	private void initToolBar() {
	    toolComposite = new Composite(this, SWT.NONE);
	    toolComposite.setLayout(new GridLayout(3, true));

		// posicion del caret
		Composite caretComposite = new Composite(toolComposite, SWT.NONE);
		caretComposite.setLayout(new GridLayout(2, true));
		Button goLeft = new Button(caretComposite, SWT.ARROW | SWT.LEFT);
		goLeft.addSelectionListener(TuxGuitar.instance().getAction(GoLeftAction.NAME));
		Button goRight = new Button(caretComposite, SWT.ARROW | SWT.RIGHT);
		goRight.addSelectionListener(TuxGuitar.instance().getAction(GoRightAction.NAME));

		// duracion
		Composite durationComposite = new Composite(toolComposite, SWT.NONE);
		durationComposite.setLayout(new GridLayout(3, false));
		Button decrement = new Button(durationComposite, SWT.ARROW | SWT.MIN);
		decrement.addSelectionListener(TuxGuitar.instance().getAction(DecrementDurationAction.NAME));
		this.initDurationImages();
		this.durationLabel = new Label(durationComposite, SWT.BORDER);
		this.durationLabel.setImage(getDurationImage());

		Button increment = new Button(durationComposite, SWT.ARROW | SWT.MAX);
		increment.addSelectionListener(TuxGuitar.instance().getAction(IncrementDurationAction.NAME));

		// guitarra para diestros/zurdos
		this.handSelector = new Combo(toolComposite, SWT.NONE);
		handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
		handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
		handSelector.select(0);
		handSelector.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				int index = handSelector.getSelectionIndex();
				if (index == 0) {
					initFrets(10, 1);
				} else {
					initFrets(10, 2);
				}
				fretBoardComposite.redraw();
			}
		});

	}

	private void initEditor() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0, 50);
		data.bottom = new FormAttachment(100, 0);

		this.fretBoardComposite = new Composite(this, SWT.BORDER);
		this.fretBoardComposite.setLayoutData(data);

		this.fretBoardComposite.setBackground(new Color(getDisplay(), 255, 255, 255));
		this.fretBoardComposite.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				paintEditor(e.gc);
			}
		});

		this.fretBoardComposite.addMouseListener(new MouseListener() {
			public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
			}

			public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
			}

			public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
				hit(e.x, e.y);
				afterAction();
			}
		});

		this.initFretBoardImages();
	}

	private void initFretBoardImages(){
	    this.firstFretImage = new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "firstfret.png"));
	    this.fretImage = new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "fret.png"));
	}
	
	private void initDurationImages() {
		this.images = new DurationImage[7];
		this.images[0] = new DurationImage(new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "1.png")), 1);
		this.images[1] = new DurationImage(new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "2.png")), 2);
		this.images[2] = new DurationImage(new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "4.png")), 4);
		this.images[3] = new DurationImage(new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "8.png")), 8);
		this.images[4] = new DurationImage(new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "16.png")), 16);
		this.images[5] = new DurationImage(new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "32.png")), 32);
		this.images[6] = new DurationImage(new Image(this.getDisplay(), TuxGuitar.getResourcePath(this, "64.png")), 64);
	}

	private Image getDurationImage() {
		Duration duration = (Duration) editor.getTablature().getCaret().getDuration().clone();
		for (int i = 0; i < images.length; i++) {
			if (images[i].getDurationValue() == duration.getValue()) {
				return images[i].getImage();
			}
		}
		return this.durationLabel.getImage();
	}

	private void calculateFretSpan(int width) {
		this.fretSpan = (width / MAX_FRETS);
		int aux = 0;
		for (int i = 0; i < MAX_FRETS; i++) {
			aux += (i * 2);
		}
		this.fretSpan += (aux / MAX_FRETS) + 2;
	}

	private void calculateStringSpan(int height) {
		this.stringSpan = (height / 6);
	}

	private void initFrets(int fromX, int hand) {
		this.frets = new int[MAX_FRETS];
		int nextX = fromX;
		if (hand == 1) {
			for (int i = 0; i < this.frets.length; i++) {
				this.frets[i] = nextX;
				nextX += (this.fretSpan - ((i + 1) * 2));
			}
		} else if (hand == 2) {
			for (int i = this.frets.length - 1; i >= 0; i--) {
				this.frets[i] = nextX;
				nextX += (this.fretSpan - (i * 2));
			}
		}
	}

	private void initStrings(int fromY, int count) {
		this.strings = new int[count];

		for (int i = 0; i < this.strings.length; i++) {
			this.strings[i] = fromY + (this.stringSpan * i);
		}
	}

	private void updateEditor() {
		this.components.clear();
		Caret caret = this.editor.getTablature().getCaret();
		MeasureCoords measure = caret.getMeasureCoords();
		if (measure != null) {
			this.components = measure.getComponents(caret.getPosition());
		}

		if (this.strings.length != getStringCount()) {
			initStrings(10, getStringCount());
		}
		
		if(isVisible()){
		    int width = getWidth();		    
		    int height = getHeight();
		    int clientWidth = getClientArea().width;
		    int clientHeight = getClientArea().height;
		    
		    if((width + 20) < clientWidth || width > clientWidth){
		        layout(getClientArea().width,150,this.handSelector.getSelectionIndex() + 1);
		    }		   
		    
		    if(height < clientHeight || (height + 10) > clientHeight){
		        TuxGuitar.instance().showFretBoard();
		        //TuxGuitar.instance().updateSashNumerator();
		    }
		}
	}

	private void paintEditor(GC gc) {	    
		this.updateEditor();
		if (this.frets.length > 0 && this.strings.length > 0) {
		    //fondo
		    gc.setBackground(getDisplay().getSystemColor(SWT.COLOR_BLACK));		    
		    gc.fillRectangle(getClientArea());
		    

			// pinto las cegillas
		    gc.drawImage(firstFretImage,0,0,firstFretImage.getBounds().width,firstFretImage.getBounds().height,frets[0] - 5,strings[0] - 5,firstFretImage.getBounds().width,strings[strings.length - 1] );
		    paintFretPoints(gc,0);
		    for (int i = 1; i < this.frets.length; i++) {			    
			    gc.drawImage(fretImage,0,0,fretImage.getBounds().width,fretImage.getBounds().height,frets[i],strings[0] - 5,fretImage.getBounds().width,strings[strings.length - 1] );
			    //gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_DARK_MAGENTA));
				//gc.drawLine(frets[i], strings[0], frets[i], strings[strings.length - 1]);
				paintFretPoints(gc, i);
			}

			// pinto las cuerdas
			for (int i = 0; i < this.strings.length; i++) {
			    gc.setForeground(new Color(getDisplay(),227,217,217));
			    if(i > 2){
			        gc.setLineWidth(2);
			    }
				gc.drawLine(frets[0], strings[i], frets[frets.length - 1], strings[i]);
			}
			
			// pinto los componentes
			gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_BLUE));
			gc.setLineWidth(10);
			Iterator it = this.components.iterator();
			while (it.hasNext()) {
				MeasureComponent component = (MeasureComponent) it.next();
				if (component instanceof NoteCoords) {
					NoteCoords note = (NoteCoords) component;
					int fretIndex = note.getNote().getValue();
					int stringIndex = note.getNote().getString() - 1;
					if (fretIndex < this.frets.length && stringIndex < this.strings.length) {
						int x = this.frets[fretIndex];
						if (fretIndex > 0) {
							x -= ((this.frets[fretIndex] - this.frets[fretIndex - 1]) / 2);
						}
						int y = this.strings[stringIndex] - 3;

						gc.drawOval(x, y, 5, 5);
					}

				}
			}
			gc.setLineWidth(1);
			gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_BLACK));
		}
	}

	private void paintFretPoints(GC gc, int fretIndex) {
	    gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_WHITE));
		if ((fretIndex + 1) < this.frets.length) {
			int fret = fretIndex + 1;

			while (fret >= 12) {
				fret -= 12;
			}
			if (fret == 0) {
				gc.setLineWidth(10);
				int x = this.frets[fretIndex] + ((this.frets[fretIndex + 1] - this.frets[fretIndex]) / 2);
				int y1 = this.strings[0] + ((this.strings[this.strings.length - 1] - this.strings[0]) / 2) - stringSpan;
				int y2 = this.strings[0] + ((this.strings[this.strings.length - 1] - this.strings[0]) / 2) + stringSpan;
				gc.drawOval(x, y1 - 2, 5, 5);
				gc.drawOval(x, y2 - 2, 5, 5);
				gc.setLineWidth(1);
			} else if (fret == 3 || fret == 5 || fret == 7 || fret == 9) {
				gc.setLineWidth(10);
				int x = this.frets[fretIndex] + ((this.frets[fretIndex + 1] - this.frets[fretIndex]) / 2);
				int y = this.strings[0] + ((this.strings[this.strings.length - 1] - this.strings[0]) / 2);
				gc.drawOval(x, y - 2, 5, 5);
				gc.setLineWidth(1);

			}

		}

	}

	private void hit(int x, int y) {
		int fretIndex = getFretIndex(x);
		int stringIndex = getStringIndex(y);

		if (!removeNote(fretIndex, stringIndex + 1)) {
			addNote(fretIndex, stringIndex + 1);
		}
	}

	private int getStringIndex(int y) {
		int index = -1;
		for (int i = 0; i < this.strings.length; i++) {
			if (index < 0) {
				index = i;
			} else {
				int distanceY = Math.abs(y - this.strings[index]);
				int currDistanceY = Math.abs(y - this.strings[i]);
				if (currDistanceY < distanceY) {
					index = i;
				}
			}
		}
		return index;
	}

	private int getFretIndex(int x) {
		int length = this.frets.length;
		if ((x - 10) <= frets[0] && frets[0] < frets[length - 1]) {
			return 0;
		}
		if ((x + 10) >= frets[0] && frets[0] > frets[length - 1]) {
			return 0;
		}

		for (int i = 0; i < length; i++) {
			if ((i + 1) < length) {
				if (x > frets[i] && x <= frets[i + 1] || x > frets[i + 1] && x <= frets[i]) {
					return i + 1;
				}
			}
		}
		return length - 1;
	}

	private boolean removeNote(int fret, int string) {
		Iterator it = this.components.iterator();
		while (it.hasNext()) {
			MeasureComponent component = (MeasureComponent) it.next();
			if (component instanceof NoteCoords) {
				Note note = ((NoteCoords) component).getNote();
				if (note.getValue() == fret && note.getString() == string) {
					Caret caret = this.editor.getTablature().getCaret();
					caret.getMeasureCoords().removeNote(note);
					return true;
				}
			}
		}
		return false;
	}

	private int getStringCount() {
		return editor.getTablature().getCaret().getSongTrackCoords().getTrack().getStrings().size();
	}

	private void addNote(int fret, int string) {
		Caret caret = this.editor.getTablature().getCaret();
		Duration duration = (Duration) caret.getDuration().clone();
		Note note = new Note(fret, caret.getPosition(), duration, 64, string, false, new NoteEffect());
		caret.getMeasureCoords().addNote(note);
	}

	private void afterAction() {
		this.editor.getTablature().getViewLayout().fireUpdate(this.editor.getTablature().getCaret().getMeasureCoords().getMeasureId(), false);
		TuxGuitar.instance().redraw();
	}

	public void redraw() {
		super.redraw();
		this.fretBoardComposite.redraw();
		this.durationLabel.setImage(getDurationImage());
	}

    public void loadProperties(){
	    this.handSelector.setItem(0,TuxGuitar.getProperty("fretboard.right-mode"));
	    this.handSelector.setItem(1,TuxGuitar.getProperty("fretboard.left-mode"));
	    this.handSelector.setText(this.handSelector.getItem(this.handSelector.getSelectionIndex()));
	    this.layout();
    }
	
	public int getHeight(){
	    return ((this.stringSpan * this.strings.length) + this.toolComposite.getBounds().height) + 6;
	}
	
	public int getWidth(){
	    return this.frets[this.frets.length - 1];
	}	
	
	public void layout(){
	    super.layout();
	    //this.layout(getClientArea().width,150);
	}
	
	public void layout(int width,int height,int hand){
		this.calculateFretSpan(width);
		this.calculateStringSpan(height);
		this.initFrets(10,hand);
		this.initStrings(10, getStringCount());
	}

	private class DurationImage {
		private Image image;

		private int durationValue;

		public DurationImage(Image image, int durationValue) {
			this.image = image;
			this.durationValue = durationValue;
		}

		public int getDurationValue() {
			return durationValue;
		}

		public void setDurationValue(int durationValue) {
			this.durationValue = durationValue;
		}

		public Image getImage() {
			return image;
		}

		public void setImage(Image image) {
			this.image = image;
		}

	}
}
