/*
 * Created on 28-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.chord;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChordEditor extends Composite{
    public static final int STRING_SPAN = 30;
    public static final int FRET_SPAN = 30;    
    public static final short MIN_FRET = 1;        
    public static final short MAX_FRET = 24; 
    public static final short VIEWING_FRETS = 6;
    
    private boolean[] fisrtFrets;
    private int[] strings; 
    private int[] frets;
    private short fret;
    private short maxStrings;
    private int width;
    private int height;    
    private List points;
    
    public ChordEditor(Composite parent, int style) {
        super(parent, style);
        this.setMaxStrings((short)6);        
        this.setBackground(new Color(getDisplay(), 255, 255, 255));
        this.addPaintListener(new PaintListener() {
            public void paintControl(PaintEvent e) {
                paintEditor(e.gc);

            }
        });
        this.addMouseListener(new MouseListener() {
            public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                checkPoint(e.x,e.y);
                redraw();
            }
        });
                
        this.getVerticalBar().setMaximum(((MAX_FRET + MIN_FRET) - (VIEWING_FRETS - 1) + 1));
        this.getVerticalBar().setMinimum(MIN_FRET);
        this.getVerticalBar().setThumb(1);
        this.getVerticalBar().addListener(SWT.Selection, new Listener() {
            public void handleEvent(Event event) {
                setFret((short)getVerticalBar().getSelection(),false);
                redraw();
            }
        });        
    }
    
    public ChordEditor(Composite parent, int style,short maxStrings) {
        this(parent, style | SWT.V_SCROLL);
        this.init(maxStrings);
    }

    public void init(short maxStrings){
        this.fret = MIN_FRET;
        this.maxStrings = maxStrings;
        this.fisrtFrets = new boolean[this.maxStrings];
        this.strings = new int[this.maxStrings];
        this.frets = new int[VIEWING_FRETS];
        this.width = ((STRING_SPAN * this.maxStrings) - STRING_SPAN);
        this.height = ((FRET_SPAN * VIEWING_FRETS) - FRET_SPAN);
        this.points = new ArrayList();
        
        for(int i = 0;i < fisrtFrets.length;i++){
            this.fisrtFrets[i] = false;            
        }                
        for(int i = 0;i < strings.length;i++){
            this.strings[i] = ((i + 1) * STRING_SPAN);            
        }
        for(int i = 0;i < frets.length;i++){
            this.frets[i] = ((i + 1) * FRET_SPAN);
        }
                
    }
    
    private void paintEditor(GC gc){
        //dibujo el puente
        gc.drawLine((STRING_SPAN - 10),(FRET_SPAN - 10),STRING_SPAN + (this.width + 10),(FRET_SPAN - 10));
        
        gc.drawString(Integer.toString(getFret()),FRET_SPAN - 20,STRING_SPAN);
        
        //dibujo las cuerdas
        for(int i = 0;i < strings.length;i++){
            gc.drawLine(this.strings[i],FRET_SPAN,this.strings[i],FRET_SPAN + this.height);
        }
        //dibujo las cegillas
        for(int i = 0;i < frets.length;i++){
            gc.drawLine(STRING_SPAN,this.frets[i],STRING_SPAN + this.width,this.frets[i]);
        }       
                
        //dibujo las notas
        gc.setLineWidth(10);
        gc.setForeground(this.getDisplay().getSystemColor(SWT.COLOR_BLACK));                                       
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();                       

            gc.drawOval(point.x - 2,point.y + (FRET_SPAN / 2),5,5);           
        }
        gc.setLineWidth(1);

        //dibujo las notas al aire        
        for(int i = 0;i < fisrtFrets.length;i++){
            if(!hasPoints(i)){
                if(fisrtFrets[i]){
                    int x = this.strings[i] - 7;
                    int y = FRET_SPAN - 27;                    
                    gc.drawOval(x,y,14,14);   
                }else{
                    int x = this.strings[i];
                    int y = FRET_SPAN - 20;
                    gc.drawLine(x - 6,y + 6,x + 7,y - 7);
                    gc.drawLine(x - 6,y - 6,x + 7,y + 7);                    
                }
            }
        }        
    }


    

    
    
    
    private void checkPoint(int x,int y){        
        int stringIndex = getStringIndex(x);
        int fretIndex = getFretIndex(y);                
        
        if(y < FRET_SPAN){
            this.fisrtFrets[stringIndex] = !this.fisrtFrets[stringIndex];
            this.removePointsAtStringLine(this.strings[stringIndex]);
        }else if(y < (FRET_SPAN * VIEWING_FRETS)){                
            Point point = new Point(this.strings[stringIndex],this.frets[fretIndex]);
            if(!this.removePoint(point)){
                this.fisrtFrets[stringIndex] = false;
                this.removePointsAtStringLine(this.strings[stringIndex]);
                this.addPoint(point);
                this.orderPoints();
            }
        }
    }
    
    private boolean removePoint(Point point){
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point currPoint = (Point)it.next();
            if(currPoint.x == point.x && currPoint.y == point.y){
                this.points.remove(point);
                return true;
            }
        }  
        return false;
    }
    
    private void orderPoints(){
        for(int i = 0;i < this.points.size();i++){
            Point minPoint = null;
            for(int noteIdx = i;noteIdx < this.points.size();noteIdx++){
                Point point = (Point)this.points.get(noteIdx);
                if(minPoint == null || point.x < minPoint.x){
                    minPoint = point;
                }
            }
            this.points.remove(minPoint);
            this.points.add(i,minPoint);
        }
    }    
    
    private void removePointsAtStringLine(int x){
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();
            if(point.x == x){
                this.points.remove(point);
                break;
            }
        }  
    }     
    
    private void addPoint(Point point){
        this.points.add(point);
    }
    
    private int getStringIndex(int x){  
        int index = -1;          
        for(int i = 0;i < this.strings.length;i++){                    
            if(index < 0){
                index = i;
            }else{                    
                int distanceX = Math.abs(x - this.strings[index]);
                int currDistanceX = Math.abs(x - this.strings[i]);
                if(currDistanceX < distanceX){
                    index = i;
                }
            }
            
        }
        return index;
    }     
    
    private int getFretIndex(int y){
        int index = -1;
        for(int i = 0;i < this.frets.length;i++){                    
            if(index < 0){
                index = i;
            }else{                    
                int distanceX = Math.abs(y - (this.frets[index] + (FRET_SPAN / 2)));
                int currDistanceX = Math.abs(y - (this.frets[i] + (FRET_SPAN / 2)));
                if(currDistanceX < distanceX){
                    index = i;
                }
            }
            
        }
        return index;
    }  
    
    private boolean hasPoints(int stringIndex){                          
        Iterator it = this.points.iterator();
        while(it.hasNext()){
            Point point = (Point)it.next();                       
            if(point.x == this.strings[stringIndex]){
                return true;
            }
        }                        
        return false;
    }
    
    public boolean isEmpty(){
        return this.points.isEmpty();
    }

    
    
    public int getValue(int string){
        int value = -1;
        if(this.fisrtFrets[this.maxStrings - string]){
            value = 0;
        }
        
        if(value < 0){
            Iterator it = this.points.iterator();
            while(it.hasNext()){
                Point point = (Point)it.next();                                   
                if(string == (this.maxStrings - getStringIndex(point.x))){
                    value = (getFretIndex(point.y + (FRET_SPAN / 2)) + 1);
                    value += (getFret() - 1);
                }
            }               
        }
        
        return value;
    }
    
    public void addValue(int value,int string){
        if(string >= 1 && string <= this.maxStrings){
            this.fisrtFrets[this.maxStrings - string] = false;
            this.removePointsAtStringLine(this.strings[this.maxStrings - string]);        
            if(value == 0){
                this.fisrtFrets[this.maxStrings - string] = true;
            }else if(value >= 0){
                value -= (getFret() - 1);
                if(value > 0 && value <= VIEWING_FRETS){
                    this.addPoint(new Point(this.strings[this.maxStrings - string],this.frets[value - 1]));
                }
            }
        }
    }
    
    public short getFret() {
        return fret;
    }
    public void setFret(short fret) {
        setFret(fret,true);
    }

    private void setFret(short fret,boolean updateScroll){
        if(fret >= MIN_FRET && fret <= MAX_FRET){
            this.fret = fret;
        }        
        if(updateScroll){
            this.getVerticalBar().setSelection(this.fret);
        }
    }
    
    public short getMaxStrings() {
        return maxStrings;
    }
    public void setMaxStrings(short maxStrings) {
        this.maxStrings = maxStrings;
    }
    public int getWidth(){
        return this.width;        
    }
    
    public int getHeight(){
        return this.height;
    }
    
    
    
    

}
