/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.TrackColor;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTrackPropertiesAction extends Action {
    public static final String NAME = "CHANGE_TRACK_PROPERTIES";
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private Shell dialog;
    private Text nameText;
    private TrackColor trackColor;
    private List tempStrings;
    private TunningSpinner[] stringSpinners = new TunningSpinner[MAX_STRINGS];
    private Spinner stringCountSpinner;
    private int stringCount;
    private Combo instrumentCombo;
    private Button percusionCheckBox;
    
    public ChangeTrackPropertiesAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords trackCoords = getEditor().getTablature().getCaret().getSongTrackCoords();
        if (trackCoords != null) {
            this.stringCount = trackCoords.getTrack().getStrings().size();
            this.trackColor = (TrackColor)trackCoords.getTrack().getColor().clone();
            this.initTempStirngs(trackCoords.getTrack().getStrings());

            this.dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
            this.dialog.setLayout(new RowLayout(SWT.VERTICAL));            
            this.dialog.setText(TuxGuitar.getProperty("track.properties"));

            final TabFolder tabFolder = new TabFolder(dialog, SWT.NONE);
            tabFolder.setLayout(new RowLayout(SWT.VERTICAL));
            tabFolder.setLayoutData(new RowData(420,150));
            
            Composite control = null;
            TabItem tabItem = null;
            //GENERAL
            control = new Composite(tabFolder,SWT.NONE);
            control.setLayout(new GridLayout(2,true));            
            initTrackInfo(control,trackCoords);            
            tabItem = new TabItem(tabFolder, SWT.NONE);
            tabItem.setText(TuxGuitar.getProperty("track.properties.general"));
            tabItem.setControl(control);
            
            //TUNNING
           
            control = new Composite(tabFolder,SWT.NONE);
            control.setLayout(new RowLayout(SWT.VERTICAL));               
            Composite stringNumberComposite = new Composite(control,SWT.NONE);
            stringNumberComposite.setLayout(new GridLayout(2,true));
            initStringSpinner(stringNumberComposite);            
            Composite tunningComposite = new Composite(control,SWT.NONE);
            tunningComposite.setLayout(new RowLayout(SWT.HORIZONTAL));
            initTunningSpinners(tunningComposite);                
            tabItem = new TabItem(tabFolder, SWT.NONE);
            tabItem.setText(TuxGuitar.getProperty("tunning"));
            tabItem.setControl(control);

            
            //INSTRUMENT
            control = new Composite(tabFolder,SWT.NONE);
            control.setLayout(new GridLayout(2,true));            
            initInstrumentFields(control,trackCoords);
            tabItem = new TabItem(tabFolder, SWT.NONE);
            tabItem.setText(TuxGuitar.getProperty("instrument.instrument"));
            tabItem.setControl(control);
            
            //BUTTONS
            initButtons(dialog);

            
            tabFolder.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    e.doit = false;
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }

    
    private void initTrackInfo(Composite parent,SongTrackCoords trackCoords){
        Label nameLabel = new Label(parent,SWT.NONE);
        nameLabel.setLayoutData(new GridData(100,15));
        nameLabel.setText(TuxGuitar.getProperty("track.name"));        
        
        this.nameText = new Text(parent,SWT.BORDER);
        nameText.setLayoutData(new GridData(100,15));
        nameText.setText(trackCoords.getTrack().getName());

        Label colorLabel = new Label(parent,SWT.NONE);
        colorLabel.setText(TuxGuitar.getProperty("track.color")); 
        
        final Button colorButton = new Button(parent, SWT.PUSH);             
        setButtonColor(colorButton,new Color(dialog.getDisplay(),this.trackColor.getR(),this.trackColor.getG(),this.trackColor.getB()));
        
        colorButton.addSelectionListener(new SelectionAdapter() {
          public void widgetSelected(SelectionEvent event) {
            ColorDialog dlg = new ColorDialog(dialog);

            dlg.setRGB(dialog.getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
            dlg.setText(TuxGuitar.getProperty("choose-color"));
            RGB rgb = dlg.open();
            if (rgb != null) {
                setButtonColor(colorButton,new Color(dialog.getDisplay(),rgb));
            }
          }
        });

        
    }

    private void setButtonColor(Button button,Color color){
        final Image image = new Image(dialog.getDisplay(),25,25);
        final GC gc = new GC(image);
        gc.setBackground(color);
        gc.fillRectangle(0,0,25,25);
        button.setImage(image);
        gc.dispose();
        image.dispose();
        this.trackColor.setR(color.getRed());
        this.trackColor.setG(color.getGreen());
        this.trackColor.setB(color.getBlue());
    }
    
    private void initTunningSpinners(Composite parent){
        Composite tunningComposite = new Composite(parent,SWT.NONE);
        tunningComposite.setLayout(new GridLayout(MAX_STRINGS,false));
        String[] tunningTexts = getAllValueNames();
        for (int i = 0; i < MAX_STRINGS; i++) {
            this.stringSpinners[i] = new TunningSpinner(tunningComposite, SWT.NONE);
            this.stringSpinners[i].setTexts(tunningTexts);
        }
        updateTunningSpinner();     
    }
    
    
    private void initStringSpinner(final Composite parent){
        Label stringCountLabel = new Label(parent, SWT.NONE);
        stringCountLabel.setText(TuxGuitar.getProperty("tunning.strings"));
        
        this.stringCountSpinner = new Spinner(parent, SWT.BORDER);        
        GridData data = new GridData();
        data.widthHint = 30;
        stringCountSpinner.setLayoutData(data);
        //stringCountSpinner.setLayoutData(new GridData(30,15));
        
        stringCountSpinner.setMinimum(MIN_STRINGS);
        stringCountSpinner.setMaximum(MAX_STRINGS);
        stringCountSpinner.setSelection(this.stringCount);
        stringCountSpinner.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {                    
                stringCount = stringCountSpinner.getSelection();
                setDefaultTunning();
                updateTunningSpinner();
            }
        });                 
        
    }
    private void initButtons(final Composite parent){
        Composite composite = new Composite(parent,SWT.NONE);
        composite.setLayout(new FormLayout());

        Composite buttonComposite = new Composite(composite,SWT.NONE);
        buttonComposite.setLayout(new GridLayout(2,false));
        FormData data = new FormData();
        data.top = new FormAttachment(0,0);
        data.left = new FormAttachment(50, 0);
        data.bottom = new FormAttachment(100,0);
        data.right = new FormAttachment(100,0);
        buttonComposite.setLayoutData(data);       
        
        final Button buttonOK = new Button(buttonComposite, SWT.PUSH);
 
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData(new GridData(99,28));
        buttonOK.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                updateTrackProperties();
                
                //--------------update and redraw------------------------------------------------------        
                new SyncThread(getEditor(), new Runnable() {
                    public void run() {
                        updateTablature();
                        getEditor().getTablature().getCaret().update(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure());  
                        redraw();    
                        dialog.dispose();
                    }
                }).start();    
            }
        });
        
        Button buttonCancel = new Button(buttonComposite, SWT.PUSH); 
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData(new GridData(99,28));
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {                    
                dialog.dispose();
            }
        });

    }

    private void initInstrumentFields(Composite parent,SongTrackCoords trackCoords){
        Instrument[] instruments = getInstruments();
        
        SongTrack track = trackCoords.getTrack();
        //------------Instrument Combo-------------------------------------
        Label instrumentLabel = new Label(parent, SWT.NULL);
        instrumentLabel.setText(TuxGuitar.getProperty("instrument.instrument"));
        this.instrumentCombo = new Combo(parent, SWT.NULL);
        if(instruments != null){
            int count = instruments.length;
            if(count > 128){
                count = 128;
            }
            for (int i = 0; i < count; i++) {
                instruments[i].getName();
                instrumentCombo.add(instruments[i].getName());
            }               
            instrumentCombo.setText(instruments[track.getInstrument()].getName()); 
            instrumentCombo.setEnabled(!track.isPercusionTrack());
        }else{
            instrumentCombo.setEnabled(false);
        }        

        //--------------------Precusion CheckBox-------------------------------
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;           
        this.percusionCheckBox = new Button(parent, SWT.CHECK);
        percusionCheckBox.setText(TuxGuitar.getProperty("instrument.percusion-track"));
        percusionCheckBox.setLayoutData(gridData);
        if(instruments != null){
            percusionCheckBox.setSelection(track.isPercusionTrack());
            percusionCheckBox.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    instrumentCombo.setEnabled(!percusionCheckBox.getSelection());
                }
            });
        }else{
            percusionCheckBox.setEnabled(false);
        }
        //-----------------------------------------------------------            
    }

	private Instrument[] getInstruments() {
	    Instrument[] instruments = null;
	    Soundbank sb = getEditor().getSongManager().getPlayer().getDefaultSoundbank();	        
		if (sb != null) {
		    instruments = sb.getInstruments();
		}
		return instruments;
	}        
    
    private void updateTrackProperties(){
        SongTrackCoords trackCoords = getEditor().getTablature().getCaret().getSongTrackCoords();
        //--------------------------------------info---------------------------------------
        trackCoords.changeInfo(this.nameText.getText(),this.trackColor);
        
        //-----------------------------instrument----------------------------------------------
        trackCoords.changeInstrument(instrumentCombo.getSelectionIndex(),percusionCheckBox.getSelection());        
        //--------------------------------------tunning---------------------------------------
       
        int stringNumber = 1;
        List strings = new ArrayList();
        for (int i = stringCount -1; i >= 0; i--) {
            strings.add(new InstrumentString(stringNumber,stringSpinners[i].getSelection()));
            stringNumber++;
        }         
        trackCoords.changeInstrumentStrings(strings);

    
        
    }
   
    
    private void updateTunningSpinner() {
        int spinnerIndex = tempStrings.size() - 1 ;
        Iterator it = tempStrings.iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();
            stringSpinners[spinnerIndex].setSelection(string.getValue());
            stringSpinners[spinnerIndex].setVisible(true);
            spinnerIndex --;           
        }
        for (int i = tempStrings.size(); i < MAX_STRINGS; i++) {
            stringSpinners[i].setSelection(0);
            stringSpinners[i].setVisible(false);
        }
    }

    private void initTempStirngs(List realStrings) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < realStrings.size(); i++) {
            InstrumentString realString = (InstrumentString) realStrings.get(i);
            tempStrings.add(realString.clone());
        }
    }

    
    
    private void setDefaultTunning() {
        this.tempStrings.clear();

        switch (stringCount) {
        case 7:
            this.tempStrings.add(new InstrumentString(1, 64));
            this.tempStrings.add(new InstrumentString(2, 59));
            this.tempStrings.add(new InstrumentString(3, 55));
            this.tempStrings.add(new InstrumentString(4, 50));
            this.tempStrings.add(new InstrumentString(5, 45));
            this.tempStrings.add(new InstrumentString(6, 40));
            this.tempStrings.add(new InstrumentString(7, 35));
            break;
        case 6:
            this.tempStrings.add(new InstrumentString(1, 64));
            this.tempStrings.add(new InstrumentString(2, 59));
            this.tempStrings.add(new InstrumentString(3, 55));
            this.tempStrings.add(new InstrumentString(4, 50));
            this.tempStrings.add(new InstrumentString(5, 45));
            this.tempStrings.add(new InstrumentString(6, 40));
            break;
        case 5:
            this.tempStrings.add(new InstrumentString(1, 43));
            this.tempStrings.add(new InstrumentString(2, 38));
            this.tempStrings.add(new InstrumentString(3, 33));
            this.tempStrings.add(new InstrumentString(4, 28));
            this.tempStrings.add(new InstrumentString(5, 23));
            break;
        case 4:
            this.tempStrings.add(new InstrumentString(1, 43));
            this.tempStrings.add(new InstrumentString(2, 38));
            this.tempStrings.add(new InstrumentString(3, 33));
            this.tempStrings.add(new InstrumentString(4, 28));
            break;
        }

    }

    
    
    private String[] getAllValueNames(){
        String[] valueNames = new String[MAX_NOTES * MAX_OCTAVES];
        for(int i = 0;i < valueNames.length;i++){
            valueNames[i] = getValueName(i);
        }
        
        return valueNames;
    }
    
    private String getValueName(int value){
        String name = null;        
        int octave = (value / MAX_NOTES);
        value = value - (octave * MAX_NOTES);        
        switch(value){
        	case 0:
        	    name = "C";
        	    break;
        	case 1:
        	    name = "C#";
        	    break;        
        	case 2:
        	    name = "D";
        	    break;
        	case 3:
        	    name = "D#";
        	    break;
        	case 4:
        	    name = "E";
        	    break;
        	case 5:
        	    name = "F";
        	    break;
        	case 6:
        	    name = "F#";
        	    break;
        	case 7:
        	    name = "G";
        	    break;
        	case 8:
        	    name = "G#";
        	    break;
        	case 9:
        	    name = "A";
        	    break;
        	case 10:
        	    name = "Bb";
        	    break;     	    
        	case 11:
        	    name = "B";
        	    break;            
        }        
        return name + octave;
    }
    
    
    private class TunningSpinner extends Composite{
        private Text text;
        private Composite buttonComposite;
        private Button upButton;
        private Button downButton;
        private String[] texts;
        private int maxSelection;
        private int minSelection;
        private int selection;
        
        public TunningSpinner(Composite parent, int style) {
            super(parent, style);            
            this.setLayout(createLayout(2));
            this.init();
        }
        
        
        private void init(){
            this.text = new Text(this,SWT.BORDER);     
            this.text.setLayoutData(new GridData(30,22));            
            this.buttonComposite = new Composite(this,SWT.NONE);
            this.buttonComposite.setLayout(createLayout(1));
            this.upButton = new Button(buttonComposite,SWT.ARROW | SWT.UP);
            this.upButton.setLayoutData(new GridData(15,15));
            this.downButton = new Button(buttonComposite,SWT.ARROW | SWT.DOWN);
            this.downButton.setLayoutData(new GridData(15,15));                        
            this.selection = 0;
            this.minSelection = 0;
            this.maxSelection = 0;
            
            this.text.setEditable(false);
            
            this.upButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    setSelection(selection + 1);
                }
            });
            
            this.downButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    setSelection(selection - 1);
                }
            });                      
        }
        
        private Layout createLayout(int numColumns){
            GridLayout layout = new GridLayout(numColumns,false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;     
            return layout;
        }
        
        public void setTexts(String[] texts){
            this.texts = texts;
            this.minSelection = 0;
            this.maxSelection = texts.length - 1;
        }        

        public int getSelection() {
            return selection;
        }
        
        public void setSelection(int selection) {
            if(selection >= minSelection && selection <= maxSelection){            
                this.selection = selection;
            	if(texts != null){
                	this.text.setText(texts[selection]);
            	}            
            }
        }
    }
        
}