/*
 * Created on 25-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.items.ItemContainerManager;
import org.herac.tuxguitar.gui.language.LanguageManager;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TuxGuitar {
	private static TuxGuitar instance;

	private String basePath;

	private Display display;

	private Shell shell;

	private SongManager songManager;

	private LanguageManager languageManager;

	private Composite sashComposite;
	
	private TablatureEditor tablatureEditor;

	private SongMixerViewer mixer;
	
	private FretBoardEditor fretBoardEditor;
	
	private ActionContainer actionContainer;

	private ItemContainerManager itemContainerManager;

	public static void main(String[] args) {
		TuxGuitar.instance().displayGUI();
	}

	public TuxGuitar() {
		this.basePath = new File("").getAbsolutePath() + File.separator;
	}

	public static TuxGuitar instance() {
		if (instance == null) {
			synchronized (TuxGuitar.class) {
				instance = new TuxGuitar();
			}
		}

		return instance;
	}

	private void initLanguage() {
		this.languageManager = new LanguageManager();
		this.languageManager.setLanguage("en");
	}

	public void displayGUI() {
		this.initLanguage();
		this.display = new Display();

		Shell splashShell = getSplashShell(display);
		splashShell.open();

		this.shell = new Shell(display);		
		this.shell.setLayout(new FormLayout());
		
		this.shell.setText(getProperty("tuxguitar.title"));
		this.shell.setImage(new Image(display, TuxGuitar.getResourcePath(this, "icon.png")));

		this.songManager = new SongManager();
		this.tablatureEditor = new TablatureEditor(this.songManager);
		this.mixer = new SongMixerViewer(this.tablatureEditor);
		this.fretBoardEditor = new FretBoardEditor(this.tablatureEditor);
		
		
		this.initActions();
		this.initItems();

		this.createComposites(shell);
				
		//this.shell.setMaximized(true);
		this.shell.setMinimumSize(640,480);				
		this.shell.open();
		this.setDefaults();
		
		splashShell.close();
		splashShell.dispose();
		
		this.itemContainerManager.updateItems();

		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		songManager.getPlayer().close();
		display.dispose();
		System.exit(0);
	}

	private Shell getSplashShell(Display display) {
		Shell shell = new Shell(display, SWT.NO_TRIM | SWT.NO_BACKGROUND);
		final Image image = new Image(display, TuxGuitar.getResourcePath(this, "splash.png"));
		int width = image.getBounds().width;
		int height = image.getBounds().height;
		int x = ((display.getBounds().width - display.getBounds().x) / 2) - (width / 2);
		int y = ((display.getBounds().height - display.getBounds().y) / 2) - (height / 2);
		shell.setBounds(x, y, width, height);
		shell.setImage(new Image(display, TuxGuitar.getResourcePath(this, "icon.png")));
		shell.setText(getProperty("tuxguitar.title"));
		shell.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				e.gc.drawImage(image, 0, 0);
			}
		});
		return shell;
	}


	public void createComposites(Composite composite) {
		sashComposite = new Composite(composite,SWT.NONE);
		sashComposite.setLayout(new FormLayout());
		FormData data = new FormData();
		data.left = new FormAttachment(0, 0); 
		data.right = new FormAttachment(100, 0); 
		data.top = new FormAttachment(0, 40);
		data.bottom = new FormAttachment(100,0);
		sashComposite.setLayoutData(data);
				
		final Sash sash = new Sash(sashComposite, SWT.HORIZONTAL | SWT.SEPARATOR);
	    data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(75,0);		
		sash.setLayoutData(data);
	    
	    this.tablatureEditor.showTablature(sashComposite); 
	    data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0,0);
		data.bottom = new FormAttachment(sash, 0);
		this.tablatureEditor.getTablature().setLayoutData(data);	    
	    
	    
	    this.mixer.showMixer(sashComposite);
	    data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(sash,10);
		data.bottom = new FormAttachment(100,00);
		this.mixer.getMixer().setLayoutData(data);		  
	    
	    
	    sash.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent event) {
	            
	            int height = sashComposite.getBounds().height;
	            int sashNumerator = (event.y * 100 / height);
	            ((FormData) sash.getLayoutData()).top = new FormAttachment(sashNumerator,0);
		        //sash.getParent().layout();
	        }
	      });
	    sash.addMouseListener(new MouseAdapter() {
            public void mouseUp(MouseEvent e) {
                sash.getParent().layout();
            }
        });
	    
	    this.fretBoardEditor.showFretBoard(composite);
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(sashComposite,0);
		data.bottom = new FormAttachment(100,0);
		this.fretBoardEditor.getFretBoard().setLayoutData(data);

		//((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 20;				
		
	}
	
	public void setDefaults(){
	    showFretBoard();
	}
	
	
	public void showFretBoard(){
	    /*
	    FormData data = ((FormData)this.sashComposite.getLayoutData());
        int sashNumerator = 100 - (this.fretBoardEditor.getFretBoard().getHeight() * data.bottom.numerator / height);
	    if(sashNumerator < 0){
	        sashNumerator = 0;
	    }
		this.fretBoardEditor.getFretBoard().setVisible(true);
		data.bottom.numerator = sashNumerator;
		
		shell.setMinimumSize(730,520);
		shell.layout();
		*/
		this.fretBoardEditor.getFretBoard().setVisible(true);
		this.updateSashNumerator();
		this.shell.layout();
	}
	
	public void hideFretBoard(){
		this.fretBoardEditor.getFretBoard().setVisible(false);
		((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 100;
		shell.setMinimumSize(640,480);
		
		this.fretBoardEditor.getFretBoard().setVisible(false);
		this.updateSashNumerator();
		this.shell.layout();
	}
	
	public void updateSashNumerator(){
	    FormData data = ((FormData)this.sashComposite.getLayoutData());
	    if(this.fretBoardEditor.getFretBoard().isVisible()){	    
	        int sashNumerator = 100 - (this.fretBoardEditor.getFretBoard().getHeight() * 100 / (this.shell.getBounds().height - 40));       
	        if(sashNumerator < 0){
	            sashNumerator = 0;
	        }
	        data.bottom.numerator = sashNumerator;
	        shell.setMinimumSize(730,520);
	    }else{
			((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 100;
			shell.setMinimumSize(640,480);
	    }
	}
	
	public FretBoardEditor getFretBoardEditor(){
		return this.fretBoardEditor;
	}
	
	private void initItems() {
		this.itemContainerManager = new ItemContainerManager(this.tablatureEditor);
		this.itemContainerManager.createMenu(this.shell);
		this.itemContainerManager.createToolbar(this.shell);
	}

	private void initActions() {
		this.actionContainer = new ActionContainer(this.tablatureEditor);
		this.actionContainer.initActions();
	}

	public void redraw(){
		this.tablatureEditor.getTablature().redraw();
		this.fretBoardEditor.getFretBoard().redraw();
		this.mixer.getMixer().redraw();
	}
	
	public void loadProperties(){
	    this.itemContainerManager.loadProperties();         
	    this.mixer.getMixer().loadProperties();
	    this.fretBoardEditor.getFretBoard().loadProperties();
	}
	
	public Action getAction(String name) {
		return this.actionContainer.getAction(name);
	}

	public ItemContainerManager getItemContainerManager() {
		return itemContainerManager;
	}

	public ActionContainer getActionContainer() {
		return this.actionContainer;
	}

	public LanguageManager getLanguageManager() {
		return this.languageManager;
	}

	public static String getProperty(String key) {
		return TuxGuitar.instance().languageManager.getProperty(key);
	}

	public static String getResourcePath(Object o, String file) {
		return TuxGuitar.instance().basePath + "files" + File.separator + file;
	}

	public String getBasePath() {
		return this.basePath;
	}
	
	


}