/*
 * Created on 30-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.actions.caret.GoDownAction;
import org.herac.tuxguitar.gui.actions.caret.GoLeftAction;
import org.herac.tuxguitar.gui.actions.caret.GoRightAction;
import org.herac.tuxguitar.gui.actions.caret.GoUpAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeTupletoDurationAction;
import org.herac.tuxguitar.gui.actions.duration.DecrementDurationAction;
import org.herac.tuxguitar.gui.actions.duration.IncrementDurationAction;
import org.herac.tuxguitar.gui.actions.mouse.SelectComponentAction;
import org.herac.tuxguitar.gui.actions.note.ChangeNoteAction;
import org.herac.tuxguitar.gui.actions.note.InsertNoteAction;
import org.herac.tuxguitar.gui.actions.note.RemoveNoteAction;
import org.herac.tuxguitar.gui.clipboard.ClipBoard;
import org.herac.tuxguitar.gui.helper.MemoryHelper;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.undo.UndoManager;
import org.herac.tuxguitar.gui.undo.UndoableCreator;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TablatureEditor {
    private SongManager songManager;
    private Tablature tablature;  
    private UndoManager undoManager;
    private UndoableCreator undoableCreator;
    private ClipBoard clipBoard;
    private MemoryHelper memory;
    
    public TablatureEditor(SongManager songManager) {
        this.songManager = songManager;        
        this.undoManager = new UndoManager();
        this.undoableCreator = new UndoableCreator(this,this.undoManager);
        this.clipBoard = new ClipBoard();
        this.memory = new MemoryHelper();
    }

    public void showTablature(Composite parent) {
        this.tablature = new Tablature(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);        
        this.tablature.setSongManager(this.songManager);
        this.tablature.init();
        this.tablature.updateTablature();
        this.tablature.initCaret();
        
        this.initMouseActions();
        this.initKeyActions();
    }

    private void initMouseActions(){
        this.tablature.addMouseListener(TuxGuitar.instance().getAction(SelectComponentAction.NAME));
    }
    
    private void initKeyActions(){
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(ChangeNoteAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(GoDownAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(GoUpAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(GoRightAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(GoLeftAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(InsertNoteAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(RemoveNoteAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(IncrementDurationAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(DecrementDurationAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(ChangeDottedDurationAction.NAME));
        this.tablature.addKeyListener(TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
    }
    
    
    public void resetDefaults(){        
        getSongManager().getPlayer().reset();
        getTablature().resetScroll();
        getTablature().updateTablature();
        getTablature().initCaret();
    }
    /*
    public void showFretBoard() {
        Caret caret = getTablature().getCaret();
        final SongTrackCoords trackCoords = caret.getSongTrackCoords();
        final MeasureCoords measureCoords = caret.getMeasureCoords();
        final MeasureComponent component = caret.getSelectedComponent();
        if (trackCoords != null && measureCoords != null && component != null) {
            final Shell dialog = new Shell(getTablature().getShell(), SWT.DIALOG_TRIM);
            GridLayout layout = new GridLayout(1, false);
            dialog.setLayout(layout);
            dialog.setText(TuxGuitar.getProperty("fretboard.editor"));

            this.fretBoard = new FretBoard(dialog,this);
            
            dialog.pack();
            int x = ((dialog.getDisplay().getBounds().width - dialog.getBounds().width) / 2);
            int y = (dialog.getDisplay().getBounds().height - dialog.getBounds().height);                     
            dialog.setLocation(x, y);
            dialog.open();
            
            dialog.addDisposeListener(new DisposeListener() {
				public void widgetDisposed(DisposeEvent arg0) {
					fretBoard = null;
				}
			});
        }

    }

    public void disposeFretBoard(){
    	if(this.fretBoard != null){
    		this.fretBoard.getShell().dispose();
    	}
    }
    
    public void redraw(){
    	if(this.fretBoard != null){
    		this.fretBoard.redraw();
    	}
    	if(this.tablature != null){
    		this.tablature.redraw();
    	}
    	
    }*/
    
    public Tablature getTablature() {
        return this.tablature;
    }
    
    public SongManager getSongManager(){
        return this.songManager;
    }
    /*
    public FretBoard getFretBoardEditor() {
        return this.fretBoard;
    }
    */
    public UndoManager getUndoManager(){
        return this.undoManager;
    }
    
    public UndoableCreator getUndoableCreator(){
        return this.undoableCreator;
    }
    
    public ClipBoard getClipBoard(){
        return this.clipBoard;
    }
        
    
    public void notifyMemoryHelper(String fileName){
        this.memory.notifyOperation(fileName);
    }    
    
    
    public MemoryHelper getMemoryHelper(){
        return this.memory;
    }
    

}