/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.herac.tuxguitar.io.gp.GP3OutputStream;
import org.herac.tuxguitar.io.gp.GP4OutputStream;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.song.models.Song;

public class SongWriter {
    private static final String TG_EXTENSION = ".TG";
    private static final String GP3_EXTENSION = ".GP3";
    private static final String GP4_EXTENSION = ".GP4";
    private String fileName;

    public SongWriter(String string) {
        this.fileName = string;
    }

    public void write(Song song) throws GPFormatException, IOException {
        if (this.hasExtension(TG_EXTENSION)) {
            this.writeTGFile(song);
        } else if (this.hasExtension(GP3_EXTENSION)) {
            this.writeGP3File(song);
        } else if (this.hasExtension(GP4_EXTENSION)) {
            this.writeGP4File(song);
        }
    }

    private boolean hasExtension(String string) {
        return this.fileName.toUpperCase().endsWith(string);
    }

    private void writeTGFile(Song song) throws FileNotFoundException {
        new TGOutputStream(this.fileName).write(song);
    }

    private void writeGP3File(Song song) throws FileNotFoundException, IOException {
        new GP3OutputStream(new FileOutputStream(this.fileName)).writeSong(song);
    }

    private void writeGP4File(Song song) throws FileNotFoundException, IOException {
        new GP4OutputStream(new FileOutputStream(this.fileName)).writeSong(song);
    }
}

