/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.QuarterSpanHelper;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;

public class SongTrackCoords {
    public static final int DEFAULT_HORIZONTAL_SPAN = 20;
    public static final int DEFAULT_STRING_SPAN = 12;
    private Tablature tablature;
    private SongManager songManager;
    private SongTrack track;
    private List measuresCoords;
    private int posX;
    private int posY;
    private int width;
    private int height;

    public SongTrackCoords(Tablature tablature, SongManager songManager, SongTrack songTrack) {
        this.tablature = tablature;
        this.track = songTrack;
        this.songManager = songManager;
        this.measuresCoords = new ArrayList();
        this.posX = 20;
    }

    public void createMeasures() {
        this.measuresCoords.clear();
        for (int i = 0; i < this.track.getMeasures().size(); ++i) {
            Measure measure = (Measure)this.track.getMeasures().get(i);
            MeasureCoords measureCoords = new MeasureCoords(i, this.songManager, this.tablature, measure, this);
            measureCoords.create();
            this.measuresCoords.add(measureCoords);
            if (this.tablature.getViewLayout().getQuarterSpans().size() > i) {
                this.tablature.getViewLayout().getQuarterSpan(i).setQuarterSpan(measureCoords.getQuarterSpan());
                continue;
            }
            this.tablature.getViewLayout().addQuarterSpan(new QuarterSpanHelper(measureCoords.getQuarterSpan()));
        }
    }

    public void updateMeasures() {
        this.width = 0;
        int n = 0;
        for (int i = 0; i < this.getMeasuresCoords().size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)this.getMeasuresCoords().get(i);
            measureCoords.setQuarterSpan(this.tablature.getViewLayout().getQuarterSpan(i).getQuarterSpan());
            measureCoords.setPosX(this.width);
            measureCoords.setPosY(0);
            measureCoords.update();
            this.width += measureCoords.getWidth();
            if (measureCoords.getHeight() <= n) continue;
            n = measureCoords.getHeight();
        }
        this.height = n;
    }

    public void fireChanges(int n, QuarterSpanHelper quarterSpanHelper, boolean bl) {
        MeasureCoords measureCoords = null;
        if (bl) {
            Measure measure = (Measure)this.track.getMeasures().get(n);
            measureCoords = new MeasureCoords(n, this.songManager, this.tablature, measure, this);
            this.getMeasuresCoords().add(measureCoords);
        } else {
            measureCoords = (MeasureCoords)this.getMeasuresCoords().get(n);
        }
        measureCoords.create();
        quarterSpanHelper.setQuarterSpan(measureCoords.getQuarterSpan());
    }

    public void fireUpdate(int n, QuarterSpanHelper quarterSpanHelper) {
        MeasureCoords measureCoords = (MeasureCoords)this.getMeasuresCoords().get(n);
        measureCoords.setQuarterSpan(this.tablature.getViewLayout().getQuarterSpan(quarterSpanHelper, measureCoords));
        int n2 = measureCoords.getWidth();
        this.width -= n2;
        measureCoords.update();
        this.width += measureCoords.getWidth();
    }

    private void checkPosX(int n) {
        this.posX = 20;
        if (n <= -this.posX) {
            this.posX = 0;
        }
    }

    public void paintTrack(GC gC, int n, int n2, Rectangle rectangle) {
        this.checkPosX(n);
        this.tablature.getViewLayout().paintMeasures(this, this.measuresCoords, gC, n, n2, rectangle);
        this.tablature.getViewLayout().paintStrings(this, gC, n2, rectangle);
    }

    private void paintMeasures(GC gC, int n, int n2, Rectangle rectangle) {
        this.posY = n2;
        int n3 = this.posX;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)this.measuresCoords.get(i);
            measureCoords.setPosX(n3);
            measureCoords.setPosY(0);
            if (n3 + n > rectangle.x - 1500 && n3 + n < rectangle.x + rectangle.width + 100) {
                measureCoords.paintMeasure(gC, n3 + n, this.posY, rectangle);
            }
            n3 += measureCoords.getWidth();
        }
    }

    private void paintStrings(GC gC, int n, Rectangle rectangle) {
        int n2 = this.posX + rectangle.x;
        Iterator iterator = this.getTrack().getStrings().iterator();
        while (iterator.hasNext()) {
            InstrumentString instrumentString = (InstrumentString)iterator.next();
            int n3 = instrumentString.getNumber() * 12;
            gC.drawLine(n2, n + n3, n2 + rectangle.width, n + n3);
        }
    }

    public List getMeasuresCoords() {
        return this.measuresCoords;
    }

    public SongTrack getTrack() {
        return this.track;
    }

    public MeasureCoords getFirstMeasure() {
        MeasureCoords measureCoords = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords2 = (MeasureCoords)this.measuresCoords.get(i);
            if (measureCoords != null && measureCoords2.getMeasure().getStart() >= measureCoords.getMeasure().getStart()) continue;
            measureCoords = measureCoords2;
        }
        return measureCoords;
    }

    public MeasureCoords getLastMeasure() {
        int n = this.measuresCoords.size() - 1;
        return (MeasureCoords)this.measuresCoords.get(n);
    }

    public MeasureCoords getPrevMeasure(MeasureCoords measureCoords) {
        int n = measureCoords.getMeasureId() - 1;
        if (n >= 0) {
            return (MeasureCoords)this.measuresCoords.get(n);
        }
        return null;
    }

    public MeasureCoords getNextMeasure(MeasureCoords measureCoords) {
        int n = measureCoords.getMeasureId() + 1;
        if (n < this.measuresCoords.size()) {
            return (MeasureCoords)this.measuresCoords.get(n);
        }
        return null;
    }

    public MeasureCoords getMeasure(long l) {
        Object var3_2 = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)this.measuresCoords.get(i);
            long l2 = measureCoords.getMeasure().getStart();
            long l3 = measureCoords.getMeasure().getLength();
            if (l < l2 || l >= l2 + l3) continue;
            return measureCoords;
        }
        return null;
    }

    public MeasureCoords getMeasure(Measure measure) {
        MeasureCoords measureCoords = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords2 = (MeasureCoords)this.measuresCoords.get(i);
            if (!measureCoords2.getMeasure().equals(measure)) continue;
            measureCoords = measureCoords2;
            break;
        }
        return measureCoords;
    }

    public List getMeasuresBeforeEnd(long l) {
        ArrayList<MeasureCoords> arrayList = new ArrayList<MeasureCoords>();
        Iterator iterator = this.measuresCoords.iterator();
        while (iterator.hasNext()) {
            MeasureCoords measureCoords = (MeasureCoords)iterator.next();
            if (measureCoords.getMeasure().getStart() < l) continue;
            arrayList.add(measureCoords);
        }
        return arrayList;
    }

    public List getMeasuresBetween(long l, long l2) {
        ArrayList<MeasureCoords> arrayList = new ArrayList<MeasureCoords>();
        Iterator iterator = this.measuresCoords.iterator();
        while (iterator.hasNext()) {
            MeasureCoords measureCoords = (MeasureCoords)iterator.next();
            long l3 = measureCoords.getMeasure().getStart();
            if (l3 < l || l3 > l2) continue;
            arrayList.add(measureCoords);
        }
        return arrayList;
    }

    public MeasureCoords getMeasureAt(int n, int n2, int n3, int n4) {
        MeasureCoords measureCoords = null;
        long l = this.posX + n3;
        Iterator iterator = this.measuresCoords.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            MeasureCoords measureCoords2 = (MeasureCoords)iterator.next();
            boolean bl2 = (long)n >= l + (long)measureCoords2.getPosX() && (long)n <= l + (long)measureCoords2.getPosX() + (long)measureCoords2.getWidth() + (long)measureCoords2.getSpan();
            boolean bl3 = bl = n2 + 12 >= measureCoords2.getPosY() && n2 - 12 <= measureCoords2.getPosY() + measureCoords2.getHeight();
            if (!bl2 || !bl) continue;
            measureCoords = measureCoords2;
            break;
        }
        return measureCoords;
    }

    public void addNewMeasureBeforeEnd() {
        this.addNewMeasureAfter(this.getLastMeasure().getMeasure());
    }

    public void addNewMeasureAfter(Measure measure) {
        TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
        Tempo tempo = (Tempo)measure.getTempo().clone();
        long l = measure.getStart() + measure.getLength();
        boolean bl = false;
        int n = 0;
        this.addMeasure(new Measure(l, new ArrayList(), new ArrayList(), timeSignature, tempo, bl, n));
    }

    public List copyMeasures(long l, long l2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.getMeasuresBetween(l, l2).iterator();
        while (iterator.hasNext()) {
            MeasureCoords measureCoords = (MeasureCoords)iterator.next();
            arrayList.add(measureCoords.getMeasure().clone());
        }
        return arrayList;
    }

    public void insertMeasures(List list, int n) {
        long l = -1L;
        long l2 = 0L;
        Iterator iterator = null;
        if (!list.isEmpty()) {
            Object object;
            l = ((Measure)list.get(0)).getStart();
            l2 = ((Measure)list.get(list.size() - 1)).getStart() + ((Measure)list.get(list.size() - 1)).getLength();
            iterator = this.getMeasuresBeforeEnd(l).iterator();
            while (iterator.hasNext()) {
                object = (MeasureCoords)iterator.next();
                this.moveMeasure((MeasureCoords)object, l2 - l);
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (Measure)iterator.next();
                this.addMeasure(n, (Measure)object);
                ++n;
            }
        }
    }

    public void addMeasure(Measure measure) {
        this.track.getMeasures().add(measure);
    }

    public void addMeasure(int n, Measure measure) {
        this.track.getMeasures().add(n, measure);
    }

    public void removeMeasure(long l) {
        this.removeMeasure(this.getMeasure(l));
    }

    public void removeMeasure(MeasureCoords measureCoords) {
        long l = measureCoords.getMeasure().getStart();
        long l2 = measureCoords.getMeasure().getLength();
        List list = this.getMeasuresBeforeEnd(l + 1L);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MeasureCoords measureCoords2 = (MeasureCoords)iterator.next();
            this.moveMeasure(measureCoords2, -l2);
        }
        this.track.getMeasures().remove(measureCoords.getMeasure());
    }

    public void moveMeasure(MeasureCoords measureCoords, long l) {
        measureCoords.moveAllComponents(l);
        measureCoords.getMeasure().setStart(measureCoords.getMeasure().getStart() + l);
    }

    public void changeTimeSignature(long l, TimeSignature timeSignature, boolean bl) {
        this.changeTimeSignature(this.getMeasure(l), timeSignature, bl);
    }

    public void changeTimeSignature(MeasureCoords measureCoords, TimeSignature timeSignature, boolean bl) {
        measureCoords.getMeasure().setTimeSignature((TimeSignature)timeSignature.clone());
        long l = measureCoords.getMeasure().getStart() + measureCoords.getMeasure().getLength();
        List list = this.getMeasuresBeforeEnd(measureCoords.getMeasure().getStart() + 1L);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MeasureCoords measureCoords2 = (MeasureCoords)iterator.next();
            long l2 = l - measureCoords2.getMeasure().getStart();
            this.moveMeasure(measureCoords2, l2);
            if (bl) {
                measureCoords2.getMeasure().setTimeSignature((TimeSignature)timeSignature.clone());
            }
            l = measureCoords2.getMeasure().getStart() + measureCoords2.getMeasure().getLength();
        }
    }

    public void changeTempo(long l, Tempo tempo, boolean bl) {
        this.changeTempo(this.getMeasure(l), tempo, bl);
    }

    public void changeTempo(MeasureCoords measureCoords, Tempo tempo, boolean bl) {
        measureCoords.getMeasure().setTempo((Tempo)tempo.clone());
        if (bl) {
            List list = this.getMeasuresBeforeEnd(measureCoords.getMeasure().getStart() + 1L);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MeasureCoords measureCoords2 = (MeasureCoords)iterator.next();
                measureCoords2.getMeasure().setTempo((Tempo)tempo.clone());
            }
        }
    }

    public void changeOpenRepeat(long l) {
        Measure measure;
        measure.setRepeatStart(!(measure = this.getMeasure(l).getMeasure()).isRepeatStart());
    }

    public void changeCloseRepeat(long l, int n) {
        Measure measure = this.getMeasure(l).getMeasure();
        measure.setNumberOfRepetitions(n);
    }

    public void changeInfo(String string, TrackColor trackColor) {
        this.getTrack().setName(string);
        this.getTrack().setColor(trackColor);
    }

    public void changeInstrumentStrings(List list) {
        if (list.size() < this.getTrack().getStrings().size()) {
            this.removeNotesAfterString(list.size());
        }
        this.getTrack().setStrings(list);
    }

    public void removeNotesAfterString(int n) {
        Iterator iterator = this.getMeasuresCoords().iterator();
        while (iterator.hasNext()) {
            MeasureCoords measureCoords = (MeasureCoords)iterator.next();
            measureCoords.removeNotesAfterString(n);
        }
    }

    public void changeInstrument(int n, boolean bl) {
        if (bl) {
            this.getTrack().setChannel(this.songManager.getFreeChannel(n, bl));
            this.getTrack().setInstrument(n);
            this.getTrack().setStrings(SongManager.createPercusionStrings());
        } else {
            if (this.getTrack().isPercusionTrack()) {
                this.getTrack().setStrings(SongManager.createDefaultInstrumentStrings());
            }
            this.getTrack().setChannel(this.songManager.getFreeChannel(n, bl));
            this.getTrack().setInstrument(n);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }
}

