/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.TrackColor;

public class SongCoords {
    private Tablature tablature;
    private SongManager songManager;
    private List tracksCoords;

    public SongCoords(Tablature tablature, SongManager songManager) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.init();
    }

    public void init() {
        this.tracksCoords = new ArrayList();
    }

    public void updateRepetitions() {
        this.songManager.calculateMeasureStartWidthRepetitions();
    }

    public SongTrackCoords getTrackAt(int n, int n2) {
        return this.tablature.getViewLayout().getTrackAt(this.tracksCoords, n, n2);
    }

    public SongTrackCoords getNextTrack(SongTrackCoords songTrackCoords) {
        SongTrackCoords songTrackCoords2 = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords3 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords3.equals(songTrackCoords)) continue;
            int n = i + 1;
            if (n >= this.tracksCoords.size()) break;
            songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(n);
            break;
        }
        return songTrackCoords2;
    }

    public SongTrackCoords getPrevTrack(SongTrackCoords songTrackCoords) {
        SongTrackCoords songTrackCoords2 = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords3 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords3.equals(songTrackCoords)) continue;
            int n = i - 1;
            if (n < 0) break;
            songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(n);
            break;
        }
        return songTrackCoords2;
    }

    public SongTrackCoords getTrack(SongTrack songTrack) {
        SongTrackCoords songTrackCoords = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords2.getTrack().equals(songTrack)) continue;
            songTrackCoords = songTrackCoords2;
            break;
        }
        return songTrackCoords;
    }

    public SongTrackCoords getFirstTrack() {
        SongTrackCoords songTrackCoords = null;
        if (!this.tracksCoords.isEmpty()) {
            songTrackCoords = (SongTrackCoords)this.tracksCoords.get(0);
        }
        return songTrackCoords;
    }

    public SongTrackCoords getLastTrack() {
        SongTrackCoords songTrackCoords = null;
        if (!this.tracksCoords.isEmpty()) {
            songTrackCoords = (SongTrackCoords)this.tracksCoords.get(this.tracksCoords.size() - 1);
        }
        return songTrackCoords;
    }

    private SongTrack makeNewTrack(SongTrack songTrack) {
        Object object;
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        Iterator iterator = songTrack.getMeasures().iterator();
        while (iterator.hasNext()) {
            object = (Measure)iterator.next();
            long l = ((Measure)object).getStart();
            boolean bl = ((Measure)object).isRepeatStart();
            int n = ((Measure)object).getNumberOfRepetitions();
            TimeSignature timeSignature = (TimeSignature)((Measure)object).getTimeSignature().clone();
            Tempo tempo = (Tempo)((Measure)object).getTempo().clone();
            arrayList.add(new Measure(l, new ArrayList(), new ArrayList(), timeSignature, tempo, bl, n));
        }
        object = "Track " + (this.getTrackCoords().size() + 1);
        List list = SongManager.createDefaultInstrumentStrings();
        int n = this.getSongManager().getFreeChannel(0, false);
        return new SongTrack((String)object, n, 0, arrayList, list, TrackColor.RED);
    }

    public void createTrack() {
        SongTrack songTrack = null;
        songTrack = this.songManager.getSong().getTracks().isEmpty() ? SongManager.makeNewTrack("Track 1") : this.makeNewTrack(this.getFirstTrack().getTrack());
        this.addTrack(songTrack);
    }

    public void addTrack(SongTrack songTrack) {
        this.songManager.getSong().getTracks().add(songTrack);
    }

    public void removeTrack(SongTrackCoords songTrackCoords) {
        this.removeTrack(songTrackCoords.getTrack());
    }

    public void removeTrack(SongTrack songTrack) {
        this.songManager.getSong().getTracks().remove(songTrack);
    }

    public void changeTimeSignature(long l, TimeSignature timeSignature, boolean bl) {
        Iterator iterator = this.tracksCoords.iterator();
        while (iterator.hasNext()) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)iterator.next();
            songTrackCoords.changeTimeSignature(l, timeSignature, bl);
        }
    }

    public void changeTempo(long l, Tempo tempo, boolean bl) {
        Iterator iterator = this.tracksCoords.iterator();
        while (iterator.hasNext()) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)iterator.next();
            songTrackCoords.changeTempo(l, tempo, bl);
        }
    }

    public void changeOpenRepeat(long l) {
        Iterator iterator = this.tracksCoords.iterator();
        while (iterator.hasNext()) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)iterator.next();
            songTrackCoords.changeOpenRepeat(l);
        }
        this.updateRepetitions();
    }

    public void changeCloseRepeat(long l, int n) {
        Iterator iterator = this.tracksCoords.iterator();
        while (iterator.hasNext()) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)iterator.next();
            songTrackCoords.changeCloseRepeat(l, n);
        }
        this.updateRepetitions();
    }

    public void addNewMeasureBeforeEnd() {
        Iterator iterator = this.tracksCoords.iterator();
        while (iterator.hasNext()) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)iterator.next();
            songTrackCoords.addNewMeasureBeforeEnd();
        }
    }

    public void removeMeasure(long l) {
        Iterator iterator = this.tracksCoords.iterator();
        while (iterator.hasNext()) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)iterator.next();
            songTrackCoords.removeMeasure(l);
        }
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public List getTrackCoords() {
        return this.tracksCoords;
    }
}

