/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

public class PageViewLayout
extends ViewLayout {
    private int displayWidth;
    private int divisionCount;

    public PageViewLayout(Tablature tablature, SongManager songManager, boolean bl) {
        super(tablature, songManager, bl);
        this.displayWidth = this.getTablature().getDisplay().getBounds().width - 35;
    }

    public void paintSong(GC gC, Rectangle rectangle, int n, int n2) {
        if (this.isMultitrack()) {
            this.paintTracks(this.getTablature().getCaret().getSongCoords().getTrackCoords(), gC, rectangle, n, n2);
        } else {
            ArrayList<SongTrackCoords> arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
            this.paintTracks(arrayList, gC, rectangle, n, n2);
        }
    }

    public void paintTracks(List list, GC gC, Rectangle rectangle, int n, int n2) {
        int n3 = n2 + 50;
        for (int i = 0; i < list.size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            songTrackCoords.paintTrack(gC, n, n3, rectangle);
            n3 += 150;
        }
    }

    public void paintMeasures(SongTrackCoords songTrackCoords, List list, GC gC, int n, int n2, Rectangle rectangle) {
        int n3;
        int n4;
        MeasureCoords measureCoords;
        songTrackCoords.setPosY(n2);
        int n5 = songTrackCoords.getPosX();
        int n6 = songTrackCoords.getPosY();
        int n7 = 0;
        int n8 = 0;
        this.divisionCount = 1;
        int n9 = 20;
        ArrayList<MeasureCoords> arrayList = new ArrayList<MeasureCoords>();
        for (int i = 0; i < list.size(); ++i) {
            measureCoords = (MeasureCoords)list.get(i);
            measureCoords.calculateWidth();
            if (n9 + measureCoords.getWidth() >= this.getMaxWidth() && !arrayList.isEmpty()) {
                n4 = 0;
                n3 = this.getMaxWidth() - n9;
                if (n3 > arrayList.size() && arrayList.size() > 0) {
                    n4 = n3 / arrayList.size();
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    MeasureCoords measureCoords2 = (MeasureCoords)iterator.next();
                    measureCoords2.setPosX(n5);
                    measureCoords2.setPosY(n6);
                    boolean bl2 = n5 + n > rectangle.x - 1500 && n5 + n < rectangle.x + rectangle.width + 100;
                    boolean bl3 = bl = n6 > rectangle.y - 150 && n6 < rectangle.y + rectangle.height + 150;
                    if (bl2 && bl) {
                        measureCoords2.setSpan(n4);
                        measureCoords2.paintMeasure(gC, n5 + n, n6, rectangle);
                    }
                    if ((n5 += measureCoords2.getWidth() + measureCoords2.getSpan()) <= n7) continue;
                    n7 = n5;
                }
                n5 = songTrackCoords.getPosX();
                n6 += this.getLinearSpan();
                n8 += this.getLinearSpan();
                n9 = 20;
                arrayList.clear();
                ++this.divisionCount;
            }
            n9 += measureCoords.getWidth();
            arrayList.add(measureCoords);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            measureCoords = (MeasureCoords)iterator.next();
            measureCoords.setPosX(n5);
            measureCoords.setPosY(n6);
            n4 = n5 + n > rectangle.x - 1500 && n5 + n < rectangle.x + rectangle.width + 100 ? 1 : 0;
            int n10 = n3 = n6 > rectangle.y - 150 && n6 < rectangle.y + rectangle.height + 150 ? 1 : 0;
            if (n4 != 0 && n3 != 0) {
                measureCoords.setSpan(0);
                measureCoords.paintMeasure(gC, n5 + n, n6, rectangle);
            }
            if ((n5 += measureCoords.getWidth() + measureCoords.getSpan()) <= n7) continue;
            n7 = n5;
        }
        this.setWidth(n7);
        this.setHeight((n8 += this.getLinearSpan()) + 150 + 100);
    }

    public void paintStrings(SongTrackCoords songTrackCoords, GC gC, int n, Rectangle rectangle) {
        int n2 = 20 - this.getTablature().getHorizontalBar().getSelection();
        n2 = n2 < 0 ? 0 : n2;
        int n3 = this.getLinearSpan();
        int n4 = songTrackCoords.getTrack().getStrings().size() * 12;
        Iterator iterator = songTrackCoords.getTrack().getStrings().iterator();
        while (iterator.hasNext()) {
            InstrumentString instrumentString = (InstrumentString)iterator.next();
            int n5 = instrumentString.getNumber() * 12;
            for (int i = 0; i < this.divisionCount; ++i) {
                boolean bl;
                int n6 = n + n5 + i * n3;
                boolean bl2 = bl = n6 - n4 > rectangle.y - 150 && n6 + n4 < rectangle.y + rectangle.height + 150;
                if (!bl) continue;
                gC.drawLine(n2, n6, this.getMaxWidth(), n6);
            }
        }
    }

    public SongTrackCoords getTrackAt(List arrayList, int n, int n2) {
        if (!this.isMultitrack()) {
            arrayList = new ArrayList<SongTrackCoords>();
            arrayList.add(this.getTablature().getCaret().getSongTrackCoords());
        }
        SongTrackCoords songTrackCoords = null;
        int n3 = this.getLinearSpan();
        for (int i = 0; i < arrayList.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)arrayList.get(i);
            int n4 = songTrackCoords2.getHeight();
            for (int j = 0; j < this.divisionCount; ++j) {
                int n5 = songTrackCoords2.getPosY() + j * n3;
                if (n >= n5 - 75 && n <= n5 + n4 + 75) {
                    songTrackCoords = songTrackCoords2;
                }
                n5 += n3;
            }
        }
        return songTrackCoords;
    }

    public void followMeasure(MeasureCoords measureCoords, boolean bl) {
        this.getTablature().moveScrollVerticalTo(measureCoords, 50, 50, bl);
    }

    private int getLinearSpan() {
        int n = 200;
        if (this.isMultiTrack()) {
            n *= this.getTrackCount();
        }
        return n;
    }

    public int getMaxWidth() {
        return this.displayWidth;
    }
}

