/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.tab.SilenceCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.TablatureUtil;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

public class MeasureCoords {
    public static final int DEFAULT_LEFT_SPAN = 15;
    public static final int DEFAULT_RIGHT_SPAN = 15;
    public static final int DEFAULT_TIME_SIGNATURE_SPAN = 40;
    public static final int DEFAULT_QUARTER_SPAN = 30;
    private Tablature tablature;
    private int measureId;
    private int posX;
    private int posY;
    private int lastFromX;
    private int lastFromY;
    private int width;
    private int height;
    private int quarterSpan;
    private long beatLength;
    private boolean paintTimeSignature;
    private boolean paintTempo;
    private List measureComponents;
    private Measure measure;
    private SongTrackCoords trackCoords;
    private SongManager songManager;
    private Caret caret;
    private int span;

    public MeasureCoords(int n, SongManager songManager, Tablature tablature, Measure measure, SongTrackCoords songTrackCoords) {
        this.measureId = n;
        this.measure = measure;
        this.trackCoords = songTrackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
    }

    public void create() {
        this.measureComponents.clear();
        this.beatLength = TablatureUtil.getBeatLength(this.getMeasure().getTimeSignature());
        this.autoCompleteSilences();
        this.calculateQuarterSpan();
    }

    public void update() {
        this.orderNotes();
        this.calculateTimeSignature();
        this.calculateTempo();
        this.calculateWidth();
        this.calculateHeight();
        this.calcuateComponents();
        this.updateComponents();
        this.updateCaret();
        this.orderComponents();
    }

    private void calculateQuarterSpan() {
        if (this.measure.getNotes().isEmpty() && this.measure.getSilences().isEmpty()) {
            this.quarterSpan = 30;
        } else {
            Serializable serializable;
            int n;
            Serializable serializable2;
            Duration duration = null;
            if (!this.measure.getNotes().isEmpty()) {
                serializable2 = null;
                for (n = 0; n < this.measure.getNotes().size(); ++n) {
                    serializable = (Note)this.measure.getNotes().get(n);
                    if (serializable2 != null && ((Note)serializable).getDuration().getTime() > ((Note)serializable2).getDuration().getTime()) continue;
                    serializable2 = serializable;
                }
                duration = ((Note)serializable2).getDuration();
            }
            if (!this.measure.getSilences().isEmpty()) {
                serializable2 = null;
                for (n = 0; n < this.measure.getSilences().size(); ++n) {
                    serializable = (Silence)this.measure.getSilences().get(n);
                    if (serializable2 != null && ((Silence)serializable).getDuration().getTime() > ((Silence)serializable2).getDuration().getTime()) continue;
                    serializable2 = serializable;
                }
                if (duration == null || ((Silence)serializable2).getDuration().getTime() <= duration.getTime()) {
                    duration = ((Silence)serializable2).getDuration();
                }
            }
            this.quarterSpan = TablatureUtil.getSpanForQuarter(duration);
        }
    }

    private void calculateTimeSignature() {
        this.paintTimeSignature = false;
        MeasureCoords measureCoords = this.trackCoords.getPrevMeasure(this);
        if (measureCoords == null) {
            this.paintTimeSignature = true;
        } else {
            int n = this.getMeasure().getTimeSignature().getNumerator();
            int n2 = this.getMeasure().getTimeSignature().getDenominator().getValue();
            int n3 = measureCoords.getMeasure().getTimeSignature().getNumerator();
            int n4 = measureCoords.getMeasure().getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                this.paintTimeSignature = true;
            }
        }
    }

    private void calculateTempo() {
        this.paintTempo = false;
        MeasureCoords measureCoords = this.trackCoords.getPrevMeasure(this);
        if (measureCoords == null) {
            this.paintTempo = true;
        } else if (this.getMeasure().getTempo().getValue() != measureCoords.getMeasure().getTempo().getValue()) {
            this.paintTempo = true;
        }
    }

    private void calcuateComponents() {
        this.measureComponents.clear();
        this.calculateComponentsCoords();
    }

    private void calculateComponentsCoords() {
        Serializable serializable;
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.measure.getNotes().size(); ++n) {
            serializable = (Note)this.measure.getNotes().get(n);
            n3 = ((Note)serializable).getString() * 12;
            n2 = TablatureUtil.getStartPosition(this.measure, ((Note)serializable).getStart(), this.quarterSpan) + 10;
            this.measureComponents.add(new NoteCoords(this.tablature, this.trackCoords, this, (Note)serializable, n2 + this.getTimeSignatureSpan(), n3));
        }
        for (n = 0; n < this.measure.getSilences().size(); ++n) {
            serializable = (Silence)this.measure.getSilences().get(n);
            n2 = TablatureUtil.getStartPosition(this.measure, ((Silence)serializable).getStart(), this.quarterSpan) + 5;
            this.measureComponents.add(new SilenceCoords(this.tablature, this, (Silence)serializable, n2 + this.getTimeSignatureSpan(), 30));
        }
    }

    private void autoCompleteSilences() {
        int n;
        this.measureComponents.clear();
        for (n = 0; n < this.measure.getNotes().size(); ++n) {
            this.measureComponents.add(new NoteCoords(this.tablature, this.trackCoords, this, (Note)this.measure.getNotes().get(n), 0, 0));
        }
        for (n = 0; n < this.measure.getSilences().size(); ++n) {
            this.measureComponents.add(new SilenceCoords(this.tablature, this, (Silence)this.measure.getSilences().get(n), 0, 0));
        }
        long l = this.getMeasure().getStart();
        long l2 = 0L;
        long l3 = 0L;
        MeasureComponent measureComponent = this.getFirstComponent();
        while (measureComponent != null) {
            l2 = measureComponent.getStart() + measureComponent.getDuration().getTime();
            if (measureComponent.getStart() > l && (l3 = measureComponent.getStart() - l) > 0L) {
                this.createSilences(l, l3);
            }
            l = l2;
            measureComponent = this.getNextComponent(measureComponent);
        }
        l2 = this.getMeasure().getStart() + this.getMeasure().getLength();
        l3 = l2 - l;
        if (l3 > 0L) {
            this.createSilences(l, l3);
        }
    }

    private void createSilences(long l, long l2) {
        List list = TablatureUtil.createDurations(l2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Duration duration = (Duration)iterator.next();
            Silence silence = new Silence(l, duration);
            this.addSilence(silence);
            l += duration.getTime();
        }
    }

    private void updateComponents() {
        Iterator iterator = this.measureComponents.iterator();
        while (iterator.hasNext()) {
            MeasureComponent measureComponent = (MeasureComponent)iterator.next();
            measureComponent.update();
        }
    }

    private void updateCaret() {
        if (this.caret != null && !this.measureComponents.contains(this.caret.getSelectedComponent())) {
            MeasureComponent measureComponent = this.getComponent(this.caret.getPosition());
            if (measureComponent == null) {
                measureComponent = this.getFirstComponent();
            }
            this.caret.moveTo(this.trackCoords, this, measureComponent);
        }
    }

    public void calculateWidth() {
        TimeSignature timeSignature = this.getMeasure().getTimeSignature();
        double d = 1.0 / (double)timeSignature.getDenominator().getValue() * 4.0 * (double)timeSignature.getNumerator();
        this.width = (int)((double)this.quarterSpan * d);
        this.width += this.getTimeSignatureSpan();
        this.width += 15;
        this.width += 15;
    }

    public void calculateHeight() {
        this.height = this.trackCoords.getTrack().getStrings().size() * 12;
    }

    private void orderNotes() {
        for (int i = 0; i < this.getMeasure().getNotes().size(); ++i) {
            Note note = null;
            for (int j = i; j < this.getMeasure().getNotes().size(); ++j) {
                Note note2 = (Note)this.getMeasure().getNotes().get(j);
                if (note != null && note2.getStart() >= note.getStart()) continue;
                note = note2;
            }
            this.getMeasure().getNotes().remove(note);
            this.getMeasure().getNotes().add(i, note);
        }
    }

    private void orderComponents() {
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent = null;
            for (int j = i; j < this.measureComponents.size(); ++j) {
                MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(j);
                if (measureComponent != null && measureComponent2.getStart() >= measureComponent.getStart()) continue;
                measureComponent = measureComponent2;
            }
            this.measureComponents.remove(measureComponent);
            this.measureComponents.add(i, measureComponent);
        }
    }

    public void paintMeasure(GC gC, int n, int n2, Rectangle rectangle, int n3) {
        this.paintTempo(gC, n, n2);
        this.paintTimeSignature(gC, n, n2);
        this.paintComponents(gC, n, n2, rectangle);
        this.paintDivisions(gC, n, n2);
        this.paintCaret(gC, n, n2);
        this.lastFromX = n;
        this.lastFromY = n2;
    }

    public void paintMeasure(GC gC, int n, int n2, Rectangle rectangle) {
        this.paintMeasure(gC, n, n2, rectangle, 0);
    }

    public void paintComponents(GC gC, int n, int n2, Rectangle rectangle) {
        if (this.isPlaying()) {
            gC.setForeground(this.tablature.getDisplay().getSystemColor(3));
        }
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent = (MeasureComponent)this.measureComponents.get(i);
            measureComponent.setSpan(this.getSpanForComponent(measureComponent));
            measureComponent.paint(gC, n + 15, n2);
        }
        if (this.isPlaying()) {
            gC.setForeground(new Color((Device)this.tablature.getDisplay(), 0, 0, 0));
        }
    }

    public void paintCaret(GC gC, int n, int n2) {
        if (this.hasCaret()) {
            this.caret.paintCaret(gC, n + 15 + this.getTimeSignatureSpan(), n2);
        }
    }

    private void paintDivisions(GC gC, int n, int n2) {
        int n3 = n2 + 12;
        int n4 = n2 + this.trackCoords.getTrack().getStrings().size() * 12;
        if (this.measure.isRepeatStart()) {
            gC.setLineWidth(3);
            gC.drawLine(n, n3, n, n4);
            gC.drawOval(n + 7, n3 + (n4 - n3) / 2 - 7, 1, 2);
            gC.drawOval(n + 7, n3 + (n4 - n3) / 2 + 7, 1, 2);
            gC.setLineWidth(1);
            gC.drawLine(n + 3, n3, n + 3, n4);
        } else if (this.isFirstMeasure()) {
            gC.setLineWidth(3);
            gC.drawLine(n, n3, n, n4);
            gC.setLineWidth(1);
            gC.drawLine(n + 3, n3, n + 3, n4);
        } else {
            gC.drawLine(n, n3, n, n4);
        }
        if (this.measure.getNumberOfRepetitions() > 0) {
            gC.setLineWidth(3);
            gC.drawLine(n + this.getWidth() + this.getSpan(), n3, n + this.getWidth() + this.getSpan(), n4);
            gC.drawOval(n + this.getWidth() - 8 + this.getSpan(), n3 + (n4 - n3) / 2 - 7, 2, 2);
            gC.drawOval(n + this.getWidth() - 8 + this.getSpan(), n3 + (n4 - n3) / 2 + 7, 2, 2);
            gC.setLineWidth(1);
            gC.drawLine(n + this.getWidth() - 3 + this.getSpan(), n3, n + this.getWidth() - 3 + this.getSpan(), n4);
            gC.drawString("x" + Integer.toString(this.measure.getNumberOfRepetitions()), n + this.getWidth() - 10 + this.getSpan(), n2 - 5);
        } else if (this.isLastMeasure()) {
            gC.setLineWidth(3);
            gC.drawLine(n + this.getWidth() + this.getSpan(), n3, n + this.getWidth() + this.getSpan(), n4);
            gC.setLineWidth(1);
            gC.drawLine(n + this.getWidth() - 3 + this.getSpan(), n3, n + this.getWidth() - 3 + this.getSpan(), n4);
        } else {
            gC.drawLine(n + this.getWidth() + this.getSpan(), n3, n + this.getWidth() + this.getSpan(), n4);
        }
    }

    private void paintTimeSignature(GC gC, int n, int n2) {
        if (this.paintTimeSignature) {
            Font font = gC.getFont();
            gC.setFont(new Font((Device)this.tablature.getDisplay(), new FontData("Arial", 14, 1)));
            int n3 = this.getHeight() / 2;
            int n4 = n + 15 + 10;
            int n5 = n2 + (n3 - 12);
            int n6 = n2 + (n3 + 5);
            gC.drawString(Integer.toString(this.getMeasure().getTimeSignature().getNumerator()), n4, n5);
            gC.drawString(Integer.toString(this.getMeasure().getTimeSignature().getDenominator().getValue()), n4, n6);
            gC.setFont(font);
        }
    }

    private void paintTempo(GC gC, int n, int n2) {
        if (this.paintTempo) {
            int n3 = n;
            int n4 = n2 - 10;
            String string = "Tempo: " + this.getMeasure().getTempo().getValue();
            gC.drawString(string, n3, n4);
        }
    }

    public boolean isPlaying() {
        long l;
        return this.songManager.getPlayer().isRunning() && (l = this.songManager.getPlayer().getTickPosition()) >= this.getMeasure().getStart() && l < this.getMeasure().getStart() + this.getMeasure().getLength();
    }

    public int getSpanForComponent(MeasureComponent measureComponent) {
        return (int)((measureComponent.getStart() - this.getMeasure().getStart()) * (long)this.getSpan() / this.getMeasure().getLength());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTimeSignatureSpan() {
        int n = 0;
        if (this.paintTimeSignature) {
            n = 40;
        }
        return n;
    }

    public MeasureComponent getPreviousComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent3.getStart() >= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() > measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getFirstComponent() {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent != null && measureComponent2.getStart() >= measureComponent.getStart()) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public MeasureComponent getLastComponent() {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent != null && measureComponent.getStart() >= measureComponent2.getStart()) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public MeasureComponent getComponent(long l) {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent2.getStart() != l) continue;
            measureComponent = measureComponent2;
            break;
        }
        return measureComponent;
    }

    public List getComponents(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        Iterator iterator = this.measureComponents.iterator();
        while (iterator.hasNext()) {
            MeasureComponent measureComponent = (MeasureComponent)iterator.next();
            if (measureComponent.getStart() != l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public MeasureComponent getComponent(long l, int n) {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            NoteCoords noteCoords;
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent2 instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent2).getStart() != l || noteCoords.getNote().getString() != n) continue;
            measureComponent = measureComponent2;
            break;
        }
        return measureComponent;
    }

    public List getComponentsBeforeEnd(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        Iterator iterator = this.measureComponents.iterator();
        while (iterator.hasNext()) {
            MeasureComponent measureComponent = (MeasureComponent)iterator.next();
            if (measureComponent.getStart() < l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public List getComponents() {
        return this.measureComponents;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent measureComponent, int n) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            Note note;
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof NoteCoords) || (note = ((NoteCoords)measureComponent3).getNote()).getString() != n || note.getStart() <= measureComponent.getStart() || measureComponent2 != null && note.getStart() >= measureComponent2.getStart()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof NoteCoords) || measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextSilenceComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof SilenceCoords) || measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getComponentAt(int n) {
        MeasureComponent measureComponent = null;
        Iterator iterator = this.measureComponents.iterator();
        while (iterator.hasNext()) {
            MeasureComponent measureComponent2 = (MeasureComponent)iterator.next();
            if (measureComponent == null) {
                measureComponent = measureComponent2;
                continue;
            }
            int n2 = Math.abs(n - measureComponent.getPointX());
            int n3 = Math.abs(n - measureComponent2.getPointX());
            if (n3 >= n2) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public InstrumentString getStringAt(int n) {
        InstrumentString instrumentString = null;
        int n2 = 0;
        Iterator iterator = this.trackCoords.getTrack().getStrings().iterator();
        while (iterator.hasNext()) {
            InstrumentString instrumentString2 = (InstrumentString)iterator.next();
            int n3 = Math.abs(n - (instrumentString2.getNumber() * 12 + this.lastFromY));
            if (instrumentString != null && n3 >= n2) continue;
            instrumentString = instrumentString2;
            n2 = n3;
        }
        return instrumentString;
    }

    public void addComponent(MeasureComponent measureComponent) {
        this.measureComponents.add(measureComponent);
    }

    public void removeComponent(MeasureComponent measureComponent) {
        this.measureComponents.remove(measureComponent);
    }

    public boolean hasComponent(MeasureComponent measureComponent) {
        return this.measureComponents.contains(measureComponent);
    }

    public void removeComponentsAt(long l, int n, boolean bl) {
        List list = this.getComponents(l);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MeasureComponent measureComponent;
            MeasureComponent measureComponent2 = (MeasureComponent)iterator.next();
            if (measureComponent2 instanceof SilenceCoords) {
                measureComponent = (SilenceCoords)measureComponent2;
                this.removeSilence(((SilenceCoords)measureComponent).getSilence());
                continue;
            }
            if (!(measureComponent2 instanceof NoteCoords) || ((NoteCoords)(measureComponent = (NoteCoords)measureComponent2)).getNote().getString() != n) continue;
            this.removeNote(((NoteCoords)measureComponent).getNote());
            if (!bl || list.size() != 1) continue;
            this.addSilence(new Silence(((NoteCoords)measureComponent).getStart(), (Duration)((NoteCoords)measureComponent).getDuration().clone()));
        }
    }

    public void removeAllComponentsAt(long l) {
        List list = this.getComponents(l);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MeasureComponent measureComponent;
            MeasureComponent measureComponent2 = (MeasureComponent)iterator.next();
            if (measureComponent2 instanceof SilenceCoords) {
                measureComponent = (SilenceCoords)measureComponent2;
                this.removeSilence(((SilenceCoords)measureComponent).getSilence());
                continue;
            }
            if (!(measureComponent2 instanceof NoteCoords)) continue;
            measureComponent = (NoteCoords)measureComponent2;
            this.removeNote(((NoteCoords)measureComponent).getNote());
        }
    }

    public void addNote(Note note) {
        int n = TablatureUtil.getStartPosition(this.measure, note.getStart(), this.quarterSpan) + 5;
        NoteCoords noteCoords = new NoteCoords(this.tablature, this.trackCoords, this, note, n, 30);
        if (this.canInsert(noteCoords, true, false)) {
            this.removeComponentsAt(note.getStart(), note.getString(), false);
            this.getMeasure().addNote(note);
            this.measureComponents.add(noteCoords);
            this.tryChangeSilenceAfter(noteCoords);
        }
    }

    public void tryChangeSilenceAfter(MeasureComponent measureComponent) {
        this.autoCompleteSilences();
        MeasureComponent measureComponent2 = this.getNextComponent(measureComponent);
        long l = measureComponent.getStart() + measureComponent.getDuration().getTime();
        long l2 = this.getMeasure().getStart() + this.getMeasure().getLength();
        if (measureComponent2 instanceof SilenceCoords && l <= l2) {
            long l3 = this.getRealStart(l) - this.getRealStart(measureComponent2.getStart());
            if (measureComponent2.getStart() + l3 < l2 && measureComponent2.getStart() + measureComponent2.getDuration().getTime() + l3 <= l2) {
                this.moveComponent(measureComponent2, l3);
                this.changeDuration(measureComponent2, (Duration)measureComponent.getDuration().clone());
            }
        }
    }

    public void removeNote(Note note) {
        this.getMeasure().removeNote(note);
    }

    public void changeTieNote(long l, int n) {
        MeasureComponent measureComponent = this.getComponent(l, n);
        if (measureComponent instanceof NoteCoords) {
            NoteCoords noteCoords = (NoteCoords)measureComponent;
            noteCoords.getNote().setTiedNote(!noteCoords.getNote().isTiedNote());
        }
    }

    public void changeVibratoNote(long l, int n) {
        MeasureComponent measureComponent = this.getComponent(l, n);
        if (measureComponent instanceof NoteCoords) {
            NoteCoords noteCoords = (NoteCoords)measureComponent;
            noteCoords.getNote().getEffect().setVibrato(!noteCoords.getNote().getEffect().isVibrato());
        }
    }

    public void changeSlideNote(long l, int n) {
        MeasureComponent measureComponent = this.getComponent(l, n);
        if (measureComponent instanceof NoteCoords) {
            NoteCoords noteCoords = (NoteCoords)measureComponent;
            noteCoords.getNote().getEffect().set(noteCoords.getNote().getEffect().isVibrato(), null, !noteCoords.getNote().getEffect().isSlide(), false);
        }
    }

    public void changeHammerNote(long l, int n) {
        MeasureComponent measureComponent = this.getComponent(l, n);
        if (measureComponent instanceof NoteCoords) {
            NoteCoords noteCoords = (NoteCoords)measureComponent;
            noteCoords.getNote().getEffect().set(noteCoords.getNote().getEffect().isVibrato(), null, false, !noteCoords.getNote().getEffect().isHammer());
        }
    }

    public void addSilence(Silence silence) {
        int n = TablatureUtil.getStartPosition(this.measure, silence.getStart(), this.quarterSpan) + 5;
        SilenceCoords silenceCoords = new SilenceCoords(this.tablature, this, silence, n, 30);
        if (this.canInsert(silenceCoords, true, false)) {
            this.removeAllComponentsAt(silence.getStart());
            this.getMeasure().addSilence(silence);
            this.measureComponents.add(silenceCoords);
        }
    }

    public void removeSilence(Silence silence) {
        this.removeSilence(silence, false);
    }

    public void removeSilence(Silence silence, boolean bl) {
        MeasureComponent measureComponent = this.getComponent(silence.getStart());
        MeasureComponent measureComponent2 = this.getNextComponent(measureComponent);
        this.getMeasure().removeSilence(silence);
        if (bl) {
            long l = silence.getStart();
            long l2 = silence.getDuration().getTime();
            if (measureComponent2 != null) {
                l2 = measureComponent2.getStart() - l;
            }
            this.moveComponents(l + l2, -l2);
        }
    }

    public void changeDuration(MeasureComponent measureComponent, Duration duration) {
        Duration duration2 = (Duration)measureComponent.getDuration().clone();
        measureComponent.setDuration((Duration)duration.clone());
        if (this.canInsert(measureComponent, true, true)) {
            List list = this.getComponents(measureComponent.getStart());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MeasureComponent measureComponent2 = (MeasureComponent)iterator.next();
                measureComponent2.setDuration((Duration)duration.clone());
            }
            this.tryChangeSilenceAfter(measureComponent);
        } else {
            measureComponent.setDuration(duration2);
        }
    }

    public boolean moveComponents(long l, long l2) {
        long l3 = this.getMeasure().getStart();
        long l4 = this.getMeasure().getLength();
        List list = this.getComponentsBeforeEnd(l);
        this.moveComponents(list, l2);
        MeasureComponent measureComponent = this.getFirstComponent();
        while (measureComponent instanceof SilenceCoords) {
            this.removeSilence(((SilenceCoords)measureComponent).getSilence());
            measureComponent = this.getNextComponent(measureComponent);
        }
        MeasureComponent measureComponent2 = this.getLastComponent();
        while (measureComponent2 instanceof SilenceCoords) {
            this.removeSilence(((SilenceCoords)measureComponent2).getSilence());
            measureComponent2 = this.getPreviousComponent(measureComponent2);
        }
        if (measureComponent != null && measureComponent2 != null && (measureComponent.getStart() < l3 || measureComponent2.getStart() + measureComponent2.getDuration().getTime() > l3 + l4)) {
            this.moveComponents(list, -l2);
            return false;
        }
        return true;
    }

    public void moveAllComponents(long l) {
        this.moveComponents(this.measureComponents, l);
    }

    private void moveComponents(List list, long l) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MeasureComponent measureComponent = (MeasureComponent)iterator.next();
            this.moveComponent(measureComponent, l);
        }
    }

    private void moveComponent(MeasureComponent measureComponent, long l) {
        long l2 = measureComponent.getStart();
        measureComponent.setStart(l2 + l);
    }

    public boolean isEmpty(long l) {
        return this.getComponents(l).isEmpty();
    }

    public boolean canInsert(MeasureComponent measureComponent, boolean bl, boolean bl2) {
        long l;
        boolean bl3 = true;
        this.orderComponents();
        MeasureComponent measureComponent2 = this.getNextComponent(measureComponent);
        long l2 = measureComponent.getStart() + measureComponent.getDuration().getTime();
        if (measureComponent2 == null) {
            if (l2 > this.getMeasure().getStart() + this.getMeasure().getLength()) {
                bl3 = false;
            }
        } else if (l2 > measureComponent2.getStart()) {
            bl3 = false;
        }
        if (bl && !bl3 && measureComponent2 instanceof SilenceCoords) {
            l = 0L;
            ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
            while (measureComponent2 instanceof SilenceCoords) {
                arrayList.add(measureComponent2);
                l = measureComponent2.getStart() + measureComponent2.getDuration().getTime();
                measureComponent2 = this.getNextComponent(measureComponent2);
            }
            if (measureComponent2 == null) {
                l = this.getMeasure().getStart() + this.getMeasure().getLength();
            } else if (measureComponent2 instanceof NoteCoords) {
                l = measureComponent2.getStart();
            }
            if (l2 <= l) {
                while (!arrayList.isEmpty()) {
                    SilenceCoords silenceCoords = (SilenceCoords)arrayList.get(0);
                    this.getMeasure().removeSilence(silenceCoords.getSilence());
                    arrayList.remove(silenceCoords);
                }
                bl3 = true;
            }
        }
        if (!bl3 && bl && bl2 && (measureComponent2 = this.getNextComponent(measureComponent)) != null) {
            l = measureComponent.getDuration().getTime() - (measureComponent2.getStart() - measureComponent.getStart());
            long l3 = 0L;
            ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
            MeasureComponent measureComponent3 = this.getNextSilenceComponent(measureComponent);
            while (measureComponent3 instanceof SilenceCoords) {
                arrayList.add(measureComponent3);
                l3 += measureComponent3.getDuration().getTime();
                measureComponent3 = this.getNextSilenceComponent(measureComponent3);
            }
            if (l <= l3) {
                List list = this.getComponentsBeforeEnd(measureComponent2.getStart());
                while (!list.isEmpty()) {
                    MeasureComponent measureComponent4 = (MeasureComponent)list.get(0);
                    if (measureComponent4 instanceof SilenceCoords) {
                        SilenceCoords silenceCoords = (SilenceCoords)measureComponent4;
                        l -= silenceCoords.getDuration().getTime();
                        this.getMeasure().removeSilence(silenceCoords.getSilence());
                    } else if (l > 0L) {
                        this.moveComponent(measureComponent4, l);
                    }
                    list.remove(0);
                }
                bl3 = true;
            }
        }
        return bl3;
    }

    public long getBeatLength() {
        return this.beatLength;
    }

    public long getRealStart(long l) {
        boolean bl;
        long l2 = l;
        long l3 = this.getBeatLength();
        boolean bl2 = bl = l2 % l3 == 0L;
        if (!bl) {
            Duration duration = new Duration(64, false, false, new Tupleto(3, 2));
            int n = 0;
            while ((long)n < duration.getTime()) {
                boolean bl3 = bl = ++l2 % l3 == 0L;
                if (bl) break;
                ++n;
            }
            if (!bl) {
                l2 = l;
            }
        }
        return l2;
    }

    public boolean areInSameBeat(MeasureComponent measureComponent, MeasureComponent measureComponent2) {
        long l = this.measure.getStart() + this.getMeasure().getLength();
        long l2 = this.getBeatLength();
        long l3 = this.getRealStart(measureComponent.getStart());
        long l4 = this.getRealStart(measureComponent2.getStart());
        long l5 = this.measure.getStart();
        boolean bl = false;
        while (!bl) {
            if (l3 >= l5 && l3 < l5 + l2 && l4 >= l5 && l4 < l5 + l2) {
                return true;
            }
            if ((l5 += l2) <= l) continue;
            bl = true;
        }
        return false;
    }

    public void removeNotesAfterString(int n) {
        Iterator iterator = this.measureComponents.iterator();
        while (iterator.hasNext()) {
            NoteCoords noteCoords;
            MeasureComponent measureComponent = (MeasureComponent)iterator.next();
            if (!(measureComponent instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent).getNote().getString() <= n) continue;
            this.removeNote(noteCoords.getNote());
        }
    }

    public boolean isFirstMeasure() {
        return this.measureId == 0;
    }

    public boolean isLastMeasure() {
        return this.trackCoords.getTrack().getMeasures().size() == this.measureId + 1;
    }

    public boolean hasCaret() {
        return this.caret != null;
    }

    public Caret getCaret() {
        return this.caret;
    }

    public void setCaret(Caret caret) {
        this.caret = caret;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public int getLastFromX() {
        return this.lastFromX;
    }

    public int getLastFromY() {
        return this.lastFromY;
    }

    public void setQuarterSpan(int n) {
        this.quarterSpan = n;
    }

    public int getQuarterSpan() {
        return this.quarterSpan;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public int getMeasureId() {
        return this.measureId;
    }

    public void setMeasureId(int n) {
        this.measureId = n;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int n) {
        this.span = n;
    }
}

