/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.TrackColor;

public class SongMixer
extends Composite {
    private TablatureEditor editor;
    private Table table;
    private Composite trackMeasures;
    private Button trackMeasuresHeader;

    public SongMixer(Composite composite, TablatureEditor tablatureEditor) {
        super(composite, 2560);
        this.setLayout((Layout)new FillLayout());
        this.editor = tablatureEditor;
        this.init();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                SongMixer.this.updateTable();
                SongMixer.this.updateScrolls();
                SongMixer.this.trackMeasures.redraw();
            }
        });
        final Point point = new Point(0, 0);
        final ScrollBar scrollBar = this.getVerticalBar();
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = scrollBar.getSelection();
                int n2 = -n - point.y;
                Rectangle rectangle = SongMixer.this.trackMeasures.getBounds();
                SongMixer.this.getShell().scroll(0, n2, 0, 0, rectangle.width, rectangle.height, false);
                point.y = -n;
                SongMixer.this.table.getVerticalBar().setSelection(n);
                SongMixer.this.trackMeasures.redraw();
            }
        });
    }

    private void init() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.setLayoutData(formData);
        SashForm sashForm = new SashForm((Composite)this, 256);
        sashForm.setLayout((Layout)new FormLayout());
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.setLayoutData(formData);
        this.initTable((Composite)sashForm);
        this.initTrackMeasures((Composite)sashForm);
    }

    private void initTable(Composite composite) {
        this.table = new Table(composite, 0);
        this.table.getHorizontalBar().setVisible(true);
        this.table.getVerticalBar().setVisible(false);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        for (int i = 0; i < 4; ++i) {
            new TableColumn(this.table, 0);
        }
        this.loadProperties();
        this.updateTable();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                int n = SongMixer.this.getSelectedTrackIndex(mouseEvent.y);
                if (n >= 0) {
                    TableItem tableItem = SongMixer.this.table.getItem(n);
                    SongMixer.this.table.setData(tableItem.getData());
                    TuxGuitar.instance().getAction("GO_TO_TRACK").doAction((TypedEvent)mouseEvent);
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                int n = SongMixer.this.getSelectedTrackIndex(mouseEvent.y);
                if (n >= 0) {
                    TuxGuitar.instance().getAction("CHANGE_TRACK_PROPERTIES").doAction((TypedEvent)mouseEvent);
                }
            }
        });
        this.table.getColumn(0).pack();
        this.table.getColumn(1).setWidth(200);
        this.table.getColumn(2).pack();
    }

    private void initTrackMeasures(Composite composite) {
        this.trackMeasures = new Composite(composite, 256);
        this.trackMeasuresHeader = new Button(this.trackMeasures, 8);
        this.trackMeasuresHeader.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TuxGuitar.instance().getAction("CHANGE_INFO").doAction((TypedEvent)mouseEvent);
            }
        });
        final Point point = new Point(0, 0);
        final ScrollBar scrollBar = this.trackMeasures.getHorizontalBar();
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = scrollBar.getSelection();
                int n2 = -n - point.x;
                Rectangle rectangle = SongMixer.this.trackMeasures.getClientArea();
                SongMixer.this.trackMeasures.getShell().scroll(n2, 0, 0, 0, rectangle.width, rectangle.height, false);
                point.x = -n;
                SongMixer.this.trackMeasures.redraw();
            }
        });
        this.trackMeasures.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                int n = scrollBar.getSelection();
                int n2 = SongMixer.this.table.getVerticalBar().getSelection();
                SongMixer.this.paintMeasures(paintEvent.gc, -n, -n2);
            }
        });
        this.trackMeasures.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                int n = SongMixer.this.getSelectedTrackIndex(mouseEvent.y);
                if (n >= 0) {
                    int n2 = scrollBar.getSelection();
                    int n3 = SongMixer.this.table.getItemHeight();
                    SongTrackCoords songTrackCoords = (SongTrackCoords)SongMixer.this.editor.getTablature().getSongCoords().getTrackCoords().get(n);
                    List list = songTrackCoords.getMeasuresCoords();
                    int n4 = list.size();
                    int n5 = -n2;
                    for (int i = 0; i < n4; ++i) {
                        if (mouseEvent.x >= n5 && mouseEvent.x < n5 + n3) {
                            MeasureCoords measureCoords = (MeasureCoords)list.get(i);
                            SongMixer.this.editor.getTablature().getCaret().moveTo(songTrackCoords, measureCoords, measureCoords.getFirstComponent());
                            SongMixer.this.editor.getTablature().getSongManager().getPlayer().setTickPosition(measureCoords.getMeasure().getStartWidthRepetitions());
                            SongMixer.this.table.setSelection(n);
                            TuxGuitar.instance().redraw();
                            break;
                        }
                        n5 += n3;
                    }
                }
            }
        });
    }

    private void updateTable() {
        int n;
        int n2;
        List list = this.editor.getTablature().getSongCoords().getTrackCoords();
        int n3 = list.size();
        for (n2 = n = this.table.getItemCount(); n2 < n3; ++n2) {
            new TableItem(this.table, 0);
        }
        for (n2 = n; n2 > n3; --n2) {
            this.table.remove(n2 - 1);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(n2);
            String string = Integer.toString(n2 + 1);
            String string2 = songTrackCoords.getTrack().getName();
            String string3 = this.editor.getSongManager().getInstrumentName(songTrackCoords.getTrack().getInstrument());
            TableItem tableItem = this.table.getItem(n2);
            tableItem.setText(new String[]{string, string2, string3});
            tableItem.setData((Object)songTrackCoords);
        }
    }

    private void paintMeasures(GC gC, int n, int n2) {
        int n3 = this.trackMeasures.getBounds().width;
        int n4 = this.table.getHeaderHeight();
        int n5 = this.table.getItemHeight();
        int n6 = n;
        int n7 = n2 + this.table.getHeaderHeight();
        this.trackMeasuresHeader.setBounds(0, 0, n3, n4);
        this.trackMeasuresHeader.setText(this.editor.getSongManager().getSong().getName());
        boolean bl = this.editor.getSongManager().getPlayer().isRunning();
        List list = this.editor.getTablature().getSongCoords().getTrackCoords();
        int n8 = list.size();
        for (int i = 0; i < n8; ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)list.get(i);
            gC.setBackground(this.getDisplay().getSystemColor(15));
            gC.fillRectangle(0, n7, n3, n5 - 1);
            TrackColor trackColor = songTrackCoords.getTrack().getColor();
            Color color = new Color((Device)this.getDisplay(), trackColor.getR(), trackColor.getG(), trackColor.getB());
            gC.setBackground(color);
            List list2 = songTrackCoords.getMeasuresCoords();
            int n9 = list2.size();
            for (int j = 0; j < n9; ++j) {
                MeasureCoords measureCoords = (MeasureCoords)list2.get(j);
                gC.fillRectangle(n6, n7, n5 - 1, n5 - 1);
                if (bl && measureCoords.isPlaying() || !bl && measureCoords.hasCaret()) {
                    gC.setBackground(this.getDisplay().getSystemColor(2));
                    gC.fillRectangle(n6 + 4, n7 + 4, n5 - 9, n5 - 9);
                    gC.setBackground(color);
                }
                n6 += n5;
            }
            n6 = n;
            n7 += n5;
            color.dispose();
        }
        gC.setBackground(this.getDisplay().getSystemColor(2));
    }

    private int getSelectedTrackIndex(int n) {
        int n2 = this.table.getVerticalBar().getSelection();
        int n3 = this.table.getHeaderHeight();
        int n4 = this.table.getItemHeight();
        int n5 = -1;
        if (n > n3) {
            List list = this.editor.getTablature().getSongCoords().getTrackCoords();
            int n6 = list.size();
            int n7 = n3 - n2;
            for (int i = 0; i < n6; ++i) {
                if (n >= n7 && n < n7 + n4) {
                    n5 = i;
                    break;
                }
                n7 += n4;
            }
        }
        return n5;
    }

    public void updateScrolls() {
        int n = this.table.getHeaderHeight() + this.table.getItemCount() * this.table.getItemHeight();
        if (this.trackMeasures.getHorizontalBar().isVisible() || this.table.getHorizontalBar().isVisible()) {
            n += 20;
        }
        Rectangle rectangle = this.getClientArea();
        ScrollBar scrollBar = this.getVerticalBar();
        scrollBar.setMaximum(n);
        scrollBar.setThumb(Math.min(n, rectangle.height));
        int n2 = this.editor.getTablature().getCaret().getSongTrackCoords().getMeasuresCoords().size() * this.table.getItemHeight();
        rectangle = this.trackMeasures.getClientArea();
        ScrollBar scrollBar2 = this.trackMeasures.getHorizontalBar();
        scrollBar2.setMaximum(n2);
        scrollBar2.setThumb(Math.min(n2, rectangle.width));
    }

    public void loadProperties() {
        this.table.getColumn(0).setText(TuxGuitar.getProperty("track.number"));
        this.table.getColumn(1).setText(TuxGuitar.getProperty("track.name"));
        this.table.getColumn(2).setText(TuxGuitar.getProperty("track.instrument"));
    }
}

