/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.language;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Properties;
import org.herac.tuxguitar.gui.TuxGuitar;

public class LanguageManager {
    private Properties properties = new Properties();
    private String language;
    private String[] languages;

    public LanguageManager() {
        this.loadLanguages();
    }

    public void setLanguage(String string) {
        this.language = this.getLanguaje(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(this.getPathName() + File.separator + this.language + ".properties");
            this.properties.clear();
            this.properties.load(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string, string);
    }

    public String getLanguage() {
        return this.language;
    }

    public String[] getLanguages() {
        return this.languages;
    }

    private void loadLanguages() {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.indexOf(".properties") > 0;
            }
        };
        String[] stringArray = new File(this.getPathName()).list(filenameFilter);
        this.languages = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(".properties");
            if (n < 0) continue;
            this.languages[i] = stringArray[i].substring(0, n);
        }
    }

    private String getLanguaje(String string) {
        for (int i = 0; i < this.languages.length; ++i) {
            if (!this.languages[i].equals(string)) continue;
            return string;
        }
        if (this.languages.length > 0) {
            return this.languages[0];
        }
        return null;
    }

    private String getPathName() {
        return TuxGuitar.instance().getBasePath() + "lang";
    }
}

