/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.items.menu.CompositionMenuItem;
import org.herac.tuxguitar.gui.items.menu.DurationMenuItem;
import org.herac.tuxguitar.gui.items.menu.FileMenuItem;
import org.herac.tuxguitar.gui.items.menu.HelpMenuItem;
import org.herac.tuxguitar.gui.items.menu.LanguageMenuItem;
import org.herac.tuxguitar.gui.items.menu.LayoutMenuItem;
import org.herac.tuxguitar.gui.items.menu.MeasureMenuItem;
import org.herac.tuxguitar.gui.items.menu.NoteEffectsMenuItem;
import org.herac.tuxguitar.gui.items.menu.PlayMenuItem;
import org.herac.tuxguitar.gui.items.menu.TrackMenuItem;
import org.herac.tuxguitar.gui.items.tool.CompositionToolItems;
import org.herac.tuxguitar.gui.items.tool.DurationToolItems;
import org.herac.tuxguitar.gui.items.tool.FileToolItems;
import org.herac.tuxguitar.gui.items.tool.InsertToolItems;
import org.herac.tuxguitar.gui.items.tool.PlayerToolItems;
import org.herac.tuxguitar.gui.items.tool.RepeatToolItems;
import org.herac.tuxguitar.gui.items.tool.TiedNoteToolItems;

public class ItemContainerManager {
    private TablatureEditor tablatureEditor;
    private List items;

    public ItemContainerManager(TablatureEditor tablatureEditor) {
        this.tablatureEditor = tablatureEditor;
        this.items = new ArrayList();
    }

    public void createToolbar(Shell shell) {
        ToolBar toolBar = new ToolBar((Composite)shell, 0x800000);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        toolBar.setLayoutData((Object)formData);
        FileToolItems fileToolItems = new FileToolItems(this.tablatureEditor, toolBar);
        CompositionToolItems compositionToolItems = new CompositionToolItems(this.tablatureEditor, toolBar);
        DurationToolItems durationToolItems = new DurationToolItems(this.tablatureEditor, toolBar);
        RepeatToolItems repeatToolItems = new RepeatToolItems(this.tablatureEditor, toolBar);
        TiedNoteToolItems tiedNoteToolItems = new TiedNoteToolItems(this.tablatureEditor, toolBar);
        PlayerToolItems playerToolItems = new PlayerToolItems(this.tablatureEditor, toolBar);
        InsertToolItems insertToolItems = new InsertToolItems(this.tablatureEditor, toolBar);
        fileToolItems.showItems();
        new ToolItem(toolBar, 2);
        durationToolItems.showItems();
        new ToolItem(toolBar, 2);
        playerToolItems.showItems();
        new ToolItem(toolBar, 2);
        compositionToolItems.showItems();
        repeatToolItems.showItems();
        tiedNoteToolItems.showItems();
        new ToolItem(toolBar, 2);
        insertToolItems.showItems();
        this.items.add(fileToolItems);
        this.items.add(compositionToolItems);
        this.items.add(durationToolItems);
        this.items.add(repeatToolItems);
        this.items.add(tiedNoteToolItems);
        this.items.add(playerToolItems);
        this.items.add(insertToolItems);
    }

    public void createMenu(Shell shell) {
        Menu menu = new Menu((Decorations)shell, 2);
        FileMenuItem fileMenuItem = new FileMenuItem(shell, menu, 64, this.tablatureEditor);
        LayoutMenuItem layoutMenuItem = new LayoutMenuItem(shell, menu, 64, this.tablatureEditor);
        CompositionMenuItem compositionMenuItem = new CompositionMenuItem(shell, menu, 64, this.tablatureEditor);
        TrackMenuItem trackMenuItem = new TrackMenuItem(shell, menu, 64, this.tablatureEditor);
        MeasureMenuItem measureMenuItem = new MeasureMenuItem(shell, menu, 64, this.tablatureEditor);
        DurationMenuItem durationMenuItem = new DurationMenuItem(shell, menu, 64, this.tablatureEditor);
        NoteEffectsMenuItem noteEffectsMenuItem = new NoteEffectsMenuItem(shell, menu, 64, this.tablatureEditor);
        PlayMenuItem playMenuItem = new PlayMenuItem(shell, menu, 64, this.tablatureEditor);
        LanguageMenuItem languageMenuItem = new LanguageMenuItem(shell, menu, 64);
        HelpMenuItem helpMenuItem = new HelpMenuItem(shell, menu, 64);
        fileMenuItem.showItems();
        layoutMenuItem.showItems();
        compositionMenuItem.showItems();
        trackMenuItem.showItems();
        measureMenuItem.showItems();
        durationMenuItem.showItems();
        noteEffectsMenuItem.showItems();
        playMenuItem.showItems();
        languageMenuItem.showItems();
        helpMenuItem.showItems();
        shell.setMenuBar(menu);
        this.items.add(fileMenuItem);
        this.items.add(layoutMenuItem);
        this.items.add(compositionMenuItem);
        this.items.add(trackMenuItem);
        this.items.add(measureMenuItem);
        this.items.add(durationMenuItem);
        this.items.add(noteEffectsMenuItem);
        this.items.add(playMenuItem);
        this.items.add(languageMenuItem);
        this.items.add(helpMenuItem);
    }

    public void updateItems() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            ItemContainer itemContainer = (ItemContainer)iterator.next();
            itemContainer.update();
        }
    }

    public void loadProperties() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            ItemContainer itemContainer = (ItemContainer)iterator.next();
            itemContainer.loadProperties();
        }
    }
}

