/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.fretboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class FretBoard
extends Composite {
    public static final int MAX_FRETS = 24;
    private TablatureEditor editor;
    private Composite toolComposite;
    private Composite fretBoardComposite;
    private DurationImage[] images;
    private Image firstFretImage;
    private Image fretImage;
    private Label durationLabel;
    private Combo handSelector;
    private List components;
    private int[] frets;
    private int[] strings;
    private int fretSpan;
    private int stringSpan;

    public FretBoard(Composite composite, TablatureEditor tablatureEditor) {
        super(composite, 0);
        this.setLayout((Layout)new FormLayout());
        this.editor = tablatureEditor;
        this.initToolBar();
        this.initEditor();
        this.components = new ArrayList();
        this.layout(this.getDisplay().getBounds().width, 150, 1);
    }

    private void initToolBar() {
        this.toolComposite = new Composite((Composite)this, 0);
        this.toolComposite.setLayout((Layout)new GridLayout(3, true));
        Composite composite = new Composite(this.toolComposite, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Button button = new Button(composite, 16388);
        button.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("GO_LEFT"));
        Button button2 = new Button(composite, 131076);
        button2.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("GO_RIGHT"));
        Composite composite2 = new Composite(this.toolComposite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        Button button3 = new Button(composite2, 132);
        button3.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("DECREMENT_DURATION"));
        this.initDurationImages();
        this.durationLabel = new Label(composite2, 2048);
        this.durationLabel.setImage(this.getDurationImage());
        Button button4 = new Button(composite2, 1028);
        button4.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("INCREMENT_DURATION"));
        this.handSelector = new Combo(this.toolComposite, 0);
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(0);
        this.handSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = FretBoard.this.handSelector.getSelectionIndex();
                if (n == 0) {
                    FretBoard.this.initFrets(10, 1);
                } else {
                    FretBoard.this.initFrets(10, 2);
                }
                FretBoard.this.fretBoardComposite.redraw();
            }
        });
    }

    private void initEditor() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 50);
        formData.bottom = new FormAttachment(100, 0);
        this.fretBoardComposite = new Composite((Composite)this, 2048);
        this.fretBoardComposite.setLayoutData((Object)formData);
        this.fretBoardComposite.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        this.fretBoardComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FretBoard.this.paintEditor(paintEvent.gc);
            }
        });
        this.fretBoardComposite.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                FretBoard.this.hit(mouseEvent.x, mouseEvent.y);
                FretBoard.this.afterAction();
            }
        });
        this.initFretBoardImages();
    }

    private void initFretBoardImages() {
        this.firstFretImage = new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "firstfret.png"));
        this.fretImage = new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "fret.png"));
    }

    private void initDurationImages() {
        this.images = new DurationImage[7];
        this.images[0] = new DurationImage(new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "1.png")), 1);
        this.images[1] = new DurationImage(new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "2.png")), 2);
        this.images[2] = new DurationImage(new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "4.png")), 4);
        this.images[3] = new DurationImage(new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "8.png")), 8);
        this.images[4] = new DurationImage(new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "16.png")), 16);
        this.images[5] = new DurationImage(new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "32.png")), 32);
        this.images[6] = new DurationImage(new Image((Device)this.getDisplay(), TuxGuitar.getResourcePath((Object)this, "64.png")), 64);
    }

    private Image getDurationImage() {
        Duration duration = (Duration)this.editor.getTablature().getCaret().getDuration().clone();
        for (int i = 0; i < this.images.length; ++i) {
            if (this.images[i].getDurationValue() != duration.getValue()) continue;
            return this.images[i].getImage();
        }
        return this.durationLabel.getImage();
    }

    private void calculateFretSpan(int n) {
        this.fretSpan = n / 24;
        int n2 = 0;
        for (int i = 0; i < 24; ++i) {
            n2 += i * 2;
        }
        this.fretSpan += n2 / 24 + 2;
    }

    private void calculateStringSpan(int n) {
        this.stringSpan = n / 6;
    }

    private void initFrets(int n, int n2) {
        block3: {
            int n3;
            block2: {
                this.frets = new int[24];
                n3 = n;
                if (n2 != 1) break block2;
                for (int i = 0; i < this.frets.length; ++i) {
                    this.frets[i] = n3;
                    n3 += this.fretSpan - (i + 1) * 2;
                }
                break block3;
            }
            if (n2 != 2) break block3;
            for (int i = this.frets.length - 1; i >= 0; --i) {
                this.frets[i] = n3;
                n3 += this.fretSpan - i * 2;
            }
        }
    }

    private void initStrings(int n, int n2) {
        this.strings = new int[n2];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = n + this.stringSpan * i;
        }
    }

    private void updateEditor() {
        this.components.clear();
        Caret caret = this.editor.getTablature().getCaret();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        if (measureCoords != null) {
            this.components = measureCoords.getComponents(caret.getPosition());
        }
        if (this.strings.length != this.getStringCount()) {
            this.initStrings(10, this.getStringCount());
        }
        if (this.isVisible()) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = this.getClientArea().width;
            int n4 = this.getClientArea().height;
            if (n + 20 < n3 || n > n3) {
                this.layout(this.getClientArea().width, 150, this.handSelector.getSelectionIndex() + 1);
            }
            if (n2 < n4 || n2 + 10 > n4) {
                TuxGuitar.instance().showFretBoard();
            }
        }
    }

    private void paintEditor(GC gC) {
        this.updateEditor();
        if (this.frets.length > 0 && this.strings.length > 0) {
            int n;
            gC.setBackground(this.getDisplay().getSystemColor(2));
            gC.fillRectangle(this.getClientArea());
            gC.drawImage(this.firstFretImage, 0, 0, this.firstFretImage.getBounds().width, this.firstFretImage.getBounds().height, this.frets[0] - 5, this.strings[0] - 5, this.firstFretImage.getBounds().width, this.strings[this.strings.length - 1]);
            this.paintFretPoints(gC, 0);
            for (n = 1; n < this.frets.length; ++n) {
                gC.drawImage(this.fretImage, 0, 0, this.fretImage.getBounds().width, this.fretImage.getBounds().height, this.frets[n], this.strings[0] - 5, this.fretImage.getBounds().width, this.strings[this.strings.length - 1]);
                this.paintFretPoints(gC, n);
            }
            for (n = 0; n < this.strings.length; ++n) {
                gC.setForeground(new Color((Device)this.getDisplay(), 227, 217, 217));
                if (n > 2) {
                    gC.setLineWidth(2);
                }
                gC.drawLine(this.frets[0], this.strings[n], this.frets[this.frets.length - 1], this.strings[n]);
            }
            gC.setForeground(this.getDisplay().getSystemColor(9));
            gC.setLineWidth(10);
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                MeasureComponent measureComponent = (MeasureComponent)iterator.next();
                if (!(measureComponent instanceof NoteCoords)) continue;
                NoteCoords noteCoords = (NoteCoords)measureComponent;
                int n2 = noteCoords.getNote().getValue();
                int n3 = noteCoords.getNote().getString() - 1;
                if (n2 >= this.frets.length || n3 >= this.strings.length) continue;
                int n4 = this.frets[n2];
                if (n2 > 0) {
                    n4 -= (this.frets[n2] - this.frets[n2 - 1]) / 2;
                }
                int n5 = this.strings[n3] - 3;
                gC.drawOval(n4, n5, 5, 5);
            }
            gC.setLineWidth(1);
            gC.setForeground(this.getDisplay().getSystemColor(2));
        }
    }

    private void paintFretPoints(GC gC, int n) {
        gC.setForeground(this.getDisplay().getSystemColor(1));
        if (n + 1 < this.frets.length) {
            int n2;
            for (n2 = n + 1; n2 >= 12; n2 -= 12) {
            }
            if (n2 == 0) {
                gC.setLineWidth(10);
                int n3 = this.frets[n] + (this.frets[n + 1] - this.frets[n]) / 2;
                int n4 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 - this.stringSpan;
                int n5 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 + this.stringSpan;
                gC.drawOval(n3, n4 - 2, 5, 5);
                gC.drawOval(n3, n5 - 2, 5, 5);
                gC.setLineWidth(1);
            } else if (n2 == 3 || n2 == 5 || n2 == 7 || n2 == 9) {
                gC.setLineWidth(10);
                int n6 = this.frets[n] + (this.frets[n + 1] - this.frets[n]) / 2;
                int n7 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2;
                gC.drawOval(n6, n7 - 2, 5, 5);
                gC.setLineWidth(1);
            }
        }
    }

    private void hit(int n, int n2) {
        int n3;
        int n4 = this.getFretIndex(n);
        if (!this.removeNote(n4, (n3 = this.getStringIndex(n2)) + 1)) {
            this.addNote(n4, n3 + 1);
        }
    }

    private int getStringIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            int n3 = Math.abs(n - this.strings[n2]);
            int n4 = Math.abs(n - this.strings[i]);
            if (n4 >= n3) continue;
            n2 = i;
        }
        return n2;
    }

    private int getFretIndex(int n) {
        int n2 = this.frets.length;
        if (n - 10 <= this.frets[0] && this.frets[0] < this.frets[n2 - 1]) {
            return 0;
        }
        if (n + 10 >= this.frets[0] && this.frets[0] > this.frets[n2 - 1]) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (i + 1 >= n2 || (n <= this.frets[i] || n > this.frets[i + 1]) && (n <= this.frets[i + 1] || n > this.frets[i])) continue;
            return i + 1;
        }
        return n2 - 1;
    }

    private boolean removeNote(int n, int n2) {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Note note;
            MeasureComponent measureComponent = (MeasureComponent)iterator.next();
            if (!(measureComponent instanceof NoteCoords) || (note = ((NoteCoords)measureComponent).getNote()).getValue() != n || note.getString() != n2) continue;
            Caret caret = this.editor.getTablature().getCaret();
            caret.getMeasureCoords().removeNote(note);
            return true;
        }
        return false;
    }

    private int getStringCount() {
        return this.editor.getTablature().getCaret().getSongTrackCoords().getTrack().getStrings().size();
    }

    private void addNote(int n, int n2) {
        Caret caret = this.editor.getTablature().getCaret();
        Duration duration = (Duration)caret.getDuration().clone();
        Note note = new Note(n, caret.getPosition(), duration, 64, n2, false, new NoteEffect());
        caret.getMeasureCoords().addNote(note);
    }

    private void afterAction() {
        this.editor.getTablature().getViewLayout().fireUpdate(this.editor.getTablature().getCaret().getMeasureCoords().getMeasureId(), false);
        TuxGuitar.instance().redraw();
    }

    public void redraw() {
        super.redraw();
        this.fretBoardComposite.redraw();
        this.durationLabel.setImage(this.getDurationImage());
    }

    public void loadProperties() {
        this.handSelector.setItem(0, TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.setItem(1, TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.setText(this.handSelector.getItem(this.handSelector.getSelectionIndex()));
        this.layout();
    }

    public int getHeight() {
        return this.stringSpan * this.strings.length + this.toolComposite.getBounds().height + 6;
    }

    public int getWidth() {
        return this.frets[this.frets.length - 1];
    }

    public void layout() {
        super.layout();
    }

    public void layout(int n, int n2, int n3) {
        this.calculateFretSpan(n);
        this.calculateStringSpan(n2);
        this.initFrets(10, n3);
        this.initStrings(10, this.getStringCount());
    }

    private class DurationImage {
        private Image image;
        private int durationValue;

        public DurationImage(Image image, int n) {
            this.image = image;
            this.durationValue = n;
        }

        public int getDurationValue() {
            return this.durationValue;
        }

        public void setDurationValue(int n) {
            this.durationValue = n;
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }
    }
}

