/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.clipboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.clipboard.CannotInsertTransferException;
import org.herac.tuxguitar.gui.clipboard.Transferable;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MeasureTransferable
implements Transferable {
    private TablatureEditor tablatureEditor;
    private List measures;

    public MeasureTransferable(TablatureEditor tablatureEditor, long l, long l2) {
        this.tablatureEditor = tablatureEditor;
        this.measures = new ArrayList();
        this.getTransfer(l, l2);
    }

    private void getTransfer(long l, long l2) {
        SongTrackCoords songTrackCoords = this.tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        this.measures = songTrackCoords.copyMeasures(l, l2);
    }

    public void insertTransfer() throws CannotInsertTransferException {
        List list = null;
        MeasureCoords measureCoords = this.tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = this.tablatureEditor.getTablature().getCaret().getSongCoords();
        SongTrackCoords songTrackCoords = this.tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        if (measureCoords == null || songCoords == null || songTrackCoords == null || this.measures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        int n = measureCoords.getMeasureId();
        long l = measureCoords.getMeasure().getStart();
        Iterator iterator = this.tablatureEditor.getTablature().getSongCoords().getTrackCoords().iterator();
        while (iterator.hasNext()) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)iterator.next();
            list = songTrackCoords2.equals(songTrackCoords) ? this.getCloneMeasures(this.measures) : this.getEmptyMeasures(this.measures);
            this.moveStart(list, l);
            songTrackCoords2.insertMeasures(list, n);
        }
    }

    private void moveStart(List list, long l) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Measure measure = (Measure)iterator.next();
            long l2 = l - measure.getStart();
            Iterator iterator2 = measure.getNotes().iterator();
            while (iterator2.hasNext()) {
                object = (Note)iterator2.next();
                ((Note)object).setStart(((Note)object).getStart() + l2);
            }
            object = measure.getSilences().iterator();
            while (object.hasNext()) {
                Silence silence = (Silence)object.next();
                silence.setStart(silence.getStart() + l2);
            }
            measure.setStart(measure.getStart() + l2);
            l = measure.getStart() + measure.getLength();
        }
    }

    private List getCloneMeasures(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Measure measure = (Measure)iterator.next();
            arrayList.add(measure.clone());
        }
        return arrayList;
    }

    private List getEmptyMeasures(List list) {
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Measure measure = (Measure)iterator.next();
            long l = measure.getStart();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            boolean bl = measure.isRepeatStart();
            int n = measure.getNumberOfRepetitions();
            arrayList.add(new Measure(l, arrayList2, arrayList3, timeSignature, tempo, bl, n));
        }
        return arrayList;
    }
}

