/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.TrackColor;

public class ChangeTrackPropertiesAction
extends Action {
    public static final String NAME = "CHANGE_TRACK_PROPERTIES";
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private Shell dialog;
    private Text nameText;
    private TrackColor trackColor;
    private List tempStrings;
    private TunningSpinner[] stringSpinners = new TunningSpinner[7];
    private Spinner stringCountSpinner;
    private int stringCount;
    private Combo instrumentCombo;
    private Button percusionCheckBox;

    public ChangeTrackPropertiesAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        if (songTrackCoords != null) {
            this.stringCount = songTrackCoords.getTrack().getStrings().size();
            this.trackColor = (TrackColor)songTrackCoords.getTrack().getColor().clone();
            this.initTempStirngs(songTrackCoords.getTrack().getStrings());
            this.dialog = new Shell(shell, 67680);
            this.dialog.setLayout((Layout)new RowLayout(512));
            this.dialog.setText(TuxGuitar.getProperty("track.properties"));
            TabFolder tabFolder = new TabFolder((Composite)this.dialog, 0);
            tabFolder.setLayout((Layout)new RowLayout(512));
            tabFolder.setLayoutData((Object)new RowData(420, 150));
            Composite composite = null;
            TabItem tabItem = null;
            composite = new Composite((Composite)tabFolder, 0);
            composite.setLayout((Layout)new GridLayout(2, true));
            this.initTrackInfo(composite, songTrackCoords);
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(TuxGuitar.getProperty("track.properties.general"));
            tabItem.setControl((Control)composite);
            composite = new Composite((Composite)tabFolder, 0);
            composite.setLayout((Layout)new RowLayout(512));
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout(2, true));
            this.initStringSpinner(composite2);
            Composite composite3 = new Composite(composite, 0);
            composite3.setLayout((Layout)new RowLayout(256));
            this.initTunningSpinners(composite3);
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(TuxGuitar.getProperty("tunning"));
            tabItem.setControl((Control)composite);
            composite = new Composite((Composite)tabFolder, 0);
            composite.setLayout((Layout)new GridLayout(2, true));
            this.initInstrumentFields(composite, songTrackCoords);
            tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(TuxGuitar.getProperty("instrument.instrument"));
            tabItem.setControl((Control)composite);
            this.initButtons((Composite)this.dialog);
            tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    selectionEvent.doit = false;
                }
            });
            this.dialog.pack();
            this.dialog.open();
            int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
            this.dialog.setLocation(n, n2);
        }
    }

    private void initTrackInfo(Composite composite, SongTrackCoords songTrackCoords) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(100, 15));
        label.setText(TuxGuitar.getProperty("track.name"));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(100, 15));
        this.nameText.setText(songTrackCoords.getTrack().getName());
        Label label2 = new Label(composite, 0);
        label2.setText(TuxGuitar.getProperty("track.color"));
        final Button button = new Button(composite, 8);
        this.setButtonColor(button, new Color((Device)this.dialog.getDisplay(), this.trackColor.getR(), this.trackColor.getG(), this.trackColor.getB()));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(ChangeTrackPropertiesAction.this.dialog);
                colorDialog.setRGB(ChangeTrackPropertiesAction.this.dialog.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    ChangeTrackPropertiesAction.this.setButtonColor(button, new Color((Device)ChangeTrackPropertiesAction.this.dialog.getDisplay(), rGB));
                }
            }
        });
    }

    private void setButtonColor(Button button, Color color) {
        Image image = new Image((Device)this.dialog.getDisplay(), 25, 25);
        GC gC = new GC((Drawable)image);
        gC.setBackground(color);
        gC.fillRectangle(0, 0, 25, 25);
        button.setImage(image);
        gC.dispose();
        image.dispose();
        this.trackColor.setR(color.getRed());
        this.trackColor.setG(color.getGreen());
        this.trackColor.setB(color.getBlue());
    }

    private void initTunningSpinners(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(7, false));
        String[] stringArray = this.getAllValueNames();
        for (int i = 0; i < 7; ++i) {
            this.stringSpinners[i] = new TunningSpinner(composite2, 0);
            this.stringSpinners[i].setTexts(stringArray);
        }
        this.updateTunningSpinner();
    }

    private void initStringSpinner(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(TuxGuitar.getProperty("tunning.strings"));
        this.stringCountSpinner = new Spinner(composite, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 30;
        this.stringCountSpinner.setLayoutData((Object)gridData);
        this.stringCountSpinner.setMinimum(4);
        this.stringCountSpinner.setMaximum(7);
        this.stringCountSpinner.setSelection(this.stringCount);
        this.stringCountSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.stringCount = ChangeTrackPropertiesAction.this.stringCountSpinner.getSelection();
                ChangeTrackPropertiesAction.this.setDefaultTunning();
                ChangeTrackPropertiesAction.this.updateTunningSpinner();
            }
        });
    }

    private void initButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(50, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment(100, 0);
        composite3.setLayoutData((Object)formData);
        Button button = new Button(composite3, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData((Object)new GridData(99, 28));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.updateTrackProperties();
                new SyncThread(ChangeTrackPropertiesAction.this.getEditor(), new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        ChangeTrackPropertiesAction.access$900(4.access$800(this.this$1));
                        ChangeTrackPropertiesAction.access$1100(4.access$800(this.this$1)).getTablature().getCaret().update(ChangeTrackPropertiesAction.access$1000(4.access$800(this.this$1)).getTablature().getCaret().getMeasureCoords().getMeasure());
                        ChangeTrackPropertiesAction.access$1200(4.access$800(this.this$1));
                        ChangeTrackPropertiesAction.access$000(4.access$800(this.this$1)).dispose();
                    }
                }).start();
            }

            static /* synthetic */ ChangeTrackPropertiesAction access$800(4 var0) {
                return var0.ChangeTrackPropertiesAction.this;
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData((Object)new GridData(99, 28));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.dialog.dispose();
            }
        });
    }

    private void initInstrumentFields(Composite composite, SongTrackCoords songTrackCoords) {
        Instrument[] instrumentArray = this.getInstruments();
        SongTrack songTrack = songTrackCoords.getTrack();
        Label label = new Label(composite, 0);
        label.setText(TuxGuitar.getProperty("instrument.instrument"));
        this.instrumentCombo = new Combo(composite, 0);
        if (instrumentArray != null) {
            int n = instrumentArray.length;
            if (n > 128) {
                n = 128;
            }
            for (int i = 0; i < n; ++i) {
                instrumentArray[i].getName();
                this.instrumentCombo.add(instrumentArray[i].getName());
            }
            this.instrumentCombo.setText(instrumentArray[songTrack.getInstrument()].getName());
            this.instrumentCombo.setEnabled(!songTrack.isPercusionTrack());
        } else {
            this.instrumentCombo.setEnabled(false);
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.percusionCheckBox = new Button(composite, 32);
        this.percusionCheckBox.setText(TuxGuitar.getProperty("instrument.percusion-track"));
        this.percusionCheckBox.setLayoutData((Object)gridData);
        if (instrumentArray != null) {
            this.percusionCheckBox.setSelection(songTrack.isPercusionTrack());
            this.percusionCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ChangeTrackPropertiesAction.this.instrumentCombo.setEnabled(!ChangeTrackPropertiesAction.this.percusionCheckBox.getSelection());
                }
            });
        } else {
            this.percusionCheckBox.setEnabled(false);
        }
    }

    private Instrument[] getInstruments() {
        Instrument[] instrumentArray = null;
        Soundbank soundbank = this.getEditor().getSongManager().getPlayer().getDefaultSoundbank();
        if (soundbank != null) {
            instrumentArray = soundbank.getInstruments();
        }
        return instrumentArray;
    }

    private void updateTrackProperties() {
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        songTrackCoords.changeInfo(this.nameText.getText(), this.trackColor);
        songTrackCoords.changeInstrument(this.instrumentCombo.getSelectionIndex(), this.percusionCheckBox.getSelection());
        int n = 1;
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        for (int i = this.stringCount - 1; i >= 0; --i) {
            arrayList.add(new InstrumentString(n, this.stringSpinners[i].getSelection()));
            ++n;
        }
        songTrackCoords.changeInstrumentStrings(arrayList);
    }

    private void updateTunningSpinner() {
        int n = this.tempStrings.size() - 1;
        Iterator iterator = this.tempStrings.iterator();
        while (iterator.hasNext()) {
            InstrumentString instrumentString = (InstrumentString)iterator.next();
            this.stringSpinners[n].setSelection(instrumentString.getValue());
            this.stringSpinners[n].setVisible(true);
            --n;
        }
        for (int i = this.tempStrings.size(); i < 7; ++i) {
            this.stringSpinners[i].setSelection(0);
            this.stringSpinners[i].setVisible(false);
        }
    }

    private void initTempStirngs(List list) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            InstrumentString instrumentString = (InstrumentString)list.get(i);
            this.tempStrings.add(instrumentString.clone());
        }
    }

    private void setDefaultTunning() {
        this.tempStrings.clear();
        switch (this.stringCount) {
            case 7: {
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                this.tempStrings.add(new InstrumentString(7, 35));
                break;
            }
            case 6: {
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                break;
            }
            case 5: {
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
                this.tempStrings.add(new InstrumentString(5, 23));
                break;
            }
            case 4: {
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
            }
        }
    }

    private String[] getAllValueNames() {
        String[] stringArray = new String[120];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getValueName(i);
        }
        return stringArray;
    }

    private String getValueName(int n) {
        String string = null;
        int n2 = n / 12;
        switch (n -= n2 * 12) {
            case 0: {
                string = "C";
                break;
            }
            case 1: {
                string = "C#";
                break;
            }
            case 2: {
                string = "D";
                break;
            }
            case 3: {
                string = "D#";
                break;
            }
            case 4: {
                string = "E";
                break;
            }
            case 5: {
                string = "F";
                break;
            }
            case 6: {
                string = "F#";
                break;
            }
            case 7: {
                string = "G";
                break;
            }
            case 8: {
                string = "G#";
                break;
            }
            case 9: {
                string = "A";
                break;
            }
            case 10: {
                string = "Bb";
                break;
            }
            case 11: {
                string = "B";
            }
        }
        return string + n2;
    }

    static /* synthetic */ void access$900(ChangeTrackPropertiesAction changeTrackPropertiesAction) {
        changeTrackPropertiesAction.updateTablature();
    }

    static /* synthetic */ TablatureEditor access$1000(ChangeTrackPropertiesAction changeTrackPropertiesAction) {
        return changeTrackPropertiesAction.getEditor();
    }

    static /* synthetic */ TablatureEditor access$1100(ChangeTrackPropertiesAction changeTrackPropertiesAction) {
        return changeTrackPropertiesAction.getEditor();
    }

    static /* synthetic */ void access$1200(ChangeTrackPropertiesAction changeTrackPropertiesAction) {
        changeTrackPropertiesAction.redraw();
    }

    private class TunningSpinner
    extends Composite {
        private Text text;
        private Composite buttonComposite;
        private Button upButton;
        private Button downButton;
        private String[] texts;
        private int maxSelection;
        private int minSelection;
        private int selection;

        public TunningSpinner(Composite composite, int n) {
            super(composite, n);
            this.setLayout(this.createLayout(2));
            this.init();
        }

        private void init() {
            this.text = new Text((Composite)this, 2048);
            this.text.setLayoutData((Object)new GridData(30, 22));
            this.buttonComposite = new Composite((Composite)this, 0);
            this.buttonComposite.setLayout(this.createLayout(1));
            this.upButton = new Button(this.buttonComposite, 132);
            this.upButton.setLayoutData((Object)new GridData(15, 15));
            this.downButton = new Button(this.buttonComposite, 1028);
            this.downButton.setLayoutData((Object)new GridData(15, 15));
            this.selection = 0;
            this.minSelection = 0;
            this.maxSelection = 0;
            this.text.setEditable(false);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ TunningSpinner this$1;
                {
                    this.this$1 = tunningSpinner;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.setSelection(TunningSpinner.access$1500(this.this$1) + 1);
                }
            });
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ TunningSpinner this$1;
                {
                    this.this$1 = tunningSpinner;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    this.this$1.setSelection(TunningSpinner.access$1500(this.this$1) - 1);
                }
            });
        }

        private Layout createLayout(int n) {
            GridLayout gridLayout = new GridLayout(n, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            return gridLayout;
        }

        public void setTexts(String[] stringArray) {
            this.texts = stringArray;
            this.minSelection = 0;
            this.maxSelection = stringArray.length - 1;
        }

        public int getSelection() {
            return this.selection;
        }

        public void setSelection(int n) {
            if (n >= this.minSelection && n <= this.maxSelection) {
                this.selection = n;
                if (this.texts != null) {
                    this.text.setText(this.texts[n]);
                }
            }
        }

        static /* synthetic */ int access$1500(TunningSpinner tunningSpinner) {
            return tunningSpinner.selection;
        }
    }
}

