/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.mouse;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;

public class SelectComponentAction
extends Action {
    public static final String NAME = "SELECT_COMPONENT";

    public SelectComponentAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        if (typedEvent instanceof MouseEvent) {
            MeasureCoords measureCoords;
            MouseEvent mouseEvent = (MouseEvent)typedEvent;
            SongTrackCoords songTrackCoords = this.getTrackCoords(mouseEvent.y);
            if (songTrackCoords != null && (measureCoords = this.getMeasureCoords(songTrackCoords, mouseEvent.x, mouseEvent.y)) != null) {
                MeasureComponent measureComponent = this.getMeasureComponent(measureCoords, mouseEvent.x);
                InstrumentString instrumentString = this.getMeasureString(measureCoords, mouseEvent.y);
                if (measureComponent != null) {
                    this.getEditor().getTablature().getCaret().moveTo(songTrackCoords, measureCoords, measureComponent);
                    if (instrumentString != null) {
                        this.getEditor().getTablature().getCaret().setStringNumber(instrumentString.getNumber());
                    }
                    this.getEditor().getTablature().getSongManager().getPlayer().setTickPosition(measureCoords.getMeasure().getStartWidthRepetitions());
                    this.redraw();
                }
            }
            return true;
        }
        return false;
    }

    private SongTrackCoords getTrackCoords(int n) {
        return this.getEditor().getTablature().getSongCoords().getTrackAt(n, -this.getEditor().getTablature().getVerticalBar().getSelection());
    }

    private MeasureCoords getMeasureCoords(SongTrackCoords songTrackCoords, int n, int n2) {
        return songTrackCoords.getMeasureAt(n, n2, -this.getEditor().getTablature().getHorizontalBar().getSelection(), -this.getEditor().getTablature().getVerticalBar().getSelection());
    }

    private MeasureComponent getMeasureComponent(MeasureCoords measureCoords, int n) {
        return measureCoords.getComponentAt(n);
    }

    private InstrumentString getMeasureString(MeasureCoords measureCoords, int n) {
        return measureCoords.getStringAt(n);
    }
}

