/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.chord.ChordEditor;
import org.herac.tuxguitar.gui.chord.ChordList;
import org.herac.tuxguitar.gui.chord.ChordSelector;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class InsertChordAction
extends Action {
    public static final String NAME = "INSERT_CHORD";
    private ChordEditor editor;
    private ChordSelector selector;
    private ChordList list;

    public InsertChordAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showInsertDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
        this.redraw();
    }

    public void showInsertDialog(Shell shell) {
        Caret caret = this.getEditor().getTablature().getCaret();
        final SongTrackCoords songTrackCoords = caret.getSongTrackCoords();
        final MeasureCoords measureCoords = caret.getMeasureCoords();
        final MeasureComponent measureComponent = caret.getSelectedComponent();
        if (songTrackCoords != null && measureCoords != null && measureComponent != null) {
            final Shell shell2 = new Shell(shell, 67680);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.verticalSpacing = 10;
            gridLayout.horizontalSpacing = 10;
            shell2.setLayout((Layout)gridLayout);
            shell2.setText(TuxGuitar.getProperty("chord.editor"));
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.selector = new ChordSelector(composite, 0);
            this.editor = new ChordEditor(composite, 2048, (short)caret.getSongTrackCoords().getTrack().getStrings().size());
            this.editor.setLayoutData(new GridData(this.editor.getWidth() + 60, this.editor.getHeight() + 60));
            this.setCurrentChord();
            this.list = new ChordList((Composite)shell2);
            this.selector.setEditor(this.editor);
            this.selector.setList(this.list);
            this.selector.setTunning(this.getTunning(songTrackCoords));
            this.list.setEditor(this.editor);
            Composite composite2 = new Composite((Composite)shell2, 0);
            composite2.setLayout((Layout)new GridLayout(2, false));
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 3;
            composite2.setLayoutData((Object)gridData);
            Button button = new Button(composite2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData((Object)new GridData(128));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    InsertChordAction.this.insertChord(InsertChordAction.this.editor, songTrackCoords, measureCoords, measureComponent);
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
        }
    }

    private int[] getTunning(SongTrackCoords songTrackCoords) {
        int[] nArray = new int[songTrackCoords.getTrack().getStrings().size()];
        Iterator iterator = songTrackCoords.getTrack().getStrings().iterator();
        while (iterator.hasNext()) {
            InstrumentString instrumentString = (InstrumentString)iterator.next();
            nArray[nArray.length - instrumentString.getNumber()] = instrumentString.getValue();
        }
        return nArray;
    }

    private void insertChord(ChordEditor chordEditor, SongTrackCoords songTrackCoords, MeasureCoords measureCoords, MeasureComponent measureComponent) {
        measureCoords.removeAllComponentsAt(measureComponent.getStart());
        Iterator iterator = songTrackCoords.getTrack().getStrings().iterator();
        while (iterator.hasNext()) {
            InstrumentString instrumentString = (InstrumentString)iterator.next();
            int n = chordEditor.getValue(instrumentString.getNumber());
            if (n < 0) continue;
            measureCoords.addNote(new Note(n, measureComponent.getStart(), (Duration)measureComponent.getDuration().clone(), 64, instrumentString.getNumber(), false, new NoteEffect()));
        }
        this.fireUpdate(measureCoords.getMeasureId());
        this.redraw();
    }

    private void setCurrentChord() {
        Caret caret = this.getEditor().getTablature().getCaret();
        if (caret.getSelectedComponent() instanceof NoteCoords) {
            NoteCoords noteCoords;
            MeasureComponent measureComponent;
            int n = -1;
            int n2 = -1;
            List list = caret.getMeasureCoords().getComponents(caret.getSelectedComponent().getStart());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                measureComponent = (MeasureComponent)iterator.next();
                if (!(measureComponent instanceof NoteCoords)) continue;
                noteCoords = (NoteCoords)measureComponent;
                if (n < 0 || n < noteCoords.getNote().getValue()) {
                    n = noteCoords.getNote().getValue();
                }
                if (n2 >= 0 && n2 <= noteCoords.getNote().getValue()) continue;
                n2 = noteCoords.getNote().getValue();
            }
            if (n > 6 && n2 >= 0) {
                this.editor.setFret((short)n2);
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                measureComponent = (MeasureComponent)iterator.next();
                if (!(measureComponent instanceof NoteCoords)) continue;
                noteCoords = (NoteCoords)measureComponent;
                this.editor.addValue(noteCoords.getNote().getValue(), noteCoords.getNote().getString());
            }
        }
    }
}

